#ifndef __DAQBuilderPopupLogo_HH
#define __DAQBuilderPopupLogo_HH
#include <System/DAQBuilderThread.hh>

namespace DAQBuilder
{
  class PopupLogo : public Thread
  {
  private:
    DString                    _xpmFile;
    DBool                      _isInstanceized;
    DInt                       _showTime;
    Display                  * _logoDisplay;
    Window                     _logoWindow;
    Pixmap                     _logoPixmap;
  protected:
    virtual  void              _setType();
    virtual  void              _setParentClasses();
  public:
    PopupLogo( const DString& _xpmFile , const DInt& _showTime=1 );
    PopupLogo( const PopupLogo& right );
    virtual ~PopupLogo();
    virtual PopupLogo& operator=( const PopupLogo& right);
  public:
    virtual  const DString     toString() const ;
    virtual  void              run();
    virtual  void              show();
  };
}
#endif
