#include <Util/DAQBuilderRandomEngine.hh>
#include <Primitives/DAQBuilderString.hh>
namespace DAQBuilder
{
  const DString RandomEngine::_toString() const 
  {
    DString aString = _toStringHeader();
    aString += "RandomMax : ";
    aString += String::digitToString((DLong)_randomMax);
    aString += "\n";
    aString += "Seed      : ";
    aString += String::digitToString((DLong)_seed);
    aString += "\n";
    aString += "UpperLimit: ";
    aString += String::digitToString((DLong)_upperLimit);
    aString += "\n";
    aString += "LowerLimit: ";
    aString += String::digitToString((DLong)_lowerLimit);
    aString += "\n";
    aString += "=====================\n";
    aString += _toStringFooter();
    return aString;
  }
  RandomEngine::RandomEngine( DLong randomMax )
    :_randomMax(randomMax)
  {
    _setType();
    _setParentClasses();
    setSeed();
    setRange();
  }
  RandomEngine::~RandomEngine()
  {;}
  
  void             RandomEngine:: setSeed(DUInt _seed )
  {
    this -> _seed = _seed;
  }
  
  DUInt     RandomEngine:: getSeed() const 
  {
    return this -> _seed;
  }
  
  void             RandomEngine:: setRange(DLong _lowerLimit, DLong _upperLimit)
  {
    if( _upperLimit == RAND_MAX )
      {
	_upperLimit = this -> _randomMax;
      }
    if(_lowerLimit ==  _upperLimit )
      {
	this -> _lowerLimit = _lowerLimit ;
	this -> _upperLimit = _upperLimit+1;
      }
    else if(_lowerLimit <  _upperLimit )
      {
	this -> _lowerLimit = _lowerLimit ;
	this -> _upperLimit = _upperLimit ;
      }
    else 
      {
	this -> _lowerLimit = _upperLimit ;
	this -> _upperLimit = _lowerLimit ;
      }
  }
  
  DLong RandomEngine:: getRandom()
  {
    if(this -> _seed == 0 )
      {
	struct timeval  tv;
	::gettimeofday(&tv,NULL);
	::srand((DUInt)tv.tv_usec);
      }
    else 
      {
	srand( this -> _seed );
      }
    DLong range = this -> _upperLimit - this -> _lowerLimit;
    return (DLong)( this -> _lowerLimit + (DInt)(((DDouble)range-2.0) * ::rand()/ this -> _randomMax+1.0));
  }
}
