#ifndef  _DAQBuilderRandomEngine_HH
#define  _DAQBuilderRandomEngine_HH
#include <DAQBuilderObject.hh>
namespace DAQBuilder
{
  class RandomEngine : public Object
  {
  protected : 
    const DLong _randomMax ;
    DUInt       _seed;
    DLong       _upperLimit;
    DLong       _lowerLimit;
  protected:
    virtual void _finalize();
    virtual void _setType();
    virtual void _setParentClasses();
    virtual const DString  _toString() const;
  public   :
    RandomEngine( DLong _randomMax = RAND_MAX);
    virtual ~RandomEngine();
    void             setSeed(DUInt _seed = 0);
    DUInt    getSeed() const ;
    void             setRange(DLong _lowerLimit =1 , DLong _upperLimit = RAND_MAX);
    virtual DLong getRandom();
  };
  inline void RandomEngine::_finalize()
  {;}
  inline void RandomEngine::_setType()
  {
    this -> _type = "RandomEngine";
  }
  inline void RandomEngine::_setParentClasses()
  {
    _parentClasses.insert("Object");
  }
}
#endif
