#include <Util/DAQBuilderSmartPointer.hh>
#include <Primitives/DAQBuilderString.hh>
//#include <System/DAQBuilderSystem.hh>
namespace DAQBuilder 
{
  DBool             SmartPointer::equals( const SmartPointer & o )     const 
  {
    return _heldObject == o._heldObject;
  }
  
  DBool             SmartPointer::equals( const Object   * o )     const 
  {
    if(!findParent(_type,o))
      return false;
    return equals(*((SmartPointer*)o));
  }
  DBool         SmartPointer::operator   ==( const SmartPointer& right  ) const 
  {
     return equals(right);
  }
     DBool         SmartPointer::operator   !=( const SmartPointer& right  ) const 
  {
     return !equals(right);
  }
  
  SmartPointer::SmartPointer( Object * heldObject  )
    :Object(),_heldObject(heldObject)
  {
    _setType();
    _setParentClasses();
  }
  SmartPointer::SmartPointer( Object & heldObject  )
    :Object(),_heldObject(&heldObject)
  {
    _setType();
    _setParentClasses();
  }
  SmartPointer::SmartPointer( const SmartPointer & right )
    :Object(*((Object*)&right))
     ,_heldObject(right._heldObject)
  {
    _countUp();
  }
  void              SmartPointer::_countUp()
  {
    if(!isNull()){
      /*std::cout<<_heldObject->getType();
      std::cout<<"Count ";
      std::cout<<_heldObject->getReferenceCount();
      std::cout<<" -> ";
      */
      _heldObject -> _upReferenceCount();
      //std::cout<<_heldObject->getReferenceCount()<<std::endl;;
    }
  }
  void              SmartPointer::_countDown()
  {
    if(!isNull()){
      /*std::cout<<_heldObject->getType();
      std::cout<<" Count ";
      std::cout<<_heldObject->getReferenceCount();
      std::cout<<" -> ";
      */
      _heldObject -> _downReferenceCount();
      //std::cout<<_heldObject->getReferenceCount()<<std::endl;;
      if( _heldObject -> getReferenceCount() == 0  ){
      //std::cout<<"Delete ...";
        delete _heldObject;
      //std::cout<<"...[OK]\n";
        _heldObject = NULL;
        return ;
      }
    }
  }
  SmartPointer::~SmartPointer()
  {
    //std::cout<<"_coundDown..";
    _countDown();
    //std::cout<<"..[OK]\n";
    //std::cout<<"_finalize..";
    //_finalize();
    //std::cout<<"..[OK]\n";
  }
  
  SmartPointer& SmartPointer::operator   =(const SmartPointer & right )
  {
    *((Object*)this)  =    *((Object*)&right);
    if((&right) != this && _heldObject != right._heldObject )
      {
    //std::cout<<"_coundDown..";
    _countDown();
    //std::cout<<"..[OK]\n";
    //std::cout<<"_heldObject = right";
    _heldObject = right._heldObject;
    //std::cout<<"..[OK]\n";
    //std::cout<<"_countUp()";
    _countUp();
    //std::cout<<"..[OK]\n";
      }
    return *this;
  }
  
  SmartPointer& SmartPointer::operator   =(Object   * right )
  {
    //std::cout<<"_coundDown..";
    _countDown();
    /*std::cout<<"..[OK]\n";
    std::cout<<"_heldObject = right";
     */    
    _heldObject = right;
    /*std::cout<<"..[OK]\n";
    std::cout<<"_countUp()";
    */
    _countUp();
    //std::cout<<"..[OK]\n";
    return *this;
  }
  SmartPointer& SmartPointer::operator   =(Object   & right )
  {
    //std::cout<<"_coundDown..";
    _countDown();
    /*std::cout<<"..[OK]\n";
    std::cout<<"_heldObject = right";
    */
    _heldObject = &right;
    //std::cout<<"..[OK]\n";
    //std::cout<<"_countUp()";
    _countUp();
    //std::cout<<"..[OK]\n";
    return *this;
  }
  
  Object&       SmartPointer::operator*()
    throw(NullPointerException * )
  {
    if(isNull()){
      NullPointerException * e 
	= new NullPointerException("Pointer _heldObject is NULL ");
      e -> insert("Location","SmartPointer::operator*()");
      throw e;
    }
    return *_heldObject;
  }
  
  const Object& SmartPointer::operator*() const 
    throw(NullPointerException * )
  {
    if(isNull()){
      NullPointerException * e 
	= new NullPointerException("Pointer _heldObject is NULL ");
      e -> insert("Location","SmartPointer::operator*() const ");
      throw e;
    }
    return *_heldObject;
  }
  
  Object*       SmartPointer::operator->()
    throw(NullPointerException * )
  {
    if(isNull()){
      NullPointerException * e 
	= new NullPointerException("Pointer _heldObject is NULL ");
      e -> insert("Location","SmartPointer::operator->()");
      throw e;
    }
    return _heldObject;
  }
  const Object* SmartPointer::operator->() const 
    throw(NullPointerException * )
  {
    if(isNull()){
      NullPointerException * e 
	= new NullPointerException("Pointer _heldObject is NULL ");
      e -> insert("Location","SmartPointer::operator->() const");
      throw e;
    }
    return _heldObject;
  }
  
  Object*       SmartPointer::get()
  {
    return _heldObject;
  }
  const Object* SmartPointer::get() const 
  {
    return _heldObject;
  }
  const DString     SmartPointer::toString() const
  {
    DString aString;
    if(!isNull())
      aString += _heldObject->toString();
    return aString;
  }  
  DBool         SmartPointer::isNull() const 
  {
    return _heldObject == NULL;
  }
}
