#ifndef __DAQBuilderSmartPointer_HH__
#define __DAQBuilderSmartPointer_HH__
#include <DAQBuilderObject.hh>
#include <Exception/DAQBuilderNullPointerException.hh>

namespace DAQBuilder 
{
  class SmartPointer : public Object 
  {
  protected:
      void              _setType();
      void              _setParentClasses();
  protected:
    Object    *                _heldObject;
  public:
      DBool             equals( const SmartPointer & o )     const ;
      DBool             equals( const Object   * o )         const ;
  public :
    explicit SmartPointer( Object * _heldObject = NULL );
    explicit SmartPointer( Object & _heldObject);
    SmartPointer( const SmartPointer & _right );
     ~SmartPointer();
  protected:
    void                      _countDown();
    void                      _countUp();
  public:    
     SmartPointer& operator   =(const SmartPointer & right );
     SmartPointer& operator   =(Object         * right );
     SmartPointer& operator   =(Object         & right );
     DBool         operator   ==( const SmartPointer& right  ) const ;
     DBool         operator   !=( const SmartPointer& right  ) const ;

    Object&       operator*() 
      throw(NullPointerException * );
    const Object& operator*() const 
      throw(NullPointerException * );

    Object*       operator->()
      throw(NullPointerException * );
    const Object* operator->() const 
      throw(NullPointerException * );

  public:
    const DString     toString() const;
    Object*       get();
    const Object* get() const ;
    DBool         isNull() const ;
  };
  inline void   SmartPointer::_setParentClasses()
  {
    _parentClasses.insert("Object");
  }
  inline void   SmartPointer::_setType()
  {
    this -> _type = "SmartPointer";
  }
}
#endif
