#include <UserInterface/DAQBuilderConsoleUserInterface.hh>
#include <System/IO/DAQBuilderFileInputStream.hh>
#include <System/IO/DAQBuilderBufferedInputStream.hh>
#include <System/DAQBuilderRawAudioSystem.hh>
#include <System/DAQBuilderSystem.hh>
#include <System/DAQBuilderThreadRegistry.hh>
#include <System/DAQBuilderRunRegistry.hh>
#include <DataRecord/DAQBuilderDataRecordSerializableObjects.hh>
#include <Primitives/DAQBuilderPrimitivesSerializableObjects.hh>
#include <Command/DAQBuilderCommands.hh>
#include <Util/DAQBuilderPopupLogo.hh>

using namespace DAQBuilder;
int main( int argc , char ** argv , char ** envv )
{
  enum{Command,NumArgs};  
  if(argc != NumArgs){
  std :: cout << "Usage :: "<<argv[Command]<<std::endl;
    return 0;
 }
  try{
    /* Boot Sound  */
    DString bootPath = System::getProperty("DAQBUILDER_ROOT");
    bootPath +="/Source/Util/Sound/dbshutdown.wav";
    FileInputStream bfi(bootPath);
    BufferedInputStream bbi(&bfi,102400);
    RawAudioSystem      bra(&bbi,8);
    /*  Boot Logo   */
    DString logoPath = System::getProperty("DAQBUILDER_ROOT");
    logoPath +="/Source/Util/Image/dblogo.xpm";
    PopupLogo           pLogo(logoPath,3);
    pLogo.show();
    bra.play(1);
    pLogo.join();

    ConsoleUserInterface cui("[DAQ-Builder CUI]$ ");

    cui.start();
    cui.join();
    RunRegistry::shutdown();
    ThreadRegistry::shutdown();

  }catch( Exception * e ){
    std::cout<< e << std::endl;
    deleteObject((Object*)e);
  }
  return EXIT_SUCCESS;
}
