# 遺跡・第一階層

@name = "第一階層"
@bgm = :Dungeon1
@width = 40
@height = 40



in_region(:Entrance){
	treasure_level 1
	appearing_enemy 40, :SmallVine
	appearing_enemy 35, :Bandit
	appearing_enemy 10, :SmallVine, :Bandit
	appearing_enemy 10, :SmallVine, :SmallVine
	appearing_enemy 5, :Bandit, :Bandit

	set_wall(10, 1, DIR_N, Area::EXIT_DOOR)
	pset_route(10, 1, 10, 5)
	pset_route(8, 5, 12, 5); pset_route(8, 5, 8, 10); pset_route(12, 5, 12, 10)
	set_tereport_point(10, 2)

	# 真ん中ルート
	set_room(10, 6, 2, 2, TRT::WEAPON, EA::LITTLE); set_door(10, 6, DIR_N); set_door(11, 7, DIR_S)
	set_route(10, 8, 2, 3); set_wall_area(11, 10, 1, 1)
	set_door(10, 10, DIR_W); set_door(10, 10, DIR_E)
	
	# -> 西側の扉
	pset_route(9, 9, 9, 11)
	pset_route(5, 11, 9, 11); pset_route(5, 6, 5, 11); set_door(5, 6, DIR_E)
	set_room(6, 5, 2, 2, TRT::ACCESSORY); set_wall_area(6, 5, 1, 1)
	
	# -> 東側の扉
	pset_route(11, 10, 11, 12); set_route(10, 11, 3, 2)
	pset_route(11, 12, 17, 12); pset_route(5, 12, 11, 12)
	
	#   -> 広い通路を東
	set_door(17, 12, DIR_E); pset_route(18, 12, 20, 13); pset_route(20, 13, 20, 14)
	set_locked_door(20, 14, DIR_S, 'grave_s', :KeyOfGraveKeeper)
	
	
	# 西の小部屋
	set_door(8, 8, DIR_W); pset_room(6, 7, 7, 8, TRT::ARMOR)
	set_door(8, 10, DIR_W); pset_room(6, 9, 7, 10, TRT::ACCESSORY)
	
	
	# 東の通路
	pset_route(12, 10, 13, 10); set_door(13, 10, DIR_E)
	set_room(14, 9, 3, 2, TRT::ITEM, EA::LITTLE); set_door(16, 9, DIR_E)

	pset_route(15, 8, 17, 8); pset_route(17, 8, 17, 11)
	pset_route(13, 11, 20, 11); pset_route(20, 10, 20, 11)
	set_door(13, 11, DIR_S)
	
	set_route(13, 7, 2, 2); set_door(14, 8, DIR_E)
	set_room(13, 5, 2, 2, TRT::WEAPON); set_wall_area(14, 5, 1, 1); set_door(13, 6, DIR_S)
	
	set_locked_door(20, 10, DIR_N, 'grave_n', :KeyOfGraveKeeper)
	
}

# 西の離れ
in_region(:WestAnnex){
	treasure_level 1
	appearing_enemy 30, :SmallVine
	appearing_enemy 20, :SmallVine, :SmallVine
	appearing_enemy 30, :SpiritHead
	appearing_enemy 20, :SpiritHead, :SmallVine


	
	set_door(5, 12, DIR_S)
	pset_route(5, 13, 5, 14); pset_route(3, 14, 5, 14); pset_route(3, 14, 3, 16)
	set_route(3, 17, 2, 2); set_door(3, 17, DIR_N)
	
	set_door(3, 18, DIR_S); set_route(3, 19, 1, 2); set_route(3, 20, 2, 1); set_route(4, 20, 1, 2)
	set_door(4, 21, DIR_S); set_room(3, 22, 2, 2, TRT::ARMOR, EA::MUCH)
	
	set_door(4, 18, DIR_E); pset_route(5, 18, 7, 18); pset_route(7, 18, 7, 22)
	
	# 三つの扉
	set_door(7, 18, DIR_E); set_room(8, 18, 2, 2, TRT::ITEM)
	set_door(7, 20, DIR_E); set_room(8, 20, 2, 2, TRT::ITEM)
	set_door(7, 22, DIR_E); set_room(8, 22, 2, 2, TRT::ITEM, EA::LITTLE)
	
	# -> 墓守の部屋
	set_door(9, 23, DIR_E); pset_route(10, 22, 10, 23)
	set_door(10, 22, DIR_N)
}

in_region(:KeyOfGraveKeeperRoom){
	set_route(10, 21, 1, 1)
}


# 東の離れ
in_region(:EastAnnex){
	treasure_level 2
	appearing_enemy 30, :Bandit, :SmallVine
	appearing_enemy 35, :Bandit
	appearing_enemy 15, :StraySorcerer
	appearing_enemy 15, :Imp

	
	pset_route(20, 7, 20, 9); pset_route(16, 7, 20, 7)
	set_room(18, 8, 2, 2, TRT::ACCESSORY); set_door(18, 8, DIR_N)


	set_door(16, 7, DIR_N)
	pset_route(16, 6, 18, 6); pset_route(16, 3, 16, 6); pset_route(16, 3, 19, 3)
	set_room(17, 4, 3, 2, TRT::ARMOR, EA::LITTLE)
	set_door(18, 5, DIR_S); set_door(19, 4, DIR_N); set_door(19, 5, DIR_S)
	
	pset_route(19, 6, 21, 6); pset_route(21, 6, 21, 9); pset_route(21, 9, 23, 9)
	set_door(23, 9, DIR_S); set_route(23, 10, 4, 1); set_route(24, 10, 3, 2)
	set_door(24, 11, DIR_W); set_room(22, 10, 1, 2, TRT::ITEM); set_room(22, 11, 2, 1, TRT::ITEM)
	
	set_door(26, 10, DIR_N); pset_route(24, 9, 26, 9); pset_route(24, 7, 24, 9)
	set_door(24, 8, DIR_W); set_room(22, 7, 2, 2, TRT::WEAPON)
	set_door(24, 7, DIR_E); pset_route(25, 7, 27, 8)
	pset_route(27, 7, 27, 12); pset_route(22, 12, 27, 12)
	
	set_door(23, 12, DIR_S); set_room(22, 13, 3, 2, TRT::ITEM); set_room(23, 14, 1, 2, TRT::ITEM)
}

in_region(:CompassRoom){
	set_door(23, 15, DIR_S); set_route(23, 16, 1, 4); set_route(22, 17, 3, 2)
}

# 第二階層へ向かう道
in_region(:RouteTo2F){
	treasure_level 2
	appearing_enemy 30, :Bandit
	appearing_enemy 30, :StraySorcerer
	appearing_enemy 10, :StraySorcerer, :StraySorcerer
	appearing_enemy 10, :Bandit, :SmallVine
	appearing_enemy 10, :Bandit, :StraySorcerer
	appearing_enemy 5, :SpiritHead
	appearing_enemy 5, :Bandit, :Bandit

	pset_route(20, 15, 20, 17); pset_route(18, 17, 20, 17)
	pset_route(19, 17, 19, 21); pset_route(18, 19, 19, 19)
	
	# 玄室1
	set_door(19, 21, DIR_E); set_room(20, 21, 2, 2, TRT::WEAPON)
	
	# 回り行き止まり
	set_room(16, 19, 2, 2, TRT::ITEM, EA::LITTLE); set_door(17, 19, DIR_E); set_door(16, 20, DIR_S)
	pset_route(16, 21, 18, 21); set_door(18, 21, DIR_N); set_route(18, 20, 1, 1)
	
	# 奥
	set_route(16, 17, 2, 2); set_door(17, 17, DIR_E); set_door(16, 18, DIR_W)
	pset_route(15, 17, 15, 23); pset_route(15, 22, 19, 22)
	pset_route(19, 22, 19, 23); pset_route(19, 23, 20, 23)
	
	# -> 玄室2
	set_room(15, 15, 2, 2, TRT::ARMOR); set_door(15, 16, DIR_S)
	
	# -> アパート
	set_door(15, 19, DIR_W)
	pset_route(14, 17, 14, 21)

	set_room(14, 16, 1, 1, TRT::ACCESSORY, EA::VERY_LITTLE); set_door(14, 16, DIR_S)
	set_room(13, 17, 1, 1, TRT::ACCESSORY, EA::VERY_LITTLE); set_door(13, 17, DIR_E)
	set_room(13, 18, 1, 1, TRT::ACCESSORY, EA::VERY_LITTLE); set_door(13, 18, DIR_E)
	set_room(13, 19, 1, 1, TRT::ACCESSORY, EA::VERY_LITTLE); set_door(13, 19, DIR_E)
	set_room(13, 20, 1, 1, TRT::ACCESSORY, EA::VERY_LITTLE); set_door(13, 20, DIR_E)
	set_room(13, 21, 1, 1, TRT::ACCESSORY, EA::VERY_LITTLE); set_door(13, 21, DIR_E)
	set_room(14, 22, 1, 1, TRT::ACCESSORY, EA::VERY_LITTLE); set_door(14, 22, DIR_N)
	
	# -> 魔道士ゾーン
	set_door(20, 23, DIR_E)
	set_route(21, 23, 3, 1); set_route(22, 22, 2, 3)
	set_locked_door(23, 23, DIR_E, 'wizard_zone', :KeyOfWizard)
	
	# -> 第二階層へ
	set_door(15, 23, DIR_E)
	pset_route(16, 23, 16, 26)
	
	set_door(16, 26, DIR_E); pset_route(17, 26, 19, 26)
	set_door(19, 26, DIR_E); set_room(20, 26, 2, 1, TRT::ARMOR); set_room(20, 25, 1, 2, TRT::ARMOR)
	
	set_door(16, 23, DIR_E); set_room(17, 23, 2, 2, TRT::WEAPON, EA::LITTLE); set_room(18, 24, 2, 1, TRT::WEAPON, EA::LITTLE)
	set_door(19, 24, DIR_E); pset_route(20, 24, 21, 24); pset_route(21, 24, 21, 25)
	set_door(21, 25, DIR_E); set_route(22, 25, 2, 2)
	set_door(23, 26, DIR_S); set_route(23, 27, 1, 1)
	set_stair(23, 27, DIR_S, 2, 24, 24, DIR_S)
	#set_wall(23, 27, DIR_S, Area::EXIT_DOOR)
}



def on_move(party)
	if party.is_position?(23, 19, DIR_S) then
		show_special_action(:special_detect, "祭壇を調べる")
	elsif party.is_position?(23, 16) then
		if GS.switch[:GetCompass] then
			unless GS.switch[:BusterImp] then
				BGM.fade_out
				message("部屋を出ようとした#{party.name}の耳に\n翼のはためく音が聞こえてきた……\n\nどうやら、この羅針盤を持ち帰るためには\n目の前の魔物たちを撃退しなくてはならないようだ！")
				
				troop = BossTroop.new
				troop.add_enemies(:Imp, 4)
				re = Game.battle(troop)
				GS.switch[:BusterImp] = true if re

			end
		end
	end

end

def on_special_action(party, action_id)
	case action_id
	when :special_detect
		if GS.switch[:GetCompass] then
			holder = party.find_item_holder(:CompassOfSpell)
			if holder then
				if Game.ask("#{holder.name}の持っている羅針盤を、元の位置に戻しますか？") then
					holder.lose_item(:CompassOfSpell)
					GS.switch[:GetCompass] = false
					message "#{holder.name}は$c[item]呪われた羅針盤$cを元に戻した"
					Game.save(FQ_BIG_CHANGE, "呪われた羅針盤返還")
				end
			else
				message("祭壇の上には何も置かれていない")
			end
		else
			message "祭壇の上に置いてあるのは、古めかしい羅針盤だった\n\n方角を示す針以外にも、いくつかの針がはめ込んであり\n呪文の力で動作しているようだ"
			
			if Game.ask("羅針盤を持っていきますか？") then
	
				getter = party.get_item(Item.new(:CompassOfSpell))
				
				if getter then
					SE.equip
					message "#{getter.name}は$c[item]呪われた羅針盤$cを手に入れた"
					GS.switch[:GetCompass] = true
					Game.save(FQ_BIG_CHANGE, "呪われた羅針盤入手")
				else
					message "これ以上、アイテムを持てる者がいない"
				end
			end
		end
	end
end

def on_enter_region(party, old_region)
	case party.region
	when :KeyOfGraveKeeperRoom
		BGM.play(:NPC)
		message("部屋に踏み込むと、中には一人の年老いた男が腰掛けていた\n\n筆を執り、羊皮紙に何かを書き記している")
		message("老人はこちらに気付くと、静かに語りだした……\n\n「ようこそ、冒険者よ。\n私は墓守のカロン。何か聞きたいことがあれば答えよう」")
		
		loop do
			selects = []
			selects << SelectItem.new(:who_are_you, "あなたは何者？")
			selects << SelectItem.new(:rabyrinth, "この迷宮について聞く")
			selects << SelectItem.new(:treasure, "財宝はあるか？")
			unless party.find_item_holder(:KeyOfGraveKeeper) then
				selects << SelectItem.new(:please_key, "扉の鍵が欲しい")
			end
			selects << SelectItem.new(:cancel, "話をやめる")
			
			id = Game.select(selects)
			
			case id
			when :who_are_you
				message "「私はここで、この墳墓を守っている。\n盗掘者たちが、みだりに奥に踏み込まぬように。\nまた、邪霊や魔物たちが、奥から這い出してこぬように。\n\nここの墓守を続けて、もう362年ほどになるか……」"
			when :rabyrinth
				message "「この迷宮は、ある王家のために作られた巨大な墳墓だ」"
				message "「はるか昔、この地で力を奮った国があった。\nここにはその国で暮らしていた\n兵士や宦官、王家の者たちが眠っている。」"
				message "「王国が滅び、人が去り……\n三百年あまりの間は、この墳墓もずっと静かなものだった。\n\nだが、ここ数年でその静穏も乱されつつある。\n君たちも見ただろう、魔物や邪霊、盗賊のはびこる今の状況を」"
				message "「君たちには、この迷宮の深部に潜り\n魔物たちが現れた原因を探ってもらいたい。\n\nそして願わくば、この墳墓に再び安息を取り戻してほしい」"
			when :treasure
				message "「いくつかの部屋には宝物が隠されているはずだ。\n奥に進めば、希少な宝石や魔法の道具も眠っているだろう。\n\n見つけたものは君たちの好きにしていい」"
				message "「ただし、奥に進むほど危険は増す。\n財宝目当てに深部を目指すのは構わないが\nそのために道半ばで倒れられては困る」"
			when :please_key
				getter = party.get_item(Item.new(:KeyOfGraveKeeper))
				
				if getter then
					message "「いいだろう、少し待ちなさい」\n\nカロンは奥にかけられている鍵束の内から\n一つを取り出し、#{GS.party.name}に差し出した"
					message "「この鍵があれば、迷宮の奥に通じる扉を開くことができる。\n$c[em]先に進むなら、南東の区画を目指しなさい。$c\n\n君たちは迷宮に入るとき、北側の扉から入ってきたはずだ。\nそれを考えればおおよその位置は分かるだろう」"
				  message "「北東の区画は行き止まりだが\n奥の部屋に、探索に役立つ道具がある。\n寄り道するのもいいだろう。\n\nただしあそこには、強力な魔物が徘徊している。気をつけたまえ」"
				
					SE.coin
					message "#{getter.name}は$c[item]墓守の鍵$cを手に入れた"
					Game.save(FQ_BIG_CHANGE, "墓守の鍵入手")
				else
					message "「鍵を持てる者がいないようだが……？」"
				end
			when :cancel
				message "「#{GS.party.name}の前途に幸運があらんことを！」"
				break
			end
		end
		BGM.play(:Dungeon1)
		party.back
		DUNGEON_WINDOW.update
	when :CompassRoom
		if GS.switch[:GetCompass] then
			dungeon_message "この部屋の床には、一面によく分からない図形が描かれており\nその図形を囲うようにして呪文が描かれている\n\n部屋の奥には、簡単なつくりの祭壇があり\nその壇上には何も置かれていない"
		else
			dungeon_message "この部屋の床には、一面によく分からない図形が描かれており\nその図形を囲うようにして呪文が描かれている\n\n部屋の奥には、簡単なつくりの祭壇があり\nその壇上に何か、道具のようなものが置いてある"
		end
	end
end



=begin
イベント発生条件：指定位置に進入(PointEvent)、指定リージョンに進入(RegionEvent)


on_walk = proc do
end

on_detect = proc do
end

on_action = proc do |action_id|
end


=end
