# 遺跡・第ニ階層

@name = "第ニ階層"
@bgm = :Dungeon1
@width = 60
@height = 40



in_region(:SouthRoute){
	treasure_level 3
	appearing_enemy 40, :RoofBird
	appearing_enemy 40, :KoboltWorker
	appearing_enemy 10, :KoboltWorker, :Pixie
	appearing_enemy 10, :RoofBird, :Pixie
	
	# 並行廊下
	set_stair(24, 24, DIR_N, 1, 23, 27, DIR_N)

	pset_route(24, 24, 24, 25); pset_route(20, 25, 24, 25); pset_route(20, 22, 20, 25)
	set_door(20, 22, DIR_W); set_room(18, 22, 2, 2, TRT::ITEM)
	set_door(20, 25, DIR_W); set_room(18, 24, 2, 2, TRT::ITEM)
	set_door(18, 23, DIR_W); pset_route(14, 22, 14, 23); pset_route(14, 23, 17, 23)
	set_door(18, 24, DIR_W); pset_route(14, 24, 14, 25); pset_route(14, 24, 17, 24)

	# -> 南側の廊下から伸びた部屋
	set_door(15, 24, DIR_S); pset_route(15, 25, 15, 27)
	set_door(15, 27, DIR_W); set_room(13, 27, 2, 2, TRT::WEAPON)
	set_door(15, 27, DIR_E); set_room(16, 27, 2, 2, TRT::ARMOR)
	
	
	# いくつかの広間
	set_door(14, 22, DIR_W); set_door(14, 25, DIR_W)
	set_route(12, 22, 2, 4); set_route(11, 22, 2, 1)
	
	set_door(11, 22, DIR_S); set_room(10, 23, 2, 2, TRT::ACCESSORY)
	
	set_door(11, 24, DIR_S); set_door(12, 25, DIR_W)
	pset_route(8, 25, 11, 25); pset_route(8, 22, 9, 25)
	pset_route(5, 22, 8, 22); pset_route(5, 22, 5, 24); pset_route(3, 24, 5, 24)
	
	set_door(3, 24, DIR_N); set_room(2, 22, 3, 2, TRT::ITEM, EA::LITTLE)
	
	# -> ？
	set_door(7, 22, DIR_S)
	set_room(6, 23, 2, 1); set_room(7, 23, 1, 3)	
}

in_region(:FeatherHome){
	set_door(3, 22, DIR_N); pset_route(2, 2, 4, 21)
	set_wall_area(2, 8, 1, 1); set_wall_area(4, 8, 1, 1)
	set_wall_area(2, 15, 1, 1); set_wall_area(4, 15, 1, 1)
	set_door(4, 21, DIR_E)
}

in_region(:EastSpace){
	treasure_level 3
	appearing_enemy 2, :RoofBird
	appearing_enemy 3, :KoboltWorker
	appearing_enemy 2, :KoboltWorker, :KoboltLeader
	appearing_enemy 1, :KoboltWorker, :KoboltLeader, :KoboltWorker
	appearing_enemy 1, :KoboltWorker, :Pixie

	pset_route(5, 21, 6, 21); pset_route(6, 17, 6, 21); set_door(6, 17, DIR_E)
	set_room(7, 16, 3, 2, TRT::ITEM, EA::LITTLE); set_wall_area(7, 16, 1, 1); set_door(9, 16, DIR_E)
	pset_route(10, 16, 11, 16); pset_route(11, 14)
	set_route(11, 14, 2, 1); set_route(12, 13, 2, 2); set_route(13, 13, 1, 3)
	
	# 南の通路
	set_door(13, 15, DIR_S); set_route(13, 16, 2, 2); pset_route(13, 17, 16, 17)
	set_door(16, 17, DIR_N); pset_room(15, 15, 16, 16, TRT::ARMOR)
	set_door(16, 17, DIR_E); pset_route(17, 17, 18, 17); pset_route(18, 19)
	pset_route(13, 19, 22, 19)
	
	# -> 西側の部屋
	set_door(13, 19, DIR_W); set_room(11, 18, 2, 2, TRT::WEAPON)
	
	# -> 東側の部屋（一方通行あり）
	pset_route(22, 19, 22, 22)
	set_door(22, 22, DIR_S); set_room(21, 23, 2, 2, TRT::ACCESSORY); set_one_way_door(21, 23, DIR_W)
	
	
	# 北の通路
	set_door(13, 13, DIR_N)
	set_route(12, 12, 5, 1); set_route(13, 11, 3, 2); set_route(14, 12, 2, 2)
	
	# -> のぼり階段
	set_door(12, 12, DIR_W); set_route(11, 12, 1, 1); set_locked_door(11, 12, DIR_N, 'to_bridge', :KeyOfWizard)
	
	# -> 回廊
	set_door(16, 12, DIR_E)
	set_route(17, 11, 3, 3); set_route(18, 13, 4, 2)
	
	# ---> 北の部屋ルート
	set_door(21, 13, DIR_N); set_room(20, 11, 2, 2, TRT::ITEM)
	set_door(21, 11, DIR_N)
	pset_route(21, 10, 21, 9); pset_route(29, 9); pset_route(29, 10)

	set_door(29, 10, DIR_S)
	set_room(27, 11, 3, 3, TRT::WEAPON, EA::LITTLE); set_wall_area(27, 11, 2, 1); set_wall_area(27, 11, 1, 2)
	
	set_door(27, 13, DIR_W); pset_route(26, 13, 23, 13); pset_route(23, 14)
	set_door(23, 14, DIR_S); pset_route(23, 15, 23, 17)
	pset_route(25, 13, 25, 10); set_door(25, 10, DIR_N)
	
	# -----> 戻り道
	set_door(29, 13, DIR_E); pset_route(30, 13, 31, 13); pset_route(31, 19); pset_route(26, 19)
	set_one_way_door(26, 19, DIR_N)
	
	# -----> マンション2
	pset_route(31, 13, 32, 13); set_door(32, 13, DIR_E)
	
	# ---> 南の通路ルート
	pset_route(20, 14, 20, 17); pset_route(24, 17); pset_route(24, 18); pset_route(26, 18)
	set_door(26, 18, DIR_N); pset_route(26, 17, 27, 17); pset_route(27, 15)
	
	set_door(27, 15, DIR_W); set_room(25, 15, 2, 2, TRT::ACCESSORY); set_wall_area(25, 16, 1, 1)
	set_door(27, 15, DIR_E); set_room(28, 15, 2, 2, TRT::ARMOR)
	
	
}


in_region(:SquareRooms){
		treasure_level 4
	appearing_enemy 50, :KoboltWorker
	appearing_enemy 35, :KoboltWorker, :KoboltWorker
	appearing_enemy 15, :KoboltWorker, :KoboltLeader, :KoboltWorker


	pset_route(33, 13, 34, 13); pset_route(34, 9); pset_route(42, 9)
	pset_route(34, 13, 34, 18); pset_route(42, 18)
	
	ea = EA::LITTLE
	set_room(35, 10, 2, 2, TRT::WEAPON, ea); set_route(37, 10, 2, 2)
	set_room(39, 10, 2, 2, TRT::ARMOR, ea); set_route(41, 10, 2, 2)
	set_route(35, 12, 2, 2); set_room(37, 12, 2, 2, TRT::ACCESSORY, ea)
	set_route(39, 12, 2, 2); set_route(41, 12, 2, 2, :MerchantRoom)
	set_route(35, 14, 2, 2); set_route(37, 14, 2, 2)
	set_room(39, 14, 2, 2, TRT::ITEM, ea); set_route(41, 14, 2, 2)
	set_room(35, 16, 2, 2, TRT::ACCESSORY, ea); set_room(37, 16, 2, 2, TRT::WEAPON, ea)
	set_route(39, 16, 2, 2); set_room(41, 16, 2, 2, TRT::ARMOR, ea)
	
	set_door(40, 18, DIR_N)
	set_door(40, 16, DIR_E); set_door(39, 16, DIR_W)
	set_door(38, 15, DIR_E)
	set_door(37, 16, DIR_N)
	set_door(37, 14, DIR_W)
	set_door(36, 15, DIR_S)
	set_door(40, 15, DIR_E); set_door(40, 14, DIR_N); set_door(40, 12, DIR_N)
	set_door(42, 14, DIR_N)
	set_door(35, 12, DIR_N)
	set_door(38, 12, DIR_E); set_door(37, 12, DIR_W); set_door(38, 10, DIR_E); set_door(40, 10, DIR_E)
	set_door(36, 11, DIR_E)
	set_one_way_door(42, 10, DIR_N)
}


in_region(:NorthRoute){
	treasure_level 4
	appearing_enemy 30, :RoofBird
	appearing_enemy 20, :KoboltWorker
	appearing_enemy 10, :KoboltWorker, :KoboltLeader, :KoboltWorker
	appearing_enemy 10, :KoboltWorker, :KoboltWorker, :KoboltLeader
	appearing_enemy 10, :KoboltWorker, :Pixie
	appearing_enemy 10, :RoofBird, :Pixie

	set_door(3, 2, DIR_N); pset_route(3, 0, 3, 1)
	set_door(3, 0, DIR_E); pset_route(4, 0, 13, 0)
	
	set_door(8, 0, DIR_S); set_room(8, 1, 2, 2, TRT::ACCESSORY)
	set_door(9, 2, DIR_S)
	pset_route(9, 3, 10, 3); pset_route(10, 3, 10, 4); pset_route(10, 4, 11, 4)
	set_locked_door(11, 4, DIR_S, 'feather_n', :KeyOfWizard)

	set_door(10, 0, DIR_S); set_room(10, 1, 2, 2, TRT::ITEM)
	set_door(12, 0, DIR_S); set_room(12, 1, 2, 2, TRT::WEAPON)
	set_door(11, 2, DIR_S); set_door(13, 2, DIR_S); pset_route(11, 3, 13, 3)
	
	# 回廊
	set_door(12, 3, DIR_S)
	pset_route(12, 4, 19, 4); pset_route(19, 4, 19, 1); pset_route(19, 1, 15, 1); pset_route(15, 1, 15, 4)
	
	# -> 中部屋
	set_door(15, 3, DIR_E); set_room(16, 2, 3, 2, TRT::ARMOR, EA::MUCH); set_door(18, 2, DIR_E)
	
	# 階段へ
	set_door(19, 1, DIR_E); pset_route(20, 1, 24, 1)
	#set_wall(24, 1, DIR_N, Area::EXIT_DOOR)
	set_stair(24, 1, DIR_N, 3, 4, 2, DIR_S)
	
}




def on_move(party)
	if party.is_position?(3, 14, DIR_N) and not GS.switch[:RuinFeatherEscape] and not GS.switch[:BusterRuinFeather] then
		message("どこかからか、翼のはためくような音が聴こえてくる……\n\n上空を見上げた冒険者たちは\n影のようなものが高速で横切ったのを見た")
		holder = GS.party.find_item_holder(:VoiceOfHarpy)
		if holder then
			if Game.ask("ハーピーの金切り笛を鳴らしてみますか？") then
				message("#{holder.name}が笛を吹くと、かん高い音があたりに鳴り響き\n翼の音は小さくなっていった")
				GS.switch[:RuinFeatherEscape] = true
			end
		end
	elsif party.is_position?(3, 7, DIR_N) and not GS.switch[:RuinFeatherEscape] and not GS.switch[:BusterRuinFeather] then
		BGM.fade_out
		message("……翼の音が近づいてくる！")
				
		troop = BossTroop.new
		troop.add_enemies(:RuinFeather, 1)
		win = Game.battle(troop)
		GS.switch[:BusterRuinFeather] = true if win

		
	elsif party.is_position?(3, 22, DIR_N) then
		dungeon_message("石扉に文が彫りこんである\n\n- 翼あるものの道 -\n* 力無き者、知無き者は死を覚悟せよ *")
	elsif party.is_position?(3, 21, DIR_N) then
		dungeon_message("幅の広い通路だ\n\n上を見上げてみると、天井が見えない……\nこの空間には相当な高さがあるようだ")
		
	end
end


def on_enter_region(party, old_region)
	case party.region
	when :MerchantRoom
		BGM.play(:NPC)
		message("部屋の中には一人の男がいた\n\nいや、その姿は「男」と呼べるのだろうか？\nしゃれた服を着て帽子をかぶり、ふるまいは人間のようだが\nその頭はどう見てもワニのように見える")
		message("ワニ頭の男は、にこやかに声をかけてきた\n\n「ようこそ友よ！　何か欲しいものはないかい？」")
		
		loop do
			selects = []
			selects << SelectItem.new(:who_are_you, "あなたは何者？")
			selects << SelectItem.new(:buy, "品物を見せて！")
			unless GS.party.find_item_holder(:VoiceOfHarpy) then
				selects << SelectItem.new(:feather_home, "「翼あるものの道」を突破したい")
			end
			selects << SelectItem.new(:cancel, "話をやめる")
			
			id = Game.select(selects)
			
			case id
			when :who_are_you
				message "「私はデミトリ。この迷宮で物を売って生活してる、陽気で誠実な行商人さ！」"
			when :buy
				Phase.change(MerchantBuyPhase.new)
				Game.operation_loop
				Phase.change(DungeonPhase.new)
			when :feather_home
				message "「おっと、あの道を通りたいのか？\n\nあそこには巨鳥が棲みついてて\n通ろうとしたやつらは、たいていパックリやられちまうんだ」"
				message "「そこでこの笛！\nこれさえあればで鳥を追い払える、魔法の笛さ！」\n\nワニ頭の男は、銀色の笛を取り出してみせた"
				message "「どうだい、この笛は欲しくないか？\n私たちは友達だ、金貨150枚でいいよ！」"
				if GS.party.gold >= 150 then
					if Game.ask("笛を150Gで購入しますか？") then
						getter = party.get_item(Item.new(:VoiceOfHarpy))
						if getter then
							GS.party.lose_gold(150)
							SE.coin
							message "#{getter.name}は$c[item]ハーピーの金切り笛$cを手に入れた"	
							Game.save(FQ_BIG_CHANGE, "ハーピーの金切り笛入手")
						else
							message("「おっと待ってくれ、誰も手が空いてないみたいだぜ？\n持ち物を整理してから来てくれよ」")
						end
					else
						message "「そうかい、そいつは残念だな\nついでに他の品物も見ていってはどうだい？」"
					end
				else
					message "「なに、お金が足りないって？　そいつは残念だな\nついでに他の品物も見ていってはどうだい？」"
				end
			when :cancel
				message "「またいつでも来てくれ、友よ！」"
				break
			end
		end
		BGM.play(:Dungeon1)
		DUNGEON_WINDOW.update
	end
end
