
trick :FlameDasher do
	@name = _('火走り')
	@description = _('炎の波で敵一群を焼き払う')
	@mp_cost = 3
	@boost_description = _("ダメージ＋")
	@effect = MagicGroupAttackEffect.new
	@effect.damage_types = [DT_HEAT]
	@effect.hitting_border_base = 70
	@effect.fixed_damage = 15
	@effect.damage_rate = 0.5
	@effect.messages = [_("%{actor}は火炎の呪文を唱えた！\n炎の波が%{target}を焼き払う！")]
	@boost_effect = @effect.dup
	@boost_effect.damage_rate = 0.8
end


trick :HeatBarrier do
	@name = _('ヒートバリア')
	@description = _('味方全員に冷気軽減バリア。防御力は術制御に依存')
	@mp_cost = 6
	@effect = MagicGroupRecoverEffect.new
	@effect.messages = [_("%{actor}は火炎の呪文を唱えた！")]
	@effect.add_state_data << [HeatBarrierState, :magic_control]
end



trick :BurningCage do
	@name = _('バーニングケイジ')
	@description = _('敵一体を炎で包み込み、熱ダメージと同時に炎上させる')
	@mp_cost = 8
	@boost_description = _("ダメージ＋")
	@effect = MagicSingleAttackEffect.new
	@effect.damage_types = [DT_HEAT]
	@effect.fixed_damage = 20
	@effect.damage_rate = 1.8
	@effect.state_data << [BurningCageState, :magic_control, 50]
	@effect.messages = [_("%{actor}は火炎の呪文を唱えた！\n灼熱の火柱が%{target}を包み込む！")]
	@boost_effect = @effect.dup
	@boost_effect.damage_rate = 2.7
	@boost_effect.state_data.last[2] = 70
end

trick :Fireball do
	@name = _('ファイアボール')
	@description = _('火の玉を投げつけて敵一群を吹っ飛ばす。熱+打撃ダメージ')
	@mp_cost = 12
	@boost_description = _("ダメージ＋")
	@effect = MagicGroupAttackEffect.new
	@effect.damage_types = [DT_HEAT, DT_BLOW]
	@effect.hitting_border_base = 60
	@effect.fixed_damage = 30
	@effect.damage_rate = 1.2
	@effect.state_data << [SmashedState, 1, 40]
	@effect.messages = [_("%{actor}は爆発の呪文を唱えた！\n投げつけられた火の玉が、着弾して爆風を巻き起こす！")]
	@boost_effect = @effect.dup
	@boost_effect.damage_rate = 1.7
end

=begin
trick :MagicMissile do
	@name = _('マジックミサイル')
	@description = _('敵一群に集中射撃')
	@mp_cost = 10
	@boost_description = "ダメージ＋"
	@effect = MagicGroupAttackEffect.new
	@effect.damage_types = [DT_HEAT, DT_BLOW]
	@effect.attack_number = 8
	@effect.hitting_border_base = 50
	@effect.fixed_damage = 10
	@effect.damage_rate = 0.4
	@effect.messages = [_("%{actor}は爆発の呪文を唱えた！\n無数の光弾が%{target}に降り注ぐ！")]
	@boost_effect = @effect.dup
	@boost_effect.attack_number = 12
end

trick :Disrupter do
	@name = _('ディスラプター')
	@description = _('魔力槍を敵一体に撃ち込む(3本まで追加可能)。衝撃を与えると起爆')
	@mp_cost = 7
	@effect = MagicAttackEffect.new
	@effect.hitting_border_base = 65
	@effect.messages = [_("%{actor}は爆発の呪文を唱えた！")]
end

=end



trick :IceBolt do
	@name = _('アイスボルト')
	@description = _('凝縮した冷気エネルギー弾で敵一体を攻撃')
	@mp_cost = 1
	@boost_description = "ダメージ＋"
	@effect = MagicSingleAttackEffect.new
	@effect.damage_types = [DT_COLD]
	@effect.fixed_damage = 17
	@effect.hitting_border_base = 75
	@effect.damage_rate = 0.5
	@effect.messages = [_("%{actor}は氷結の呪文を唱えた！\n冷気の塊が%{target}めがけて放たれる！")]
	@boost_effect = @effect.dup
	@boost_effect.fixed_damage = 30
	@boost_effect.damage_rate = 0.8
end

trick :IceSpike do
	@name = _('アイススパイク')
	@description = _('味方一人の武器を氷で強化し、致傷力アップ')
	@mp_cost = 5
	@effect = MagicSingleRecoverEffect.new
	@effect.add_state_data << [IceSpikeState, :magic_control]
	@effect.messages = [_("%{actor}は氷結の呪文を唱えた！")]
end
	
trick :FrostSpear do
	@name = _('氷雨')
	@description = _('氷柱を落とし、敵一群に刺突+冷気ダメージ')
	@mp_cost = 7
	@boost_description = _("攻撃回数＋")
	@effect = MagicGroupAttackEffect.new
	@effect.damage_types = [DT_COLD, DT_BLOW]
	@effect.fixed_damage = 8
	@effect.damage_rate = 0.6
	@effect.attack_number = 4
	@effect.hitting_border_base = 65
	@effect.messages = [_("%{actor}は氷結の呪文を唱えた！\n天井が凍りつき、氷柱が%{target}めがけて降り注ぐ！")]
	@boost_effect = @effect.dup
	@boost_effect.attack_number = 7
end









trick :SparkShot do
	@name = _('スパークショット')
	@description = _('稲妻で敵一体を攻撃。回避不可、まれに痺れ効果')
	@mp_cost = 2
	@boost_description = _("ダメージ＋")
	@effect = MagicSingleAttackEffect.new
	@effect.damage_types = [DT_ERECTRIC]
	@effect.fixed_damage = 0
	@effect.damage_rate = 1.5
	@effect.attack_number = 1
	@effect.state_data << [ParalyzedState, 1, 35]
	@effect.messages = [_("%{actor}は雷撃の呪文を唱えた！\n稲妻が%{target}めがけて迸る！")]
	
	@boost_effect = @effect.dup
	@boost_effect.damage_rate = 2.3
end


trick :Shock do
	@name = _('ショック')
	@description = _('電流で敵一群を麻痺させる')
	@mp_cost = 3
	@effect = MagicGroupAttackEffect.new
	@effect.state_data << [ParalyzedState, 2, 65]
	@effect.messages = [_("%{actor}は雷撃の呪文を唱えた！\n拡散した電流が%{target}を襲う！")]
	
	@boost_description = _("麻痺確率＋")
	@boost_effect = @effect.dup
	@boost_effect.state_data.last[2] = 80
end


trick :ThunderStrike do
	@name = _('サンダーストライク')
	@description = _('落雷で敵一体に大ダメージ。まれに痺れ効果')
	@mp_cost = 9
	@effect = MagicSingleAttackEffect.new
	@effect.damage_types = [DT_ERECTRIC]
	@effect.fixed_damage = 20
	@effect.damage_rate = 1.8
	@effect.attack_number = 1
	@effect.hitting_border_base = 80
	@effect.state_data << [ParalyzedState, 1, 35]
	@effect.messages = [_("%{actor}は雷撃の呪文を唱えた！\n落雷が轟音とともに%{target}を撃つ！")]

	@boost_description = _("ダメージ＋")
	@boost_effect = @effect.dup
	@boost_effect.damage_rate = 2.4
end







trick :MistWall do
	@name = _('ミストウォール')
	@description = _('厚い霧で味方全員の回避率を上昇(3ラウンド有効)')
	@mp_cost = 4
	@effect = PartyEnhanceEffect.new
	@effect.messages << "%{target}は霧の呪文を唱えた！"
	@effect.state_data << [MistWallState, 1]
end

trick :BlindFog do
	@name = _('ブラインドフォグ')
	@description = _('味方一人を攻撃対象にならなくする(5ラウンド有効)')
	@mp_cost = 6
	@effect = MagicSingleRecoverEffect.new
	@effect.add_state_data << [InvisibleState, 1]
end


trick :IllusionMist do
	@name = _('幻霧')
	@description = _('敵一群に幻影を見せ、同士討ちを引き起こす')
	@mp_cost = 6
	@battle_usable = true
	@camp_usable = true
	@effect = MagicGroupAttackEffect.new
	@effect.messages << _("%{actor}は霧の呪文を唱えた！\n黒い霧が%{target}を包み込む！")
	@effect.state_data << [IllusionMistState, 1, 60]

end







trick :Sleep do
	@name = _('誘眠')
	@description = _('敵一群を眠らせる。眠った者は衝撃によって起きる')
	@mp_cost = 2
	@effect = EnemyGroupEnhanceEffect.new
	@boost_description = _("成功率＋")
	@effect.messages = [_("%{actor}は催眠の呪文を唱えた！")]
	@effect.state_data = [[SleepState, 1, 60]]
	@boost_effect = @effect.dup
	@boost_effect.state_data = [[SleepState, 1, 75]]
end

trick :Terror do
	@name = _('テラー')
	@description = _('敵一群を恐怖させ、思ったように行動できなくする')
	@mp_cost = 3
	@effect = EnemyGroupEnhanceEffect.new
	@boost_description = _("成功率＋")
	@effect.messages = [_("%{actor}は催眠の呪文を唱えた！")]
	@effect.state_data = [[TerrorState, 1, 60]]
	@boost_effect = @effect.dup
	@boost_effect.state_data = [[TerrorState, 1, 75]]
end

trick :VandalTemptation do
	@name = _('破壊衝動')
	@description = _('敵一群を暴走させ、特殊行動を封じるとともに器用さ・回避を下げる')
	@mp_cost = 4
	@effect = EnemyGroupEnhanceEffect.new
	@boost_description = _("成功率＋")
	@effect.messages = [_("%{actor}は催眠の呪文を唱えた！")]
	@effect.state_data = [[BerserkState, 1, 60]]
	@boost_effect = @effect.dup
	@boost_effect.state_data = [[BerserkState, 1, 75]]
end


trick :DominateMind do
	@name = _('精神支配')
	@description = _('敵一群の精神を支配し、同士討ちさせる')
	@mp_cost = 5
	@effect = EnemyGroupEnhanceEffect.new
	@boost_description = _("成功率＋")
	@effect.messages = [_("%{actor}は催眠の呪文を唱えた！")]
	@effect.state_data = [[MindDominatedState, 1, 50]]
	@boost_effect = @effect.dup
	@boost_effect.state_data = [[MindDominatedState, 1, 65]]
end





trick :SiteVision do
	@name = _('サイトビジョン')
	@description = _('現在いるフロアの地図と現在位置を表示する')
	@mp_cost = 2
	@effect = MapVisionEffect.new
end
	
trick :AnalysisVision do
	@name = _('アナリシスビジョン')
	@description = _('宝箱の中身と罠の種類を確実に判別する')
	@mp_cost = 4
	@effect = Effect.new
end

=begin
trick :Prevision do
	@name = _('プレビジョン')
	@description = _('次ラウンドの敵全員の行動を予知')
	@mp_cost = 5
	@effect = MagicSelfRecoverEffect.new
	@effect.add_state_data << [PrevisionState, 1]
end
=end







trick :HealingHand do
	@name = _('癒しの手')
	@description = _('味方一人の傷を癒す。痺れ・睡眠なども治療')
	@mp_cost = 4
	@boost_description = _("回復力＋")
	
	@effect = MagicSingleRecoverEffect.new
	@effect.set_hp_recovery(10, 1.5)
	@effect.state_data << [ParalyzedState, nil] << [SleepState, nil]
	@effect.messages = [_("%{actor}は癒しの呪文を唱え、手をかざした！\n掌の輝きが傷を癒していく……")]
	@boost_effect = @effect.dup
	@boost_effect.set_hp_recovery(30, 2.2)
end


trick :CalmHand do
	@name = _('静めの手')
	@description = _('味方全員の精神を落ち着かせ、暴走・恐怖を治癒')
	@mp_cost = 4
	
	@effect = MagicGroupRecoverEffect.new
	@effect.state_data << [TerrorState, nil]
	@effect.messages = [_("%{actor}は癒しの呪文を唱え、手を空にかざした！\n掌の輝きが心を落ち着かせる……")]
end

trick :LifeStorm do
	@name = _('命の渦')
	@description = _('味方全員の傷を徐々に回復する(5ラウンド有効)')
	@mp_cost = 12
	@effect = PartyEnhanceEffect.new
	@effect.state_data << [LifeStormState, :magic_control]
end





trick :PurifyWind do
	@name = _('清めの風')
	@description = _('味方全員の呪いを治療する')
	@mp_cost = 3
	@effect = MagicGroupRecoverEffect.new
	@effect.messages = [_("%{actor}は浄化の呪文を唱えた！\n清らかな風が%{target}を包み込む……")]
	@effect.state_data << [CurseState, nil]
end
	
trick :CurePoison do
	@name = _('解毒術')
	@description = _('味方一人の毒を治療する')
	@mp_cost = 6
	@effect = MagicSingleRecoverEffect.new
	@effect.messages = [_("%{actor}は浄化の呪文を唱え、手をかざした！")]
	@effect.state_data << [PoisonState, nil]
end
	
trick :ExorcisingWind do
	@name = _('魔祓いの風')
	@description = _('亡霊の敵一群に大ダメージ。回避不可')
	@mp_cost = 7
	@effect = MagicGroupAttackEffect.new
	@effect.damage_types = []
	@effect.fixed_damage = 40
	@effect.damage_rate = 0.6
	@effect.ghost_only = true
	@effect.messages = [_("%{actor}は浄化の呪文を唱えた！\n聖なる風が%{target}めがけて吹きつける！")]
	@boost_effect = @effect.dup
	@boost_effect.damage_rate = 0.9
end






trick :BodyAcceleration do
	@name = _('身体加速')
	@description = _('味方一人の器用さ・敏捷性を上昇(5ラウンド有効)')
	@mp_cost = 2
	@effect = MagicSingleRecoverEffect.new
	@effect.messages = [_("%{actor}は加速の呪文を唱えた！")]
	@effect.add_state_data << [BodyAccelerationState, 5]
end

trick :CastingAcceleration do
	@name = _('詠唱加速')
	@description = _('自身の術発動スピードを大幅に加速(5ラウンド有効)')
	@mp_cost = 3
	@effect = MagicSelfRecoverEffect.new
	@effect.messages = [_("%{actor}は加速の呪文を唱えた！")]
	@effect.add_state_data << [CastingAccelerationState, 1]
end

trick :WideBodyAcceleration do
	@name = _('広域身体加速')
	@description = _('味方全員の器用さ・敏捷性を上昇(3ラウンド有効)')
	@mp_cost = 7
	@effect = PartyEnhanceEffect.new
	@effect.messages = [_("%{actor}は加速の呪文を唱えた！")]
	@effect.state_data << [BodyAccelerationState, 3]
end




trick :SlowStream do
	@name = _('スローストリーム')
	@description = _('敵一群の器用さ・敏捷性を減少(3ラウンド有効)')
	@mp_cost = 3
	@effect = EnemyGroupEnhanceEffect.new
	@effect.messages = [_("%{actor}は停滞の呪文を唱えた！")]
	@effect.state_data << [SlowState, 1]
end


trick :SpaceStasis do
	@name = _('空間停滞')
	@description = _('発動したラウンドの間のみ、すべての特殊状態の自然回復が止まる')
	@mp_cost = 5
	@effect = SpecialEffect.new
	@effect.battle_usable = true
	@effect.proc = proc do
		$battle.on_stasis = true
	end
end




trick :QuickTransfer do
	@name = _('緊急転移')
	@description = _('同じ階層のどこかへ瞬時に移動する。戦闘中でも発動可')
	@mp_cost = 1
	@effect = PartyTereportEffect.new
	@effect.battle_usable = true
end


trick :Interflow do
	@name = _('インターフロー')
	@description = _('他パーティーのいる場所へ移動する')
	@mp_cost = 1
	@effect = SpecialEffect.new
	@effect.battle_usable = true
	@effect.proc = proc do
	end
end

=begin
trick :GhostSong do
	@name = _('死者の歌')
	@description = _('辺りの死霊を操り、その怨念によって敵一群に呪いをかける')
	@mp_cost = 4
	@effect = MagicGroupAttackEffect.new
	@boost_description = _("成功率＋")
	@effect.messages = [_("%{actor}は死霊の呪文を唱えた！")]
	@effect.state_data << [CurseState, 3, 50]
	@boost_effect = @effect.dup
	@boost_effect.state_data.last[2] = 60
end


trick :NecroCharm do
	@name = _('ネクロチャーム')
	@description = _('不死者系の敵を魅了し、同士討ちさせる')
	@mp_cost = 3
	@effect = MagicGroupAttackEffect.new
	@boost_description = _("成功率＋")
	@effect.messages = [_("%{actor}は死霊の呪文を唱えた！")]
	@effect.state_data << [CurseState, 3, 50]
	@boost_effect = @effect.dup
	@boost_effect.state_data.last[2] = 60
end
=end









