# キャラクタクラス


module DarkHall


	class EnemyModel < Model
		attr_accessor :level, :name_id, :description, :black_name, :hp_max, :mp_max, :exp, :gold
		attr_accessor :weapon, :defense, :shield 
		attr_accessor :ai_type, :graphic_symbol, :damage_resists, :state_resists
		attr_accessor :number_rank
		bool_attr_accessor :silent, :ghost_body
		
		def init_params
			super
			@name_id = ''
			@description = ''
			@mp_max = {}
			@damage_resists = Hash.new(RES_NORMAL)
			@state_resists = Hash.new(RES_NORMAL)
			@shield = nil
			@ghost_body = false
			@ability_growth = Hash.new(GLOW_D)
			@exp_rate = 0.0
			@number_rank = NUM_C
			@silent = false
		end
		
		def name
			n_(@name_id, 1)
		end
		
		
		
		def get_ability_base(type)
			growth = @ability_growth[type]
			
			return Calc.ability_base(growth, @level)
		end
		
		
		def exp
			(EXP_NEXT_TABLE[@level + 1] * @exp_rate).to_i
		end
		
		def spell_caster?
			not @mp_max.empty?
		end

		private
		def all_state_resist(res)
			@state_resists.default = res
			@state_resists.each_key do |key|
				@state_resists[key] = res
			end
		end
		
		def mental_resist(res)
			@state_resists[TerrorState] = res
			@state_resists[BerserkState] = res
			@state_resists[MindDominatedState] = res
		end
		
		def undead_resist
			@state_resists[CurseState] = RES_PERFECT
			@state_resists[PoisonState] = RES_PERFECT
		end


		
	end

	
	class Enemy < Character
		include InstanceFromModel
		attr_accessor :window, :prefix
		bool_attr_accessor :sealed_ghost_body
		
		
		def initialize(data_id, prefix = EP::Standard)
			super(data_id)
			@hp = self.hp_max
			self.mp_max.each_pair do |spell_id, pt|
				@mp[spell_id] = pt
			end
			@window = nil
			
			@prefix = prefix
		end
		
		def name
			if ENEMY_PREFIX_CAPTIONS[@prefix] then
				ENEMY_PREFIX_CAPTIONS[@prefix] + self.data.name
			else
				self.data.name
			end
		end
		
		def name_of_number(num)
			if ENEMY_PREFIX_CAPTIONS[@prefix] then
				ENEMY_PREFIX_CAPTIONS[@prefix] + n_(data.name_id, num)
			else
				n_(data.name_id, num)
			end
		end
		

		
		def hp_max_base
			self.hp_max
		end
		
		def hp_max_penalty
			0
		end
		
		def get_ability_bonus(type)
			method_name = BONUS_METHOD_NAME_TABLE[type]
			bonus = 0

			self.status.each do |state|
				bonus += state.send(method_name)
			end
			
			return bonus.to_i
		end
		
		def transparent?
			!(@sealed_ghost_body) and data.ghost_body?
		end

		def data
			return ENEMY_DATA[@data_id]
		end
	
		def graphic
			ENEMY_GRAPHICS[@data_id]
		end
		
		def current_surface
			(@position == POS_BACK ? graphic.dark_surface : graphic.surface)
		end
		
		def weapon_power
			case @prefix
			when EP::Hungry
				(super * 1.2).to_i
			else
				super
			end
		end

		def weapon_hitting
			case @prefix
			when EP::Hungry
				(super + 5).to_i
			when EP::Sleepy
				(super - 5).to_i
			else
				super
			end
		end

		
		def speed
			case @prefix
			when EP::Systematic
				(super + 8).to_i
			when EP::Sleepy
				(super - 6).to_i
			else
				super
			end
		end
		

		
		def messages
			return nil
		end
		
		def soul?
			false
		end
		
		def dead_sequence
			super
			
			# グループから削除
			#$troop.groups.each do |group|
			#	group.delete_if{|x| x.dead}
			#end
			
			# 経験値加算
			$battle.exp += self.exp
			
			# 金品加算
			$battle.gold += self.gold
		end
		
	
		def set_ai_action
			if @prefix == EP::Sleepy and rand(100) < 50 then
				@action = SpecialAction.new(self, nil, 'Sleepy')
			else
				@action = self.send("action_#{self.ai_type}")
			end
		end

		
		def dump
			hash = super
			hash['data_id'] = @data_id
			return hash
		end


		def self.create_from_mpac_model(hash)
			obj = self.new(hash['data_id'])
			obj.hp = hash['hp']
			obj.dead = hash['dead']
			return obj
		end

	end
	
end
	
	
	
	