require 'darkhall/ai'

module DarkHall
	class Enemy < Character
		def decide_action(&proc)
			set_action(AIContext.decide(self, &proc))
		end
	
		def action_static
			nil
		end
	
		def action_beast
			decide_action do
				short_attack 1
			end
		end
		
		
		def action_vine
			decide_action do
				short_attack 75
				special 25, short_targeting, 'VineBind'
			end
		end
		
		def action_stray_sorcerer
			decide_action do
				spell_cast 80, long_targeting, 'IceBolt'
				#spell_cast 20, group_targeting, 'FlameDasher'
				attack 20
			end
		end
		
		def action_pixie
			decide_action do
				spell_cast 30, group_targeting, 'Sleep' 
				wait 70
			end
		end


		
		def action_spirit
			decide_action do
				short_attack 30
				special 20, long_targeting, 'SpiritFire'
				special 25, long_targeting, 'SpiritCurse'
				wait 25
			end
		end
		
		def action_ghost
			decide_action do
				special 40, long_targeting, 'GhostHand'
				special 60, long_targeting, 'GhostEye'
			end
		end
		
		def action_imp
			decide_action do
				short_attack 70
				special 30, long_targeting, 'ImpFire'
			end
		end
		
		def action_kobolt_leader
			decide_action do
				if $troop.all_enemies.find{|x| x.data_id == 'KoboltWorker'} then
					special 1, nil, 'KoboltLeaderImperium'
				else
					short_attack 1
				end
			end
		end


		def action_bird
			decide_action do
				short_attack 60
				long_attack 40
			end

		end
		
		def action_slime
			decide_action do
				short_attack 40
				special 20, short_targeting, 'SlimePoison'
				special 15, short_targeting, 'SlimeCorrosion'
				wait 25
			end
		end
		
		def action_blazing_storm
			decide_action do
				short_attack 30
				long_attack 20
				special 50, group_targeting, 'HeatBless'
			end
		end

		def action_freezing_storm
			decide_action do
				short_attack 30
				long_attack 20
				special 50, group_targeting, 'ColdBless'
			end
		end

		
		def action_ruin_feather
			decide_action do
				member_actions = $battle.last_round_actions.find_all{|x| x.actor.kind_of?(Member)}
				spell_attacks = member_actions.find_all{|x|
					x.kind_of?(SpellCastAction) and
					x.get_effect.kind_of?(AttackEffect) and
					x.get_effect.damaging?
				}
				
				if (chg = member_actions.find{|x| x.kind_of?(ReleaseArrowAction)}) and chg.actor.alive? then
					# チャージ攻撃を受けた場合、確実にその弓闘士を狙いにいく
					attack 100, [chg.actor]
				elsif @actor.hp_rate <= 0.3 and not @actor.find_state(BodyAccelerationState) and
				@actor.usable_mp?(DB.find_trick('BodyAcceleration').mp_cost, 'Acceleration') then
					# ダメージが大きくなると加速の呪文を使う
					spell_cast 100, [@actor], 'BodyAcceleration'
				elsif not spell_attacks.empty? then
					# ダメージを伴う攻撃術を受けた場合、遠距離攻撃の確率が高くなる
					long_attack 50
					special 50, group_targeting, 'FeatherSlasher'
				else
					# 通常のパターン
					short_attack 45
					long_attack 30
					special 25, group_targeting, 'FeatherSlasher'
				end
			
			end
		end
		
		def action_lost_armor
			decide_action do
				proc_on_special = Proc.new{
					@actor.ai_memory[:last_special] = round
				}
			
				if @actor.ai_memory.empty? then
					@actor.ai_memory[:last_special] = nil
					@actor.ai_memory[:used_curse?] = false
				end
				
				if round <= 3 + rand(2) or @actor.hp_rate >= 0.8 then
					# 最初のうちは通常攻撃のみ
					attack 100
					
				elsif not @actor.ai_memory[:used_curse?] and @actor.hp_rate < 0.4 then
				
					# HPが減少したら優先的に呪い発動
					special(100, group_targeting, 'LostArmorCurse'){
						proc_on_special.call
						@actor.ai_memory[:used_curse?] = true
					}
					
				else
				
					# 通常の行動パターン（特技を連続で使う確率は低い）
					if (last = @actor.ai_memory[:last_special]) then
						interval = round - last
					else
						interval = 5
					end
					
					if rand(100) < [interval * 15, 75].min then
						# 特技を使う
						if @actor.hp_rate < 0.4 then
							special(100, group_targeting, 'LostArmorCurse')
						else
							ranpage 50, &proc_on_special
							smash 50, &proc_on_special
						end
					else
						# 特技を使わない
						attack 100
					end
				end
			end
		end


		private
		
		def difficulty
			GS.game_config.difficulty
		end
		

	end
	
	

end