module DarkHall
	module Input
		module_function
		
		def alt_pressed?
			return (SDL::Key.press?(SDL::Key::LALT) || SDL::Key.press?(SDL::Key::RALT))
		end
		
		def ctrl_pressed?
			return (SDL::Key.press?(SDL::Key::LCTRL) || SDL::Key.press?(SDL::Key::RCTRL))
		end
		
		def shift_pressed?
			return (SDL::Key.press?(SDL::Key::LSHIFT) || SDL::Key.press?(SDL::Key::RSHIFT))
		end
		
		def page_move_shifted?
			SDL::Key.scan
			if alt_pressed? || ctrl_pressed? then
				return true
			end
			
			if GS.game_config.key_assign['PageMoveShift'] then
				$joysticks.each do |stick|
					return true if stick.button(GS.game_config.key_assign['PageMoveShift'])
				end
			end
			
			return false
		
		end
		
		def side_walk_shifted?
			SDL::Key.scan
			if alt_pressed? || ctrl_pressed? then
				return true
			end
			
			if GS.game_config.key_assign['SideWalkShift'] then
				$joysticks.each do |stick|
					return true if stick.button(GS.game_config.key_assign['SideWalkShift'])
				end
			end
			
			return false
		end
		
		def left_click(x, y)
			if defined?(Game.current_window.on_left_click) then
				Game.current_window.on_left_click(x, y)
			elsif defined?($phase.on_left_click) then
				$phase.on_left_click(x, y)
			else
				enter
			end
		end
		
		def right_click
			(defined?($phase.on_right_click) ? $phase.on_right_click : esc)
		end
		
		
		def enter
			Game.current_window.on_enter_key
		end
		
		def esc
			Game.current_window.on_cancel
		end
		
		def up
			if defined?($phase.on_up_key) and not defined?(Game.current_window.up) then
				$phase.on_up_key
			elsif page_move_shifted? and defined?(Game.current_window.page_up_shortcut) then
				SE.cursor_move
				Game.current_window.page_up_shortcut
			elsif defined?(Game.current_window.up) then
				SE.cursor_move
				Game.current_window.up
				Game.current_window.on_change
			else
				Game.current_window.on_key_press(SDL::Key::UP)
			end
		end
		
		def down
			if defined?($phase.on_down_key) and not defined?(Game.current_window.down) then
				$phase.on_down_key
			elsif page_move_shifted? and defined?(Game.current_window.page_down_shortcut) then
				SE.cursor_move
				Game.current_window.page_down_shortcut
			elsif defined?(Game.current_window.down) then
				SE.cursor_move
				Game.current_window.down
				Game.current_window.on_change
			else
				Game.current_window.on_key_press(SDL::Key::DOWN)
			end
		end
		
		def left
			if defined?(Game.current_window.on_left_key) then
				Game.current_window.on_left_key
			else
				Game.current_window.on_key_press(SDL::Key::LEFT)
			end
		end
		
		def right
			if defined?(Game.current_window.on_right_key) then
				Game.current_window.on_right_key
			else
				Game.current_window.on_key_press(SDL::Key::RIGHT)
			end
		end
		
		def left_walk
			$phase.on_left_walk_key
		end
		
		def right_walk
			$phase.on_right_walk_key
		end
		
		def shift_up
			Game.current_window.on_shift_up
		end
		
		def shift_down
			Game.current_window.on_shift_down
		end

		def ctrl_up
			Game.current_window.on_ctrl_up
		end
		
		def ctrl_down
			Game.current_window.on_ctrl_down
		end

		
		def home
			if Game.current_window.kind_of?(SelectableWindow) then
				SE.cursor_move
				Game.current_window.change(0).regulate_display.update
			end
		end
		
		def end
			raise($operation_loop_stack.join("/"))
			if Game.current_window.kind_of?(SelectableWindow) then
				SE.cursor_move
				Game.current_window.change(Game.current_window.select_items.size - 1).regulate_display.update
			end
		end
		
		def wheel_push
			$phase.on_wheel_push if defined?($phase.on_wheel_push) 
		end
		
		def page_up
			SE.cursor_move
			Game.current_window.page_up_shortcut
		end
		
		def page_down
			SE.cursor_move
			Game.current_window.page_down_shortcut
		end
		
		def wheel_up
			(defined?($phase.on_wheel_up) ? $phase.on_wheel_up : page_up)
		end
		
		def wheel_down
			(defined?($phase.on_wheel_down) ? $phase.on_wheel_down : page_down)
		end
		
		def system_menu
			Game.system_menu
		end
	end

end

