#-----------------------------------------------------------
# DarkHall rakefile (for windows)
#
# Requirement: Exerb, RSpec, Info-Zip
#-----------------------------------------------------------
require 'yaml'
require 'rake/clean'

$LOAD_PATH.unshift('./lib')

require 'ini'
require 'json'
require 'spec/rake/spectask'
require 'msgpack'


ver = ENV['DHVER'] || 'b00'
PACKAGE_NAME = "darkhall-#{ver}.zip"
SRC_PACKAGE_NAME = "darkhall-#{ver}-src.zip"
RES_PACKAGE_NAME = "darkhall-#{ver}-res.zip"

EXERB = 'exerb'

CLEAN.include('*.exy')
CLEAN.include('**/Thumbs.db')
CLEAN.include('**/_CATALOG.vix')
CLEAN.include('**/*.cache')
CLEAN.include('darkhall.log')
CLEAN.include('out*.txt')
CLEAN.include('save/*.{yml,json}')
CLEAN.include('__wxautoload.rb')

CLOBBER.include('darkhall.exe')
CLOBBER.include('setting.exe')
#CLOBBER.include('res/*.dat')
CLOBBER.include('data/*.dat')
CLOBBER.include('data/dungeon/*.dat')
CLOBBER.include('darkhall-*.zip')
CLOBBER.include('datadoc/*.html')
CLOBBER.include('manual/*.html')
CLOBBER.include('data/locale/**/*.mo')
CLOBBER.include('setting.ini')


SRCS = FileList['darkhall_exe.rb']
SRCS.include('lib/**/*.*')
SRCS.include('__wxautoload.rb')

SETTING_SRCS = FileList['setting_exe.rb']
SETTING_SRCS.include('lib/**/*.*')
SETTING_SRCS.include('__wxautoload.rb')




module Util
	def self.zip(dest, srcs)
		buf = []
		srcs.each do |path|
			buf << path
			if buf.size >= 16 then
				list = buf.map{|x| %Q|"#{x}"|}.join(' ')
				sh "zip -q #{dest} #{list}"
				buf.clear
			end
		end
		
		list = buf.map{|x| %Q|"#{x}"|}.join(' ')
		sh "zip -q #{dest} #{list}"


		puts "#{dest} created. (#{(File.size(dest) / 1024.0 / 1024.0).to_i}MB)"
	end
end



task :default => :build

desc "Package all release files, with Info-zip. (default)"
task :package => PACKAGE_NAME

file PACKAGE_NAME => :build do |task|
	packaged = FileList.new
	packaged.include('darkhall.exe')
	packaged.include('setting.exe')
	packaged.include('*.exe.manifest')
	packaged.include('res/bgm.dat')
	packaged.include('res/enemy.dat')
	packaged.include('res/picture.dat')
	packaged.include('res/dungeon_texture.dat')
	packaged.include('res/icon/*')
	packaged.include('res/se/**/*')
	packaged.include('res/font/KonatuTohaba.ttf')
	packaged.include('res/font/ume-tgc5.ttf')
	packaged.include('lib/wxruby2.so')
	packaged.include('data/*.dat')
	packaged.include('data/message/*.dat')
	packaged.include('data/dungeon/?f.dat')
	packaged.include('data/dungeon/dungeon_form.mpac')
	packaged.include('data/locale')
	#packaged.include('data/locale/**/*.mo')
	packaged.include('manual.txt')
	packaged.include('doc/**/*')
	#packaged.include('changelog.txt')
	#packaged.include('license.txt')
	#packaged.include('po/**/*.{po,pot}')
	packaged.include('*.dll')
	packaged.exclude('msvc*.dll')


	list = packaged.to_a.map{|x| %Q|"#{x}"|}.join(' ')
	sh "zip -q #{task.name} #{list}"
	puts "#{task.name} created. (#{(File.size(task.name) / 1024.0 / 1024.0).to_i}MB)"
end

namespace :package do
	task :src => SRC_PACKAGE_NAME
	
	file SRC_PACKAGE_NAME do |task|
		packaged = FileList.new
		packaged.include('Rakefile.rb')
		packaged.include('*_exe.rb')
		packaged.include('*.exe.manifest')
		packaged.include('lib/**/*')
		packaged.include('data/**/*.rb')
		packaged.include('data/dungeon/dungeon_form.mpac')
		packaged.include('manual.txt')
		packaged.include('doc/**/*')
		packaged.include('res/')
		
		Util.zip(task.name, packaged)
		
	end
	
	task :res => RES_PACKAGE_NAME
	
	file RES_PACKAGE_NAME do |task|
		packaged = FileList.new
		packaged.include('res/**/*')
		packaged.include('*.dll')
		packaged.include('doc/**/*')
		
		Util.zip(task.name, packaged)
	end

end

=begin
rule '.zip' => '.filelist' do |task|
	rm(task.name, :verbose => true) if File.exist?(task.name)
	sh "#{ZIP} a -tzip #{task.name} @#{task.source}"
end

file 'darkhall_snapshot00.filelist' => packaged + [:build] do |task|
	open(task.name, 'w'){|f|
		f.puts(packaged.to_a)
	}
	
	puts "#{task.name} is maked."
end
=end

desc "Clobber and package."
task :repackage => [:clobber, :package]


desc "Generate exe and lang-files. (default task)"
task :build => [:data, :res, :mo, 'darkhall.exe', 'setting.exe']

rule '.exe' => '.exy' do |task|
	sh "#{EXERB} -o #{task.name} #{task.sources.first}"
end

data = [
	['darkhall.exy', SRCS, 'darkhall_exe.rb --test-run'],
	['setting.exy', SETTING_SRCS, 'setting_exe.rb'],
]
data.each do |target, src_list, cmd|
	file target => src_list do |task|
		sh "ruby -r exerb/mkexy #{cmd}"
		
		mkexy_output = "#{File.basename(task.name, '.exy')}_exe.exy"
		mv(mkexy_output, task.name)
		
		exy = YAML.load_file(task.name)
		exy['general']['core'] = 'gui'
		exy['general']['kcode'] = 'utf8'
		
		exy['file']['msvcr71.dll'] = {'type' => 'dynamic-library'}
		exy['file']['msvcp71.dll'] = {'type' => 'dynamic-library'}
		exy['file'].delete('wxruby2.so')
		#exy['file'].delete_if{|k, v| k =~ /\.\/lib/}
		exy['resource'] ||= {}
		exy['resource']['icon'] = []

		case target
		when 'darkhall.exy'
			[4, 8].each do |c|
				[48, 32, 16].each do |size|
					exy['resource']['icon'] << {'width' => size, 'height' => size, 'color' => c, 'file' => 'res/icon/vit-ruby.ico'}
				end
			end
		when 'setting.exy'
			exy['resource']['icon'] << {'width' => 16, 'height' => 16, 'color' => 8, 'file' => 'res/icon/application-form.ico'}
		end
			
		open(task.name, 'w'){|f| f.write(exy.to_yaml)}
		
	end
end


# This file is generated because Exerb and WxRuby are not friendly.
# (refer to 'Load in all the class extension methods' in lib/wx.rb)
file '__wxautoload.rb' do |task|
	list = nil
	cd 'lib' do
		list = Dir.glob('wx/**/*.rb')
	end
		
	open(task.name, 'w'){|f|
		f.puts "# This file was generated by Rake."
		f.puts "require 'wx'"
		list.each do |name|
			f.puts "require '#{name}'"
		end
	}
	
	puts "#{task.name} maked."
end






targets = []
FileList['data/**/[^_]*.rb'].to_a.each do |src|
	dest = src.gsub(/\.rb\z/, '.dat')
	
	file dest => src do |task|
		open(task.name, 'w'){|f|
			f.write([File.read(src)].pack('m'))
		}
		
		puts "#{src} -> #{task.name}"
	end
	targets << dest
end

desc "encrypt data files."
task :data => targets








desc "Make data documents."
task :datadoc => [:mo, :data, '__wxautoload.rb'] do
	require 'tenjin'
	require 'darkhall'
	include DarkHall
	
	DB.load
	Game.init_global_variables
	Game.init_shop_lineup
	
	
	dir_path = './datadoc/'
	tmpl_dir_path = File.join(dir_path, 'template/')
	tenjin = Tenjin::Engine.new(:path => tmpl_dir_path, :layout => 'layout.rbhtml')
	context = Tenjin::Context.new
	
	context[:member_classes] = [Fighter, HeavyFighter, Archer, Explorer, Prayer, Magician, Academian]
	context[:level_list] = [1, 2, 3, 4, 5, 10, 15, 20, 25, 30, 35, 40, 45, 50]
	
	context[:member_models] = {}
	context[:member_classes].each do |cls|
		context[:member_models][cls] = []
		context[:level_list].each do |level|
			context[:member_models][cls] << cls.new(level, :Young, false)
		end
	end
	
	context[:enemies] = DB.enemies.map{|x| Enemy.new(x.id)}
	
	file_names = %w(
		ability_table exp_table defense_table 3d33_table
		weapon_data armor_data shield_data accessory_data item_data
		treasure_data enemy_data spell_data equipment_table enemy_state_resist_data
	)
	file_names.each do |name|
		path = File.join(dir_path, "#{name}.html")
		open(path, 'w'){|f|
			f.write tenjin.render("#{name}.rbhtml", context)
		}
		puts "#{path} maked."
	end

end



desc "== clobber"
task :distclean => :clobber

desc "Distclean and build."
task :rebuild => [:clobber, :default]





# Ruby-GetText Task
data = {
	'system' => Dir.glob("lib/darkhall/**/*.rb"),
	'dungeon' => Dir.glob("data/dungeon/*f.rb"),
	'spell' => Dir.glob("data/{spell,trick}.rb"),
	'item' => Dir.glob("data/{item,weapon,armor,accessory}.rb"),
	'enemy' => Dir.glob("data/enemy.rb"),
	'message' => Dir.glob("data/message/*.rb"),
	'setting' => Dir.glob("setting_exe.rb"),
}

namespace :po do
	data.each_pair do |name, filelist|
		desc "Update pot/po files relating to #{name}."
		task name => filelist do
			require 'gettext/tools'
			ver_id = 'DarkHall beta'
			
			GetText.update_pofiles("darkhall_#{name}", filelist, ver_id)
		end
	end
end

desc "Update all pot/po files."
task :po => data.keys.map{|x| "po:#{x}"}



desc "Create mo-files"
task :mo do
  require 'gettext/tools'
  GetText.create_mofiles(:verbose => true)
end


# Proc for initializing each spec-tasks by common parameters
setting = proc do |st|
	st.ruby_opts = %w(-Ku)
end


desc "Verify all spec files."
Spec::Rake::SpecTask.new do |st|
	setting.call(st)
	st.spec_files = FileList['spec/*.rb']
end

desc "Verify all spec files with specdocs."
Spec::Rake::SpecTask.new(:specd) do |st|
	setting.call(st)
	st.spec_opts << '-fs'
	st.spec_files = FileList['spec/*.rb']
end



namespace :spec do
	Dir.glob('spec/*.rb') do |path|
		desc "Verify '#{path}'"
		Spec::Rake::SpecTask.new(File.basename(path, '.rb')) do |st|
			setting.call(st)
			st.spec_files = FileList[path]
		end
	end
end

namespace :specd do
	Dir.glob('spec/*.rb') do |path|
		desc "Verify '#{path}' with specdocs."
		Spec::Rake::SpecTask.new(File.basename(path, '.rb')) do |st|
			setting.call(st)
			st.spec_opts << '-fs'
			st.spec_files = FileList[path]
		end
	end
end


task :yaml => FileList['save/*.dat'] do |task|
	task.prerequisites.each do |src|
		dest = "#{src}.yml"
		open(src, 'rb'){|f|
			data = MessagePack.unpack(f.read)
			open(dest, 'w'){|f|
				f.write data.to_yaml
			}
		}

		puts "#{src} => #{dest}"
	end
end





