#! ruby -Ku
#-----------------------------------------------------------
# DarkHall Runner Script
#
# Author:   Team D.H. <team.darkhall@gmail.com>
# License:  NYSL 0.9982 <http://www.kmonos.net/nysl/>
#           (unlike other files)
# URL:      http://wiz.morphball.net/darkhall/
#-----------------------------------------------------------

$LOAD_PATH.unshift './lib'

require 'ropt'
require 'gettext'
opt = ROpt.parse(ARGV, 'hcdm:s:fl:', 'help', 'check', 'dump', 'debug', 'music-volume:', 'sound-volume:', 'test-run', 'full-screen', 'locale:')


if opt.nil? then
	$stderr.puts(<<ECHO)
ERROR: invalid option.
       If you want usage, type 'darkhall_start --help'.
ECHO
	exit
end

if opt['help'] or opt['h'] then
	$stderr.puts(<<ECHO)
Options:
  -c, --check
    only check all savedata, but not start game.
  -d, --debug
    start game within debug mode.
  -f, --full-screen
    full-screen mode.	
  -l [name], --locale [name]
    set locale.
  -m [level], --music-volume [level]
    set music volume. (level: 0 - 8)
  -s [level], --sound-volume [level]
    set sound effect volume. (level: 0 - 8)
  --test-run
    test running. (load all files and scripts, but not start game) this option exists for exerb.
  -h, --help
    display this document.
ECHO
	exit
end

OptionInfo = Struct.new(:locale, :full_screen, :music_volume, :sound_volume)
$option_info = OptionInfo.new
$option_info.full_screen = opt['full-screen'] || opt['f']
$option_info.music_volume = opt['music-volume'] || opt['m']
$option_info.sound_volume = opt['sound-volume'] || opt['s']
$option_info.locale = opt['locale'] || opt['l']


# load
require 'darkhall'
include DarkHall


# 二重起動チェック
if Util.multiple_boot? then

	catch(:dialog){
		app = Wx::App.new
		def app.on_init
			dialog = Wx::Dialog.new(nil, :title => 'DarkHall 二重起動')
			
			topsz = nil
			dialog.construct_children{
				topsz = vbox_sizer do
					expand
					border 8
					widget Wx::StaticText, :label => "すでに別のゲームプログラムが動作しているようです。\n\nこのまま起動すると、セーブデータに問題が起こる可能性があります。\n別のゲームプログラム（darkhall.exe）が動作している場合、先にそちらを終了させてください。"
					
					hbox_sizer do
						border 4
						stretch_spacer 3
						
						bt = widget Wx::Button, :label => '起動しない'
						dialog.evt_button(bt){exit}
						stretch_spacer 1
						
						bt = widget Wx::Button, :label => '強制的に起動する'
						dialog.evt_button(bt){dialog.hide; throw(:dialog)}
						stretch_spacer 3
					end
				end
			}
			topsz.fit(dialog)
			dialog.show
			dialog.evt_close{ exit }
		end
		app.main_loop
	}
end



begin

	if opt['check'] or opt['c'] then
		%w(n e w s).each do |id|
			save = SaveData.new(SETTING.save_path, id)
			if save.exist? then
				puts "#{save.file_path.cleanpath} checking..."
				Game.init_global_variables
				Game.init_data
				
				save.load
				puts "ok."
			end
		end
		
		exit
	end
	
	
	if opt['debug'] || opt['d'] then
		Game.debug_mode = true
		puts 'debug mode.'
	end
	
	Game.init
	
	
	mvol = $option_info.music_volume
	if mvol then
		if mvol.to_i.in?(0..8) then
			GS.game_config.bgm_volume_level = mvol.to_i
		else
			puts "music volume is out of range, expected from 0 to 8."
			exit
		end
	end
	
	svol = $option_info.sound_volume
	if svol then
		if svol.to_i.in?(0..8) then
			GS.game_config.se_volume_level = svol.to_i
		else
			puts "sound volume is out of range, expected from 0 to 8."
			exit
		end
	end
	
	SDL::Mixer.set_volume_music(GS.game_config.bgm_volume)
	SDL::Mixer.set_volume(-1, GS.game_config.se_volume)
	
	unless opt['test-run'] then
		Game.start
	end
	
rescue StandardError, ScriptError, NoMemoryError
	DarkHall::ErrorReport.call
end