#　αダンジョン

@width = 40
@height = 40


in_region(:Entrance){
	set_wall(DIR_N, 10, 1, Area::EXIT_DOOR)
	set_route(10, 1, 1, 12)
	set_wall(DIR_S, 10, 10) unless GS.switch[:ShutterSwitch]

	set_route(6, 2, 9, 1)
	set_room(11, 4, 2, 2)
	set_door(DIR_E, 10, 4)
	set_door(DIR_W, 10, 4)
	set_room(8, 4, 2, 2)
	set_door(DIR_S, 8, 5)
	
	set_room(7, 6, 2, 1)
	set_door(DIR_N, 7, 6)
	set_route(5, 5, 3, 1)
	set_route(5, 5, 1, 4)
	set_route(5, 8, 3, 1)
	set_route(7, 8, 1, 3)
	set_door(DIR_E, 7, 9)
	set_room(8, 8, 2, 3)
	set_door(DIR_E, 4, 8)
	
	# 西側の離れ
	set_route(4, 8, 1, 3)
	set_route(2, 10, 3, 1)
	set_route(2, 9, 1, 2)
	set_door(DIR_N, 2, 9)
	set_room(1, 7, 3, 2)
	set_wall_area(3, 8, 1, 2)
	
	# 西側の部屋1
	set_door(DIR_S, 6, 2)
	set_room(6, 3, 2, 2)
	
	# 東側の部屋1
	set_door(DIR_S, 14, 2)
	set_room(13, 3, 2, 2)
	
	# >回廊
	set_door(DIR_S, 13, 4)
	set_route(13, 5, 1, 2)
	set_route(11, 6, 3, 1)
	set_route(11, 6, 1, 6)
	
	# >>いくつもの小部屋
	set_door(DIR_E, 11, 7)
	set_room(12, 7, 2, 2)
	set_door(DIR_E, 11, 9)
	set_room(12, 9, 2, 2)
}

in_region(:Annex){
	# >>>宝
	set_door(DIR_E, 11, 11)
	set_route(12, 11, 3, 1)
	set_room(15, 10, 3, 3)
	set_door(DIR_W, 15, 11)
	set_wall_area(17, 11, 1, 1)

	set_tereport_point(10, 2)
	set_tereport_point(6, 4)
	set_tereport_point(13, 8)
	
	# >>>つながり
	set_door(DIR_E, 13, 8)
	set_door(DIR_E, 13, 10)
	set_route(14, 5, 1, 6)
	set_route(14, 5, 2, 1)
	set_door(DIR_N, 15, 5)
	set_door(DIR_S, 15, 5)
	
	# >>>>東の離れ小部屋
	set_route(15, 4, 3, 1)
	set_door(DIR_N, 17, 4)
	set_room(17, 2, 1, 2)
	
	set_route(15, 6, 5, 1)
	set_route(17, 6, 1, 3)
	set_route(17, 8, 2, 1)
	set_door(DIR_E, 18, 8)
	set_room(19, 8, 2, 2)
	set_wall_area(20, 9, 1, 1)
	
	set_route(19, 4, 1, 3)
	set_door(DIR_N, 19, 4)
	set_room(19, 2, 1, 2, :ShutterSwitchRoom)
}

in_region(:Maze){
	# 外周
	set_route(6, 12, 9, 1)
	set_route(6, 12, 1, 2)
	set_route(14, 12, 1, 2)
	set_route(5, 13, 2, 1)
	set_route(14, 13, 2, 1)
	set_route(5, 13, 1, 9)
	set_route(15, 13, 1, 9)
	set_route(5, 21, 2, 1)
	set_route(6, 21, 1, 2)
	set_route(6, 22, 9, 1)
	set_route(14, 21, 2, 1)
	set_route(14, 21, 1, 2)
	
	
	# 行き止まりルート
	set_door(DIR_W, 15, 16)
	set_room(13, 15, 2, 2)
	set_room(11, 13, 2, 1)
	set_door(DIR_N, 14, 15)
	set_route(13, 13, 1, 2); set_route(12, 14, 3, 1); set_route(12, 14, 1, 2)
	set_door(DIR_W, 13, 13)
	
	
	# 正しいルート
	set_door(DIR_E, 5, 17)
	set_route(6, 17, 2, 1)
	set_door(DIR_N, 7, 17)
	set_room(6, 15, 2, 2)
	set_door(DIR_N, 6, 15)
	set_route(6, 14, 3, 1)
	set_route(8, 14, 1, 2)
	set_route(7, 13, 1, 2)
	set_door(DIR_E, 7, 13)
	set_room(8, 13, 2, 1)
	set_door(DIR_E, 7, 17)
	set_route(8, 17, 2, 1)
	set_route(9, 17, 1, 4)
	set_route(7, 20, 3, 1)
	set_door(DIR_W, 7, 20); set_door(DIR_S, 7, 20)
	set_route(6, 19, 1, 2)
	set_door(DIR_E, 6, 19)
	set_room(6, 18, 2, 1); set_room(7, 18, 2, 2)
	set_route(7, 21, 7, 1)
	set_door(DIR_S, 13, 21)
	
	set_door(DIR_W, 10, 18)
	set_route(10, 18, 5, 1)
	set_door(DIR_S, 11, 18)
	set_door(DIR_S, 13, 18)
	set_room(10, 19, 2, 2); set_room(12, 19, 3, 2)
	set_door(DIR_N, 14, 18)
	set_route(12, 16, 1, 2); set_route(12, 17, 3, 1)
	set_door(DIR_W, 12, 16)
	set_room(10, 16, 2, 2); set_room(8, 16, 3, 1)
	set_door(DIR_N, 10, 16)
}
in_region(:BossRoom){
	# ボス部屋
	set_room(9, 14, 3, 2); set_room(10, 13, 1, 2)
}


def on_enter_region(party, old_region)
	case party.region
	when :ShutterSwitchRoom
		dungeon_message("何の変哲もない小部屋だが\n奥の壁にレバーのようなものが見える")
	when :BossRoom
		if GS.switch[:BreakLostArmor] then
			dungeon_message("調度の整えられた部屋だ\n部屋の奥に、傷だらけの鎧が放置してある")
		elsif GS.switch[:FoundBossRoom] then
			dungeon_message("調度の整えられた部屋だ\n奥に鎧一式が立て掛けられている")
		else
			dungeon_message("この部屋は他の部屋と比べ、きちんと調度が整えてある\n床には絨毯が、壁には明かりの消えたロウソクがある")
			dungeon_message("また部屋の奥には、金属製らしき鎧一式が立て掛けられている\nかなり古いもののはずだが、あまり埃が積もっていない")
			GS.switch[:FoundBossRoom] = true
		end
	end
end

def on_move(party)
	if party.is_position?(10, 10, DIR_S) then
		unless GS.switch[:ShutterSwitch] then
			if GS.switch[:FoundShutter] then
				dungeon_message("鉄製の扉がある\n取っ手らしきものは見当たらない")
			else
				dungeon_message("ただの石壁のように見えたが、よく見ると鉄製の扉のようだ\nしかし取っ手らしきものが見当たらないため\nどうやって開ければいいのか、よく分からない")
				GS.switch[:FoundShutter] = true
			end
		end
	elsif party.is_position?(19, 2, DIR_N) then
		show_special_action(:shutter_switch, "レバーを下ろす")
	elsif party.is_position?(10, 13, DIR_N) && !(GS.switch[:BreakLostArmor]) then
		show_special_action(:detect_armor, "鎧を調べる")
	elsif party.is_position?(10, 13, DIR_N) && GS.switch[:BreakLostArmor] then
		show_special_action(:detect_broken_armor, "壊れた鎧を調べる")

	end
end

def on_special_action(party, action_id)
	case action_id
	when :shutter_switch
		if GS.switch[:ShutterSwitch] then
			message("レバーはすでに下ろしてある")
		else
			if Game.ask("壁にレバーがある。上がった状態だ\n下ろしてみる？") then
				GS.switch[:ShutterSwitch] = true
				reload_dungeon
				message("#{GS.party.alive_members.first.name}はレバーを下ろした")
				save
			end
		end
	when :detect_armor
		save
		if GS.switch[:BreakLostArmor] then
			message("今はもう動かない鎧だ")
			return
		elsif GS.switch[:FoundLostArmor] then
			message("近づいた途端、鎧はひとりでに動き出した！")
		else
			message("この鎧はどうやら、鉄製のプレートメイルのようだ\nデザインは今見ると少々古めかしい\n\nおそらくは騎士の誰かが使っていたのだろう、傷だらけだ")
			BGM.fade_out
			message("……？\n\n傷のほかに、新しい返り血が……？")
			message("それに気づいた途端、鎧はひとりでに動き出した！")
			GS.switch[:FoundLostArmor] = true
		end
		$troop = BossTroop.new
		$troop.add_enemies(:LostArmor, 1)
		Phase.change(BattleStartPhase.new)
		
	when :detect_broken_armor
		save
		
		if GS.switch[:ReviveLostArmor] then
			message("壊したはずの鎧が、再びひとりでに動き始めた！")
			$troop = BossTroop.new
			$troop.add_enemies(:LostArmor2, 1)
			Phase.change(BattleStartPhase.new)

		else
			message("今はもう動かない鎧だ")
		end


	end
end




=begin
イベント発生条件：指定位置に進入(PointEvent)、指定リージョンに進入(RegionEvent)


on_walk = proc do
end

on_detect = proc do
end

on_action = proc do |action_id|
end


=end
