#! ruby -Ku
#-----------------------------------------------------------
# DarkHall Setting Application
#
# Author:   Team D.H. <team.darkhall@gmail.com>
# License:  NYSL 0.9982 <http://www.kmonos.net/nysl/>
#           (unlike other files)
# URL:      http://wiz.morphball.net/darkhall/
#-----------------------------------------------------------
$KCODE = 'u'
$LOAD_PATH.unshift 'lib'

require 'wx'
require 'wxconstructor'
require '__wxautoload'

require 'locale'
require 'gettext'
require 'ini'
require 'ropt'
require 'rubyplus'
require 'anjson'

require 'darkhall/setting'

GetText.bindtextdomain('darkhall_setting', :path => './data/locale')
include GetText


module DarkHallConfig
	SETTING = DarkHall::SETTING
	class App < Wx::App
		include GetText
		def on_init
			@frame = MainFrame.new(nil, :title => _('DarkHall動作設定'))
			@frame.show
		end
	end
	
	SelectItem = Struct.new(:id, :caption)
	
	class MainFrame < Wx::Frame
		attr_reader :screen_mode_selects, :language_selects
		attr_reader :mixer_frequency_selects, :mixer_chunk_size_selects
		attr_reader :logging_type_selects
	
		include GetText
		def initialize(*args)
			super
			self.window_style ^= Wx::RESIZE_BORDER


			@screen_mode_selects = [
				SelectItem.new('window', _('ウインドウ表示（640×480）')),
				SelectItem.new('full_screen', _('フルスクリーン')),
			]
			
			@language_selects = [
				SelectItem.new('ja', _('日本語')),
				SelectItem.new('en', _('英語')),
			]

			@mixer_frequency_selects = [
				SelectItem.new('22050', _('22.05 kHz （低負荷）')),
				SelectItem.new('44100', _('44.1 kHz （標準）')),
				SelectItem.new('88200', _('88.2 kHz （高負荷・良音質）')),
			]
			
			@mixer_chunk_size_selects = [
				SelectItem.new('512', _('0.5KB（音ずれが起こりにくい）')),
				SelectItem.new('1024', _('1KB（標準）')),
				SelectItem.new('2048', _('2KB')),
				SelectItem.new('4096', _('4KB（音が途切れにくい）')),
			]
			
			@logging_type_selects = [
				SelectItem.new('no', _('記録しない')),
				SelectItem.new('delete', _('記録する（古いログは削除）')),
				SelectItem.new('compress', _('記録する（古いログは圧縮して残す）')),
			]


			topsz = nil
			construct_children do |frame|
				widget Wx::Panel do
					topsz = vbox_sizer do
						expand
						border 4
					
						hbox_sizer do
							border 4
							
							#radio = widget(Wx::RadioBox,
							#               :style => Wx::RA_SPECIFY_COLS,
							#               :major_dimension => 1,
					    #               :choices => frame.language_selects.map{|x| x.caption},
							#							 :label => _('表示言語'),
							#							 :name => 'language')
							#radio.selection = frame.language_selects.map{|x| x.id}.index(SETTING.language)

							#radio = widget(Wx::RadioBox, :style => Wx::RA_SPECIFY_COLS,
							#               :major_dimension => 1,
					    #               :choices => frame.screen_mode_selects.map{|x| x.caption},
							#							 :label => _('画面モード'),
							#							 :name => 'screen_mode')
							#radio.selection = frame.screen_mode_selects.map{|x| x.id}.index(SETTING.screen_mode)

							radio = widget(Wx::RadioBox, :style => Wx::RA_SPECIFY_COLS,
							               :major_dimension => 1,
					                   :choices => frame.mixer_frequency_selects.map{|x| x.caption},
														 :label => _('音の周波数'),
														 :name => 'mixer_frequency')
							radio.selection = frame.mixer_frequency_selects.map{|x| x.id}.index(SETTING.mixer_frequency.to_s)
							
							radio = widget(Wx::RadioBox, :style => Wx::RA_SPECIFY_COLS,
							               :major_dimension => 1,
					                   :choices => frame.mixer_chunk_size_selects.map{|x| x.caption},
														 :label => _('音に割り当てるメモリサイズ'),
														 :name => 'mixer_chunk_size')
							radio.selection = frame.mixer_chunk_size_selects.map{|x| x.id}.index(SETTING.mixer_chunk_size.to_s)
							
							#radio = widget(Wx::RadioBox, :style => Wx::RA_SPECIFY_COLS,
							#              :major_dimension => 1,
					    #              :choices => frame.logging_type_selects.map{|x| x.caption},
							#						 :label => _('動作ログの記録'),
							#							 :name => 'logging_type')
							#radio.selection = frame.logging_type_selects.map{|x| x.id}.index(SETTING.mixer_chunk_size.to_s)

						end
						
						
						hbox_sizer do
							stretch_spacer 1
							button = widget Wx::Button, :label => _('確定')
							frame.evt_button(button, :on_decide)
							stretch_spacer 1
						end
					end
				end
			end
			
			topsz.fit(self)
		end
		
		def on_decide
			open('setting.ini', 'w'){|f|
				f.puts '[General]'
				#f.puts 'Language = '+ @language_selects[find_window_by_name('language').selection].id
				f.puts 'Language = ja'
				#f.puts 'ScreenMode = ' + @screen_mode_selects[find_window_by_name('screen_mode').selection].id
				f.puts 'ScreenMode = window'
				f.puts 'MixerFrequency = '+ @mixer_frequency_selects[find_window_by_name('mixer_frequency').selection].id
				f.puts 'MixerChunkSize = '+ @mixer_chunk_size_selects[find_window_by_name('mixer_chunk_size').selection].id
			}
			exit
		end
		
		def on_font_select
			dialog = Wx::FontDialog.new
			dialog.show_modal
			@font_text.value = dialog.font_data.chosen_font.face_name
			
		end
	end
	
end

app = DarkHallConfig::App.new
unless $LOADED_FEATURES.include?('exerb/mkexy.rb') then
	app.main_loop
end