
module DarkHall
	include Section
	$section = TOWN

	

	class AdventureResultPhase < Phase
		def on_enter(from)
			$windows = [DATA_WINDOW, PARTY_WINDOW]
			texts = DATA_WINDOW.texts.clear
			
			texts << ["冒険の結果", ""]
			texts << ["手に入った金貨", "300枚"]
			texts << ["戦闘回数", "10回"]
			texts << ["殺した敵の数", "20体"]
			texts << ["死者", "0人"]
			texts << ["進展", "とくになし"]
		end
	end


	
	class SleepPhase < Phase
		def on_enter(from)
			super
			$windows = []
			@main_window = DoubleTextWindow.new
			@main_window.inline_tag_usable = true
			@main_window.has_caption = true
			self.message_sequence(_("%{party}は宿屋で過ごしています").evaluate(:party => GS.party.name))
		end
		
		def message_sequence(msg)
			message(msg)
			$phase.on_enter_key
		end
		
		def on_enter_key
			existing_members = GS.existing_members
			
		
			# 加齢＆誕生日チェック
			member = existing_members.find{|x| x.aging?}
			
			if member then
				member.age = member.get_collect_age
				if (GS.week - member.birth_week).modulo(WEEK_PER_YEAR) == 0 then
					msg = n_("お誕生日おめでとう！\n%{member}は%{age}歳になりました", "お誕生日おめでとう！\n%{member}は%{age}歳になりました", member.age)
				else
					msg = n_("誕生日は過ぎてしまいましたが\n%{member}は%{age}歳になりました", "誕生日は過ぎてしまいましたが\n%{member}は%{age}歳になりました", member.age)
				end
				
				#if member.age >= 80 then
					
				#end
				
				self.message_sequence(msg.evaluate(:member => member.name, :age => member.age))
				return
			end
			
			# 老衰(基本は70歳から。ただし再生回数によって早まる)
			existing_members.find_all{|x| not x.life_end?}.each do |member|
				member.elapsed_week += 1
			
				# 5週ごとに判定
				if (GS.week - member.birth_week) % 5 == 0 then
					border = 80 + 70 - member.age - member.regenerated * 2
					if border <= 80 then
						dice = CheckDice.new(border)
						LOGGER.puts "#{member.name}の老衰判定: #{dice.failure_percentage}%で老化 (border=#{dice.border})"
						if dice.roll then
							LOGGER.puts "\t=> ロール成功"
						else
							member.senility += 1
							LOGGER.puts "\t=> 老化 (#{member.senility})"
							
							# 老衰8から霊魂化判定
							if member.senility >= 8 then
								dice = CheckDice.new(70 - (member.senility - 8) * 4)
								LOGGER.puts "#{member.name}の霊魂化判定: #{dice.failure_percentage}%で霊魂化 (border=#{dice.border})"
								if dice.roll then
									LOGGER.puts "\t=> ロール成功"
									Game.message(_("%{member}は、老化による体の衰えを感じた").evaluate(:member => member.name))
								else
									LOGGER.puts "\t=> 霊魂化"
									member.kill_to_soul
									member.life_end_week = GS.week
									Game.message(_("%{member}は老衰により、齢%{age}でその生涯を終え、霊魂と化した……").evaluate(:member => member.name, :age => member.age))
								end
							else
								Game.message(_("%{member}は、老化による体の衰えを感じた").evaluate(:member => member.name))
							end
						end
					end
				end
			end
		
			
			# レベルアップチェック
			member = existing_members.find{|x| x.levelup?}
			if member then
				old_member = member.dup
				old_mp_max = member.mp_max.dup
				old_spell_learning = member.spell_learning.dup
				
				levelup_data = member.levelup
				@levelup_disp_reserved = true
				message(_("%{member}はレベルが%{level}に上がりました！").evaluate(:member => member.name, :level => member.level))
				
				
				
				@texts = @main_window.texts.clear
				
				@texts << [_("%{member}の能力成長").evaluate(:member => member.name)]
					
				# HP
				levelup_disp_sequence(_("ＨＰ"), old_member.hp_max, member.hp_max)

				ABILITY_TYPES.each do |type|
					levelup_disp_sequence(ABILITY_CAPTIONS[type], old_member.get_ability(type), member.get_ability(type))
				end

				
				# MP
				#if member.spell_caster? then
				#	member.spells.each do |spell_id|
				#		name = _("最大ＭＰ(%{spell})").evaluate(:spell => DB.find_spell(spell_id).short_name)
				#		levelup_disp_sequence(@mp_window, name, old_mp_max[spell_id], member.mp_max[spell_id])
				#	end
				#end
				
				if levelup_data[:spell_id] then
					spell_name = DB.find_spell(levelup_data[:spell_id]).short_name
					@main_window.texts << [_("%{spell}の術を習得した！").evaluate(:spell => spell_name)]
				else
					@main_window.texts << []
				end

				if member.spell_caster? and member.spell_max > old_member.spell_max then
					@main_window.texts << [_("呪文の最大習得数が増加した！")]
				else
					@main_window.texts << []
				end

				
				#line_number = columns[0].captions.size
				
				
				if (rest_exp = member.rest_exp_to_next) then
					rest_exp = 0 if rest_exp < 0
					msg = n_("(次のレベルまであと%{rest}Exp)", "(次のレベルまであと%{rest}Exp)", rest_exp)
				else
					msg = _('最大レベルに到達した')
				end
				@main_window.texts << []
				@main_window.texts << [nil, msg.evaluate(:rest => rest_exp)]
				@main_window.set_good_width.make_surface(300, 11).update
				@main_window.centering_on_screen.show
				
				return
			end
			
			
			# 週経過処理
			GS.week += 1
			Game.set_room_events
			Game.set_merchant_products
			
			# 蘇生処理
			waiting_ids = []
			while (id = GS.reviving_member_ids.shift) do
				member = GS.members[id]
				member.remaining_week_before_revived ||= 0
				member.remaining_week_before_revived -= 1
				
				# 儀式が終了している場合の処理
				if member.remaining_week_before_revived <= 0 then
					if member.soul? then
						# 再生
						member.revive
						member.on_regenerated

						LOGGER.puts "#{member.name}の再生が完了 (再生回数: #{member.regenerated})"
					else
						# 通常の蘇生
						dice = CheckDice.new(member.revive_border)
						LOGGER.puts "#{member.name}の蘇生成功確率: #{dice.success_percentage}% (#{dice.border})"
						if dice.check then
							member.revive
							LOGGER.puts "\t=> 成功"
						else
							member.soul = true
							LOGGER.puts "\t=> 失敗"
						end
					end
					member.remaining_week_before_revived = 0
					GS.revived_member_ids << id
				else
					waiting_ids << id
					LOGGER.puts "#{member.name}の蘇生完了まであと#{member.remaining_week_before_revived}週"
				end
			end
			GS.reviving_member_ids = waiting_ids
			
			# ルーインフェザー復帰判定
			if not GS.switch['BusterRuinFeather'] and GS.switch['RuinFeatherEscape'] then
				GS.switch['WeekFromRuinFeatherEscape'] ||= 0
				GS.switch['WeekFromRuinFeatherEscape'] += 1
				LOGGER.puts "ルーインフェザーの逃走から#{GS.switch['WeekFromRuinFeatherEscape']}週が経過"
				
				if (week = GS.switch['WeekFromRuinFeatherEscape']) >= 10 and GS.dungeon_parties.empty? then
					dice = CheckDice.new(week * 4)
					LOGGER.puts "\t復帰確率: #{dice.success_percentage}% (#{dice.border})"
					if dice.roll then
						LOGGER.puts "\t<復帰>"
						GS.switch['RuinFeatherEscape'] = false
					end
				end
			end
			
			Game.save(FQ_BIG_CHANGE, "週経過")
			PARTY_WINDOW.update
			Phase.change(TownMenuPhase.new)
		end
		
		def levelup_disp_sequence(caption, old_value, new_value)
			format = "%3s %2s %3s"
			if new_value > old_value then
				right_text = sprintf("%4d  →  $c[good]%4d$c", old_value, new_value)
			elsif new_value == old_value then
				right_text = sprintf("%4d          ", old_value)
			elsif new_value < old_value then
				right_text = sprintf("%4d  →  $c[bad]%4d$c", old_value, new_value)
			end
			
			@main_window.texts << [caption, right_text]
		end
	end

	

	
	

	
	
	
	

	
	
	
end
