require 'wx'
require 'wxconstructor'



module DarkHall
	module Game
		def self.show_name_input_dialog(message, default = "")
			$tmp = {}
			$tmp[:message] = message
			$tmp[:default] = default
			NameInput::App.new.main_loop
			
			return $tmp[:result]
		end
	end

	module NameInput
		class App < Wx::App
			include GetText
			def on_init
				@dialog = MainDialog.new(nil, :title => s_('Dialog|名前の入力'))
				@dialog.show_modal
				
				return false # 即時終了
			end
		end
		
		class MainDialog < Wx::Dialog
			include GetText
			def initialize(*args)
				super
				self.window_style |= Wx::STAY_ON_TOP
				centre
	
				topsz = nil
				text = nil
				dialog = self
				construct_children do
					widget Wx::Panel do
						topsz = vbox_sizer do
							expand
							border 8
							widget Wx::StaticText, :label => $tmp[:message]
							text = widget Wx::TextCtrl, :name => 'name_input', :value => $tmp[:default]
							text.set_focus
							
							hbox_sizer do
								stretch_spacer 1
								proportion 1
								but = widget Wx::Button, :label => s_('Dialog|決定')
								but.set_default
								dialog.evt_button(but, :on_decide)
								stretch_spacer 1
							end
						end
					end
				end
				
				topsz.fit(self)
				dialog = self
				
				# マウスで選択肢を選んだ直後にダイアログを開くと、フォーカスが外れる（原因不明）
				# その対策として0.1秒後にフォーカスを再セット
				Wx::Timer.after(100){
					dialog.set_focus
					text.set_focus
				}
			end
			
			def on_decide
				$tmp[:result] = find_window_by_name('name_input').value
				if $tmp[:result].empty? then
					$tmp[:result] = nil
				end
				close
			end
		end
		
	end
end
