@name = _("第三階層")
@bgm = :Dungeon2
@width = 40
@height = 60



in_region(:Entrance){
	appearing_enemy 2, :BladeSkelton
	appearing_enemy 2, :Slime
	appearing_enemy 1, :BladeSkelton, :Pixie
	treasure_level 5

	set_stair(4, 2, DIR_N, '2', 24, 1, DIR_S)
	set_door(19, 2, DIR_N)
	
	# メインセクション
	set_locked_door(10, 1, DIR_S, '3f_entrance1', :KeyOfGraveKeeper)
	set_locked_door(13, 1, DIR_S, '3f_entrance2', :KeyOfGraveKeeper)
	set_locked_door(23, 34, DIR_S, '3f_general_room', :KeyOfGeneral)
	#set_locked_door(26, 29, DIR_N, '3f_deep', :KeyOfWizard)
	
	set_one_way_door(1, 18, DIR_W)
	set_one_way_door(2, 18, DIR_W)

}

# 入り口の近く
in_region(:SmallRoom1){
	appearing_enemy 1, :BladeSkelton
	appearing_enemy 1, :Slime
	treasure_level 5
}


in_region(:BigRoom1){
	appearing_enemy 3, :BladeSkelton
	appearing_enemy 1, :BladeSkelton, :BladeSkelton
	appearing_enemy 1, :BladeSkelton, :Pixie
	treasure_level 5
}


in_region(:SmallRoom2){
	appearing_enemy 1, :BladeSkelton, :Slime
	appearing_enemy 1, :Ghost
	treasure_level 6
}


in_region(:BigRoom2){
	appearing_enemy 1, :BladeSkelton
	appearing_enemy 1, :BladeSkelton, :Ghost
	appearing_enemy 1, :BladeSkelton, :BladeSkelton
	treasure_level 6
}



in_region(:TrainingRoom){
	treasure_level 6
	appearing_enemy 1, :BladeSkelton, :BladeSkelton, :BladeSkelton, :BladeSkelton
}

in_region(:GlimRoom){
}

in_region(:GeneralRoom){
}

in_region(:GeneralRepository){
}

in_region(:GeneralStudy){
}

in_region(:Library){
}

in_region(:GlimWandRoom){
}


def on_move(party)
	if party.is_position?(5, 24) or party.is_position?(5, 29) then
		Game.working(_('床が右方向に回っている！'), 240){
			SE.trap_switch
			(rand(3) + 2).times do
				Game.wait(12)
				party.turn_right
				DUNGEON_WINDOW.update
				#SE.step
			end
		}
	elsif party.on?(3, 30) or party.on?(8, 29) then
		shoot(nil, 32, 17, DIR_W)
	
		

	elsif party.on?(29, 8, DIR_N) then
		dungeon_message(_("扉に文字が彫り込んである\n\n- 練兵場 -"))
	elsif party.on?(23, 34, DIR_S) then
		#message(_("扉に文字が彫り込んである\n\n- 兵隊長室 -"))
	

	elsif party.on?(7, 41, DIR_W) or party.on?(7, 43, DIR_W) or
	party.on?(11, 41, DIR_E) or party.on?(11, 43, DIR_E) then
		message(_("多くの書物が整然と並べられている\nそのほとんどが、武術や戦術に関連したもののようだ\n\n%{party}は、何か役に立つことが書かれていないかと考え、流し読みしてみたが\n特にめぼしい情報は見つけられなかった").evaluate(:party => party.name))
	elsif party.on?(26, 26, DIR_N) then
		if GS.switch[:BusterLostArmor] then
			show_special_action(:special_detect, _("[A] 鎧を調べる"), 'A')
		else
			message(_("まるで扉を塞ぐかのように、扉に大きな鎧がもたれかかっている\n\n甲冑の隙間には埃が溜まっている……\nかなり長い間、動かしも手入れもされていないようだ"))
			if Game.ask(_("この鎧を動かしますか？")) then
				message(_("……？\n冒険者が手をかけた瞬間に、鎧が少し動いたような気がする……"))
				if Game.ask(_("気にせず動かしますか？")) then
					BGM.fade_out
					message(_("ふたたび手をかけた瞬間、鎧は空っぽのまま立ち上がった！\n\n小手をゆっくりと動かし、剣を引き抜く……\nその動きはまぎれもなく意志のある動きだ！"))
					#message(_("鎧は剣を構えて、扉の前に立ちふさがった\nこの扉を通すまいとしているのだろうか？"))
					
					troop = BossTroop.new
					troop.add_enemies('LostArmor', 1)
					win = Game.battle(troop, nil)
					if win then
						message(_("鎧は音を立てて崩れ落ちた……\nもう動き出す気配はない"))
						GS.switch[:BusterLostArmor] = true
						show_special_action(:special_detect, _("[A] 鎧を調べる"), 'A')
						Game.save(FQ_BIG_CHANGE, 'ロストアーマー撃破')
					end
				else
					Game.wait(6)
					SE.step
					GS.party.back
					DUNGEON_WINDOW.update
				end
			else
				Game.wait(6)
				SE.step
				GS.party.back
				DUNGEON_WINDOW.update
			end

		end
	elsif party.on?(26, 26) then
		if GS.switch[:BusterLostArmor] then
			show_special_action(:special_detect, _("[A] 鎧を調べる"), 'A')
		end
	end
end

def on_enter_region(party, old_region)
	case party.region_id
	when :Library
		dungeon_message(_("この部屋は、どうやら書庫のようだ\n古びた本棚が左右に配置してある"))
	when :GlimWandRoom
	
		letter = _("祭壇の下には、次のように文字が彫り込んである……\n\n- 君たちはいま、一つの冒険を終えた -\n- この杖はその証である -\n- 杖を携え、光を頼りに町に帰りたまえ -")

		if GS.switch[:GetGlimWand] then
			message(_("小部屋の中に祭壇があるが、その上には何も置かれていない"))
			message(letter)
			
		else
			message(_("小部屋の中に祭壇があり、その上に一本の杖がふわふわと浮かんでいる"))
			message(letter)
			
			Game.ask_about_item_recieving(Weapon.new('GlimWand'), _("杖を取りますか？")) do
				GS.switch[:GetGlimWand] = true
			end
		end
	when :GeneralStudy
		message(_("この小部屋は書斎のようだ\n\n机の上に日記らしき紙の束があるが\n紙やインクの劣化がひどく、まともに読むことはできなさそうだ"))
		message(_("%{member}は紙の束をパラパラとめくり\n最後の数ページから、いくつかの単語だけを読み取ることができた\n\n「……奴ら…………侵攻…………通路で…………通してはならない……」\n「……王…………戻るまで…………深層部……」").evaluate(:member => GS.party.alive_members.first.name))

	when :GeneralRepository
		message(_("小さな部屋に、鎧掛けや剣立てがところ狭しと並んでいる\n武具の保管庫として使われていた部屋のようだ"))
		
		if GS.switch[:GetGeneralMail] and GS.switch[:GetGeneralGauntlet] then
			rest = nil
		elsif GS.switch[:GetGeneralMail]
			rest = _("篭手")
		elsif GS.switch[:GetGeneralGauntlet] then
			rest = _("鎧")
		else
			rest = _("鎧と篭手")
		end
		
		if rest then
			message(_("中央の鎧掛けに%{rest}が残してある！\n古びているが、十分使い物になりそうだ").evaluate(:rest => rest))
			Game.ask_about_item_recieving(Armor.new('GeneralMail'), _("鎧を持っていきますか？")) do
				GS.switch[:GetGeneralMail] = true
			end
	
			Game.ask_about_item_recieving(Accessory.new('GeneralGauntlet'), _("篭手を持っていきますか？")) do
				GS.switch[:GetGeneralGauntlet] = true
			end
		end
	when :GlimRoom
		if (holder = GS.party.find_item_holder('GlimWand')) then
			message(_("%{holder}の持っている灯の杖が、急に赤く輝きはじめた……") % {:holder => holder.name})
		end
	when :Fountain
		fountain


#	when :TrainingRoom
#		BGM.fade_out
#		message('骸骨たちが訓練をしている……')
#	end
	end
end

def on_detect(party)
	if party.region_id == :GlimRoom then
		msg = _("%{detector}は辺りを調べた\n\n隠し階段を発見！\n次の階層に移動しますか？").evaluate(:detector => GS.party.members.first.name)
		if Game.ask(msg) then
			jump_to('1', 18, 20, DIR_S, '隠し階段')
		end
		
		return true
	end
end

def on_door(party)
	if party.on?(1, 13, DIR_N) then
		SE.equip
		message(_("扉はびくともしない\n向こう側から、なにか非常に大きな力がかかっているようだ"))
		return false
	elsif party.on?(19, 2, DIR_N) then
		SE.equip
		message(_("扉はびくともしない\nよく見ると扉の中央に、真新しい文字が刻まれている……\n\n- 未開通 -"))
		return false

	else
		return true
	end
end

def on_special_action(party, action_id)
	case action_id
	when :special_detect
		sent1 = _("%{member}は、もう動かなくなった鎧を調べてみた\n\n古びている上に、戦闘の傷もあってところどころ痛んでいるが\n元々はかなり良質な鎧だったのだろう\n質の良い素材が使われているし、機能性も悪くなさそうだ").evaluate(:member => GS.party.alive_members.first.name)
		sent2 = _("よく見ると、冒険者たちとの戦いでできた傷のほかにも\n古い刀傷やへこんでいる箇所がいくつもある\n残念ながら、金にはならないだろう")

		if GS.switch[:GetKeyOfGeneral] then
			message sent1
			message sent2
		else
			
			message sent1
			message sent2
			Game.ask_about_item_recieving(Item.new('KeyOfGeneral'), _("鎧を動かすと、チャリンと何かが落ちる音がした\nどこかの部屋の鍵のようだ\n\nこの鍵を持っていきますか？")) do
				GS.switch[:GetKeyOfGeneral] = true
			end
		end
	end
end

