
add ItemModel, :Bandage do
	@name = _('包帯')
	@description = _('応急処置に使う包帯。一人のHPを回復する(戦闘中は使用不可)')
	@treasure_rank = 1
	@price = 6
	@effect_descriptions = [:HPCure, :UnusableOnBattle]
	@message_type = :Bandage
	@effect = RecoverEffect.new
	@effect.hp_fixed_recovery = 50
	@effect.battle_usable = false
	@effect.target_type = TG_MEMBER
	@effect.damaged_member_only = true

end

	
add ItemModel, :Sage do
	@name = _('薬草')
	@description = _('高い治療効果を秘めた東方伝来の薬草。応急処置に使う')
	@treasure_rank = 3
	@price = 20
	@effect_descriptions = [:HPCure, :UnusableOnBattle]
	@message_type = :Sage
	@effect = RecoverEffect.new
	@effect.hp_fixed_recovery = 200
	@effect.battle_usable = false
	@effect.target_type = TG_MEMBER
	@effect.damaged_member_only = true

end



=begin

add ItemModel, :RedElixir do
	@name = _('赤いエリクサー')
	@description = _('飲み干すと傷が癒える魔法薬。HPを200程度回復')
	@price = 100
	@message_type = :Bottle
	@effect = RecoverEffect.new
	@effect.hp_fixed_recovery = 200
	@effect.target_type = TG_MEMBER
end

=end


add ItemModel, :PurifyingWater do
	@name = _('清めの水')
	@description = _('頭からかぶることによって毒・呪いを浄化する水。冷たい')
	@treasure_rank = 2
	@price = 16
	@message_type = :Water
	@effect = RecoverEffect.new
	@effect.target_type = TG_MEMBER
	@effect.state_data << [PoisonState, nil] << [CurseState, nil]
end


add PotionModel, :PotionOfVitality do
	@name = _('活力のポーション')
	@description = _('傷を負った体に活力をもたらす薬')
	@treasure_rank = 1
	@price = 60
	@message_type = :Bottle
	@effect = RecoverEffect.new
	@effect.hp_fixed_recovery = 80
	@effect.target_type = TG_MEMBER
end

add PotionModel, :PotionOfLife do
	@name = _('生命のポーション')
	@description = _('傷ついた身体を生命力で満たしてくれる薬')
	@treasure_rank = 2
	@price = 200
	@message_type = :Bottle
	@effect = RecoverEffect.new
	@effect.hp_fixed_recovery = 240
	@effect.target_type = TG_MEMBER
end


add PotionModel, :PotionOfBloodburn do
	@name = _('沸血のポーション')
	@description = _('血を沸き立たせ、筋力を一時的に増強する薬')
	@treasure_rank = 1
	@price = 90
	@message_type = :Bottle
	@effect = RecoverEffect.new
	@effect.hp_fixed_recovery = 50
	@effect.target_type = TG_MEMBER
	@effect.add_state_data << [StrBonusState, 10]
end

add PotionModel, :PotionOfBloodlust do
	@name = _('渇血のポーション')
	@description = _('血の渇きをもたらし、一時的に野獣のごとき力を与える薬')
	@treasure_rank = 2
	@price = 250
	@message_type = :Bottle
	@effect = RecoverEffect.new
	@effect.target_type = TG_MEMBER
	@effect.add_state_data << [StrBonusState, 25]
end


add PotionModel, :PotionOfSleep do
	@name = _('快眠のポーション')
	@description = _('睡眠薬。体力が大きく回復するが、同時に熟睡してしまう')
	@treasure_rank = 1
	@price = 50
	@message_type = :Bottle
	@effect = RecoverEffect.new
	@effect.hp_fixed_recovery = 200
	@effect.target_type = TG_MEMBER
	@effect.add_state_data << [SleepState, 2]
end







add ItemModel, :WhiteIncense do
	@name = _('白の香')
	@description = _('徘徊する魔物を遠ざけるお香')
	@treasure_rank = 2
	@price = 7
	@message_type = :WhiteIncense

	@effect = SpecialEffect.new
	@effect.camp_usable = true
	@effect.proc = proc do |actor|
		GS.party.encount_down(50)
	end
end

add ItemModel, :BlackIncense do
	@name = _('黒の香')
	@description = _('徘徊する魔物を呼び寄せるお香')
	@price = 7
	@message_type = :BlackIncense

	@effect = SpecialEffect.new
	@effect.camp_usable = true
	@effect.proc = proc do |actor|
		GS.party.encount_up(50)
	end
end


add ItemModel, :VisionaryPaper do
	@name = _('幻紙')
	@description = _('フロアの地図と現在地が映し出される不思議な紙')
	@price = 2
	@effect = MapVisionEffect.new
	@effect.messages << _("%{actor}は幻紙を広げた")
end



add ItemModel, :CompassOfSpell do
	@name = _('呪われた羅針盤')
	@description = _('現在位置と方角を示してくれる不思議な道具')
	@price = 90
	@instant = false
	@effect = CompassEffect.new
	@legendary = true
end

add ItemModel, :VoiceOfHarpy do
	@name = _('ハーピーの金切り笛')
	@description = _('なんとも形容しがたい不快な音を出す笛')
	@price = 160
	@instant = false
end




add ArrowModel, :WoodArrow do
	@name_id = Nn_('木の矢', '木の矢')
	@description = _('弓と組み合わせて使うための矢')
	@treasure_rank = 1
	@price = 0.2
	@damage_rate = 1.0
end

add ArrowModel, :IronArrow do
	@name_id = Nn_('鉄の矢', '鉄の矢')
	@description = _('鉄製の矢。木の矢と比べて格段に威力が高い')
	@treasure_rank = 3
	@price = 1
	@damage_rate = 1.2
end

=begin

add ArrowModel, :DarksteelArrow do
	@name_id = Nn_('黒鋼の矢', '黒鋼の矢')
	@price = 20
	@damage_rate = 2.0
end
=end



add ArrowModel, :SilverArrow do
	@name_id = Nn_('銀の矢', '銀の矢')
	@name = "銀の矢"
	@price = 2
	@damage_rate = 2.5
	@description = "実体のない亡霊にもダメージを与える事ができる矢"
end






add BoltModel, :Bolt do
	@name_id = Nn_('ボルト', 'ボルト')
	@description = _('クロスボウ等と組み合わせて使うための矢')
	@price = 2
	@damage_rate = 1.0
end

add KeyModel, :KeyOfGraveKeeper do
	@name = ('墓守の鍵')
	@description = _('墓守カロンから受け取った鍵')
end

add KeyModel, :KeyOfGeneral do
	@name = _('兵士長の鍵')
	@description = _('ロストアーマーが持っていた鍵')
	@legendary = true
end


add KeyModel, :KeyOfWizard do
	@name = _('魔道師の鍵')
	@legendary = true
end