require 'darkhall/model'

module DarkHall
	class SpellModel < Model
		attr_accessor :name, :short_name, :description, :trick_ids
		attr_accessor :constant_state, :constant_state_descriptions
		bool_attr_accessor :default
		attr_accessor :book_rank
		
		def init_params
			super
			@name = ''
			@short_name = ''
			@description = ''
			@trick_ids = []
			@constant_state = State.new
			@constant_state_descriptions = []
			@default = false
			@book_rank = nil
		end
		
		
		def tricks
			@tricks ||= @trick_ids.map{|x| TRICK_DATA[x]}
			return @tricks
		end
	end
	
	class SpellTrickModel < Model
		attr_accessor :name, :description, :mp_cost, :ct_cost, :target_type, :spell_id
		attr_accessor :effect, :boost_effect, :messages
		attr_accessor :increase_mastery, :boost_description
		
		
		
		def init_params
			super
			@name = ''
			@description = ''
			@mp_cost = 1
			@ct_cost = 20
			@effect = Effect.new
			@boost_effect = nil
			@messages = []
			@boost_description = "$[disablecolor]ブースト不可"
			
			
			@effect.messages = @messages
		end
		
		def town_usable?
			@effect.town_usable?
		end
		
		def camp_usable?
			@effect.camp_usable?
		end
		
		def battle_usable?
			@effect.battle_usable?
		end


		
		def boostable?
			(@boost_effect ? true : false)
		end
		
		def target_type
			@effect.target_type
		end

		
	end
end