module DarkHall
	
	
	class EnemyGraphic
		attr_reader :surface, :dark_surface, :book_surface, :surface_path, :width, :height
		attr_accessor :side_margin, :bottom_margin
	
		def initialize(surface_path, side_margin = -8, bottom_margin = 0)
			@surface_path = surface_path
			@surface = nil
			@dark_surface = nil

			@side_margin, @bottom_margin = side_margin, bottom_margin
			@width, @height = nil, nil
		end
		
		def load
			@surface = Res.load_enemy_surface(@surface_path)
			@surface.set_color_key(SDL::SRCCOLORKEY, @surface.get_pixel(0, 0))
			
			#@dark_surface = @surface.transform_surface(0, 0, 0.8, 0.8, SDL::Surface::TRANSFORM_AA)
			@dark_surface = @surface.display_format
			@dark_surface.put($dark_surface, 0, 0)
			@dark_surface.set_color_key(SDL::SRCCOLORKEY, @dark_surface.get_pixel(0, 0))
			
			
			@width = @surface.w
			@height = @surface.h
			
=begin
			if @width > 200 or @height > 200 then
				rate = [200.0 / @width, 200.0 / @height].min
				@book_surface = @surface.transform_surface(0, 0, rate, rate, SDL::Surface::TRANSFORM_AA)
				@book_surface.set_color_key(SDL::SRCCOLORKEY, @book_surface.get_pixel(0, 0))
				@book_surface.display_format
			end
=end			


			@surface.unlock
			@surface = @surface.display_format
			@dark_surface.unlock
			@dark_surface = @dark_surface.display_format

			
		end
	end
	
	class EnemyGraphicControl
		DIR_PATH = Pathname.new('./res/enemy')
		

		def initialize(graphics = {})
			@graphics = graphics
		end
		
		def get_file_path(key)
			DIR_PATH + "#{key.to_s}.png"
		end
		
		def load
			@graphics.each_pair do |symbol, graphic|
				graphic.load
			end
		end
		
	end
	
	ENEMY_GRAPHICS = {}
	ENEMY_GRAPHICS['SpiritHead'] = EnemyGraphic.new('sphands.png', -8, 56)
	ENEMY_GRAPHICS['SmallVine'] = EnemyGraphic.new('small_vine.png', -16, 0)
	ENEMY_GRAPHICS['Bandit'] = EnemyGraphic.new('bandit.png', -16, 8)
	ENEMY_GRAPHICS['Imp'] = EnemyGraphic.new('imp.png', -32, 40)
	ENEMY_GRAPHICS['StraySorcerer'] = EnemyGraphic.new('stray_sorcerer.png', -28, 0)
	ENEMY_GRAPHICS['Pixie'] = EnemyGraphic.new('pixie.png', -24, 50)
	ENEMY_GRAPHICS['KoboltWorker'] = EnemyGraphic.new('kobolt_worker.png', -16, 8)
	ENEMY_GRAPHICS['KoboltLeader'] = EnemyGraphic.new('kobolt_leader.png', -16, 8)
	ENEMY_GRAPHICS['RoofBird'] = EnemyGraphic.new('roof_bird2.png', -16, 100)
	ENEMY_GRAPHICS['Ghost'] = EnemyGraphic.new('ghost.png', -40, 8)
	ENEMY_GRAPHICS['RuinFeather'] = EnemyGraphic.new('ruin_feather.png', -16, -16)
	ENEMY_GRAPHICS['LostArmor'] = EnemyGraphic.new('lost_2.png', -16, -16)
	ENEMY_GRAPHICS['BladeSkelton'] = EnemyGraphic.new('skeleton_r.png', -32, 8)
	ENEMY_GRAPHICS['Slime'] = EnemyGraphic.new('slime.png', -16, 8)
	ENEMY_GRAPHICS['BlazingStorm'] = EnemyGraphic.new('moeibuki2.png', -16, 24)
	ENEMY_GRAPHICS['FreezingStorm'] = EnemyGraphic.new('iteibu3.png', -16, 24)
	ENEMY_GRAPHICS['StraySwordman'] = EnemyGraphic.new('swordman4.png', -64, 8)
	ENEMY_GRAPHICS['BranchedVine'] = EnemyGraphic.new('branchB.png', 0, 0)
	ENEMY_GRAPHICS['Zombie'] = EnemyGraphic.new('zombie.png', -48, 8)
	ENEMY_GRAPHICS['Rizardman'] = EnemyGraphic.new('slizard.png', -32, 8)
	ENEMY_GRAPHICS['FlyingFish'] = EnemyGraphic.new('fish03.png', -16, 8)
	ENEMY_GRAPHICS['FlyingShark'] = EnemyGraphic.new('fish01.png', -16, 40)
	ENEMY_GRAPHICS['WingFish'] = EnemyGraphic.new('fish02.png', -24, 40)
	ENEMY_GRAPHICS['KoboltKnight'] = EnemyGraphic.new('k_Knight.png', -8, 8)
	ENEMY_GRAPHICS['KoboltArcher'] = EnemyGraphic.new('k-archer.png', -8, 8)


	
	$enemy_graphic_control = EnemyGraphicControl.new(ENEMY_GRAPHICS)
	#$enemy_graphic_control.load
	
	
	#surface = ENEMY_GRAPHICS[:SmallVine].surface
	
	
	

end