
module DarkHall
	class TitlePhase < Phase
		include GetText
		Bar = Struct.new(:id, :name, :select_caption, :keycode)
		
		BARS = []
		BARS << Bar.new('n', _('北の酒場'), _('北の酒場(N)'), SDL::Key::N)
		BARS << Bar.new('e', _('東の酒場'), _('東の酒場(E)'), SDL::Key::E)
		BARS << Bar.new('s', _('南の酒場'), _('南の酒場(S)'), SDL::Key::S)
		BARS << Bar.new('w', _('西の酒場'), _('西の酒場(W)'), SDL::Key::W)
			
		
		
	
		def on_enter(from)
			super
			
=begin
			@title = TextWindow.new
			def @title.ttf
				@ttf ||= SDL::TTF.open('res/font/ume-tgc5.ttf', 30)
				@ttf.style = SDL::TTF::STYLE_BOLD
				
				@ttf
			end
			@title.has_frame = false
			@title.height = 100
			@title.align = AL_CENTER
			@title.make_surface('DarkHall').update.show
			
			
			@press = TextWindow.new
			@press.has_frame = false
			@press.align = AL_CENTER
			@press.make_surface('Press any key').update.show
			
			@c = TextWindow.new
			@c.has_frame = false
			@c.align = AL_CENTER
			@c.make_surface('(c) Team D.H. 2009').update.show
			
			@title.set_position(:center, 130)
			@press.set_position(:center, 300)
			@c.dock_beside(@press, :bottom).set_position(:center, nil)
			return
=end
			#BGM.stop
			
			title_window = Window.new
			title_window.make_surface(200, 160)
			title_window.has_frame = false
			title_window.set_position(440, 360)
			Game.put_title(title_window.front_surface, 0, 0)
			title_window.show

			
			@description = TextWindow.new
			@description.text = _('使用するセーブデータを選択してください')
			@description.set_good_width.make_surface.update.show
			@description.set_position(nil, 150)
			
			@title_name_window = TitleNameWindow.new
			@title_name_window.make_surface
			
			
			@main_window = MultiColumnWindow.new
			columns = @main_window.columns.clear
			columns << ColumnItem.new('', [], 80, AL_LEFT)
			columns << ColumnItem.new(s_('ColumnCaption|WEEK'), [], 60, AL_RIGHT, 8)
			columns << ColumnItem.new(s_('ColumnCaption|LAST SAVED'), [], 140, AL_CENTER)
			columns << ColumnItem.new('', [], 30, AL_CENTER, 0)
			
			@dir_path = SETTING.save_path
			
			
			update_saves
			index = @main_window.index
			@main_window.set_good_width.make_surface(nil, @main_window.select_items.size)
			@main_window.dock_beside(@description, :bottom)
			@main_window.set_position(:center, nil)
			@main_window.index = index
			
			


			@help = DoubleTextWindow.new
			@help.texts = [[_('数字キーの[1]'), _('操作方法を確認する')], ['[D]', _('選択データの削除')]]
			@help.set_good_width.make_surface(nil, 2).update.show
			@help.dock_beside(@main_window, :bottom_right)


			@description.left = @main_window.left
			
			$windows = [@description, @help, @title_name_window, @main_window]
			
			@main_window.warp
			

		end
		
		def update_saves
			saves = []
			items = @main_window.select_items.clear
			columns = @main_window.columns
			columns.each{|x| x.captions.clear}
			
			BARS.each do |bar|
				items << SelectItem.new(bar.id, bar.select_caption, bar.keycode)
				save = SaveData.new(@dir_path, bar.id)
				
				if save.exist? then
					models = save.load_mpac_models
					switch = Switch.create_from_mpac_model(models['switch'])
					columns[1].captions << models['week']
					columns[2].captions << save.mtime.strftime("%Y-%m-%d %H:%M")
					
					if models['rule'] then
						case models['rule']['_object_class']
						when 'DarkHall::ShortTimeRule'
							rule_letter = 'S'
						when 'DarkHall::HardRule'
							rule_letter = 'H'
						else
							rule_letter = ''
						end
					else
						rule_letter = ''
					end
					
					columns[3].captions << ((switch['BetaScenarioClear'] ? 'C' : '') + rule_letter)
					
					saves << save
				else
					columns[1].captions << ''
					columns[2].captions << ''
				end
			end

			unless saves.empty? then
				latest = saves.sort_by{|x| x.mtime}.last
				@main_window.set(latest.id)
			end

		end
		
		def on_select(id)
			$savedata = SaveData.new(@dir_path, id)
			if $savedata.exist? then
				msg = _("%{bar}で冒険を始めます。\nよろしいですか？")
			else
				msg = _("新しいセーブデータを作成します。\nよろしいですか？")
			end
			
			if Game.ask(msg.evaluate(:bar => BARS.find{|x| x.id == id}.name)) then
				if $savedata.exist? then
					Game.working(_('ロード中...')){
						$savedata.load
					}
				else
					$windows.clear
					
					selected_rule = nil
					if Game.debug_mode and Input.ctrl_pressed? then
						Phase.change(RuleSelectPhase.new)
						selected_rule = Game.operation_loop
					end
				
					msg = _("自動で作成される6人のキャラクターを使いますか？\n（使わない場合、自分でキャラクターを作成する必要があります）")
					re = Game.ask(msg, :silent => true)
					SE.select
					GS.ready
					GS.rule = selected_rule if selected_rule
					
					if re then
						classes = [Fighter, HeavyFighter, HeavyFighter, Archer, Magician, Explorer]
						classes.each do |cls|
							age = Util.random_pick([:Young, :Young, :Young, :Elder, :Child])
							Game.add_default_member(cls, 1, age)
						end
					end
					GS.check_oneself
					Game.reporter = Reporter.new("./report/#{id}/")
					Game.reporter.check_dir
					Game.save
					Game.message(_("セーブデータを作成しました。冒険を始めます"))
				end
				Game.reload_ttf
				
				# セーブ時のパーティーが迷宮にいる場合、新しいパーティーを作って街から再開
				if GS.party.in_dungeon? then
					GS.change_to_new_party
				end
				
				Phase.change(TownMenuPhase.new)
			else
				@main_window.warp
			end
		end
		
		def on_key_press(keycode)
			if Game.current_window == @main_window then
				case keycode
				when SDL::Key::M
					raise('Sample Exception.')
				when SDL::Key::D
					bar = BARS.find{|x| x.id == @main_window.current_id}
					save = SaveData.new(@dir_path, bar.id)
					if save.exist? then
						SE.select
						
						if Game.ask(_("セーブデータを削除します。\n$c[bad]（一度削除したセーブデータは元に戻せません）$c\n\n本当によろしいですか？"), :default => :no) then
							save.file_path.delete
							update_saves
							@main_window.update
						end
					else
						SE.cancel
					end
				when SDL::Key::K1
					SE.select
					
=begin
					
					win = MultiColumnWindow.new
					win.columns << ColumnItem.new('', [_('決定'), _('キャンセル')], 90)
					win.columns << ColumnItem.new('KEYBOARD', ['[Z][Enter][Space]', '[X][Esc][Backspace]'], 150)
					win.columns << ColumnItem.new('MOUSE', [_('左クリック'), _('右クリック')], 90)
					win.columns << ColumnItem.new('GAME PAD', [_('ボタン1'), _('ボタン2')], 60)
	
					win.set_good_width
					win.make_surface(nil, 2).update
					win.centering_on_screen
=end

				
					old = $windows
					$windows = []
					
					@title_name_window.show
					
					title = TextWindow.new
					title.align = AL_CENTER
					title.has_frame = false
					title.text = _('- 基本操作 -')
					title.make_surface(SCREEN_WIDTH - 8*2).update
					title.set_position(:center, 16).show
					
					win1 = TextWindow.new.make_surface(_('キーボード'), 1, AL_CENTER)
					win1.update.dock_beside(title, :bottom, 16).show
					win1.left += 32
					win2 = DoubleTextWindow.new
					win2.has_frame = false
					texts = []
					texts << [_('決定:'), _('[Z][Enter][Space]')]
					texts << [_('キャンセル:'), _('[X][Esc][Backspace]')]
					win2.texts = texts
					win2.set_good_width.make_surface(240, 2).update
					win2.dock_beside(win1, :bottom).show
					
					win3 = TextWindow.new.make_surface(_('マウス'), 1, AL_CENTER)
					win3.update.dock_beside(win2, :bottom, 32).show
					win4 = DoubleTextWindow.new
					win4.has_frame = false
					texts = []
					texts << [_('決定:'), _('左クリック')]
					texts << [_('キャンセル:'), _('右クリック')]
					win4.texts = texts
					win4.set_good_width.make_surface(240, 2).update
					win4.dock_beside(win3, :bottom).show
					
					win5 = TextWindow.new.make_surface(_('ゲームパッド'), 1, AL_CENTER)
					win5.update.dock_beside(win4, :bottom, 32).show
					win6 = DoubleTextWindow.new
					win6.has_frame = false
					texts = []
					texts << [_('決定:'), _('ボタン1')]
					texts << [_('キャンセル:'), _('ボタン2')]
					win6.texts = texts
					win6.set_good_width.make_surface(240, 2).update
					win6.dock_beside(win5, :bottom).show
					
					win2.left += 16
					win4.left += 16
					win6.left += 16
					
					win7 = TextWindow.new.make_surface(400, 4)
					win7.has_frame = false
					win7.word_wrap_length = 20
					win7.update(_("・ゲームパッドのボタン配置は\n　あとから変更可能"))
					win7.dock_beside(win1, :right)
					win7.left = win2.right + 64
					win7.show


					
					help = TemporaryTextWindow.new
					help.make_surface(_('決定キーで閉じる'), 1, AL_CENTER).update
					help.dock_beside(win6, :bottom, 32).set_position(:center, nil).show
	
					
					
					Game.operation_loop
					$windows = old
					
				end
			end
		end
		
	end
	
	class RuleSelectPhase < Phase
		def on_enter(from)
			@main_window = SelectableWindow.new
			items = @main_window.select_items
			items << SelectItem.new(:NormalRule, 'ノーマル（標準）')
			items << SelectItem.new(:ShortTimeRule, 'ショートタイム（進行が早い）')
			items << SelectItem.new(:HardRule, 'ハード（難しい）')
			#items << SelectItem.new(:SurvivalRule, 'サバイバル')
			#items << SelectItem.new(:DeepRule, 'ディープ')
			#items << SelectItem.new(:SorcererOnlyRule, 'ソーサラーオンリー')
			#items << SelectItem.new(:custom, '自分でルールを設定する')
			items << SelectItem.new(:cancel, '前の画面に戻る')
			
			@main_window.set_good_width.make_surface(nil, items.size).update
			
			@feature_window = DoubleTextWindow.new
			@feature_window.make_surface(300, 10)
			
			@feature_window.centering_on_screen
			@main_window.top = @feature_window.top
			Window.centering_x([@main_window, @feature_window])
			
			DESCRIPTION_WINDOW.update('ルールを選択してください').set_position(8, 8)
			@main_window.warp
			
			on_change
			
			$windows = [DESCRIPTION_WINDOW, @feature_window, @main_window]
		end
		
		def on_change
			texts = []
			case @main_window.current_id
			when :ShortTimeRule
				texts << ['敵から得られる経験値1.5倍', nil]
				texts << ['敵から得られる金品2倍', nil]
				texts << ['商店でマップ表示アイテムを購入可能', nil]
			when :HardRule
				texts << ['敵から得られる金品1/2', nil]
				texts << ['通常敵の能力値+4', nil]
				texts << ['ボスの能力値+8', nil]
				texts << ['宝箱の罠が強化', nil]
			end
			@feature_window.update(texts)
		end
		
		def on_select(id)
			case id
			when :cancel
				on_cancel
			else
				rule = DarkHall.const_get(id).new
				throw(:exit_operation_loop, rule)
			end
		end
		
		def on_cancel
			throw(:exit_operation_loop, nil)
		end
		
	end
	
	
	
	

	
	
	
	
	

	
end
