module DarkHall
	
	
	class << Game
		bool_attr_reader :inited_global_variables, :inited_data
		
		def init_global_variables_and_data
			init_global_variables
			init_data
		end

		def init_global_variables
			$troop = Troop.new
			$round = 0
			$member_index = 0
			
			$windows = []
			$selectable_windows = []
			$enemy_windows = []
			$operation_loop_stack = []
			
			$cursor_alpha = 255
			$cursor_alpha_increasing = false

			GS.clear

			@inited_global_variables = true
		end

		def init_data
			Game.timelog('Data Loading'){
				Dungeon.load_floors
				DB.load
	
				TREASURE_TABLE.setup
				init_shop_lineup
	
				Game.set_room_events
				Game.set_merchant_products
			}
			
			@inited_data = true
			
		end
		
		
		def init_shop_lineup
			Game.timelog("item sample set"){
				ITEM_SAMPLES.clear
				ITEM_DATA.each_pair do |str_id, model|
					case model
					when WeaponModel
						cls = Weapon
					when ArmorModel
						cls = Armor
					when AccessoryModel
						cls = Accessory
					when BundleItemModel
						cls = BundleItem
					else
						cls = Item
					end
				
				
					ITEM_SAMPLES[str_id] = cls.new(str_id)
				end
				
				ITEM_SAMPLES['WoodArrow5'] = BundleItem.new('WoodArrow', 5)
				ITEM_SAMPLES['WoodArrow30'] = BundleItem.new('WoodArrow', 30)
				ITEM_SAMPLES['IronArrow5'] = BundleItem.new('IronArrow', 5)
				ITEM_SAMPLES['IronArrow30'] = BundleItem.new('IronArrow', 30)
				ITEM_SAMPLES['PoisonArrow5'] = BundleItem.new('PoisonArrow', 5)
				#ITEM_SAMPLES['Bolt5'] = BundleItem.new('Bolt', 5)
				#ITEM_SAMPLES['Bolt30'] = BundleItem.new('Bolt', 30)
				
				# 店の標準品揃え
				COMMON_LINEUP.clear
				COMMON_LINEUP[PD_WEAPON] = [:NoviceSword, :Cutlass, :LongSword, :HandAxe, :NoviceSpear, :LongSpear,
				                            :NoviceBow, :LongBow, :NoviceClub, :BoneClub, :MagicianWand].map{|x| x.to_s}
				COMMON_LINEUP[PD_WEAPON].sort!{|a, b| ITEM_SAMPLES[a].price <=> ITEM_SAMPLES[b].price}
				COMMON_LINEUP[PD_WEAPON] += [:WoodArrow5, :WoodArrow30, :IronArrow5, :IronArrow30, :PoisonArrow5].map{|x| x.to_s}
																		
				COMMON_LINEUP[PD_ARMOR] = [:NoviceArmor, :LeatherArmor].map{|x| x.to_s}
				COMMON_LINEUP[PD_ARMOR] += [:NoviceGuard, :LeatherBuckler, :LargeShield, :ElderGauntlet].map{|x| x.to_s}
		
				COMMON_LINEUP[PD_GOODS] = [:Bandage, :PurifyingWater, :WhiteIncense, :BlackIncense].map{|x| x.to_s}
				
				COMMON_LINEUP[PD_ACCESSORY] = [:NoviceCloak, :FeatherCloak].map{|x| x.to_s}
				COMMON_LINEUP[PD_ACCESSORY] += [:ChipOfFlame, :ChipOfThunder, :ChipOfWind, :ChipOfWater, :ChipOfDarkness].map{|x| x.to_s}
				
				COMMON_LINEUP[PD_DEBUG] = DB.items.find_all{|x| not x.kind_of?(BundleItemModel)}.map{|x| x.id}
																	 
			}
			
			COMMON_LINEUP.each_value do |list|
				list.each do |id|
					raise "item definition not found :#{id}" unless ITEM_SAMPLES[id]
				end
			end

		end
		
		
		def put_loading_texts(texts)
			# 画面初期化
			$screen.fill_rect(0, 0, $screen.w, $screen.h, [ 0, 0, 0 ])
	
			cy = 16
			texts.each do |text|
				Game.regular_ttf.draw_blended_utf8($screen, text, 16, cy, 255, 255, 255)
				cy += (Game.regular_ttf.line_skip + 4)
			end
			put_title
	
			$screen.flip
		end

		
	end
end
