# INI File Parser
#
# Version: 0.2
# License: Public Domain
# Author: Dice <tetradice@gmail.com> 

module Ini
	def self.parse(text, filename = self.to_s)
		re = {}
		current_section = nil
		
		text.each_with_index do |line, index|
			case line.chomp
			when /^\;/, /^\s*$/
				# skip (primary)
			when /^\[(.+)\]/
				current_section = $1
				if re[current_section] then
					self.warn(filename, index+1, "section '#{$1}' overlap")
				else
					re[current_section] = {}
				end
				
			when /^(.+?)\s*=\s*(.*)$/
				if current_section then
					if re[current_section][$1] then
						self.warn(filename, index+1, "key '#{$1}' overlap")
					end
					
					re[current_section][$1] = $2
				else
					self.warn(filename, index+1, "'#{$1}' is not in section")
				end
			else
				self.warn(filename, index+1, "warning: unknown statement")
			end
		end
		
		re
	end
	
	def self.parse_file(path)
		self.parse(File.read(path), path.to_s)
	end
	
	def self.warn(filename, lineno, msg)
		if $VERBOSE or $DEBUG then
			$stderr.puts "#{filename}:#{lineno}: warning: #{msg}"
		end
	end
	
	def self.build(ini_hash)
		re = ""
		
		ini_hash.each_pair do |sect_name, sect|
			re << "[#{sect_name}]\n"
			sect.each_pair do |key, value|
				re << "#{key} = #{value}\n"
			end
			re << "\n"
		end
		
		re
	end
	
	def self.dump(ini_hash)
		build(ini_hash)
	end
end


INI = Ini