/*
 * Decompiled with CFR 0.152.
 */
package daruma.server;

import daruma.sql.DatabaseConnectionException;
import daruma.sql.MySQLDatabaseConnectionFactory;
import daruma.storage_manager.DBMSStorageManager;
import daruma.util.EncodingConversionOutputStream;
import daruma.util.FatalException;
import daruma.util.Itk;
import daruma.util.LogWriter;
import daruma.util.TeeInputStream;
import daruma.util.TeeOutputStream;
import daruma.wfs.SOAPWFSProcessor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class ConnectionHandler
implements Runnable {
    private static Object lock = new Object();
    private InputStream inputStream;
    private OutputStream outputStream;
    private DBMSStorageManager storage;
    private String debugTag;
    private boolean debug = false;
    private boolean ioLog = false;
    private File ioLogDirectory = null;
    private boolean compressStreamByGzip = false;
    private long connectionID = -1L;
    private static Boolean cEncodingWarned = false;

    public ConnectionHandler(InputStream in, OutputStream out, String databaseName, String user, String passwd, String debugTag, boolean debug, boolean ioLog, File ioLogDirectory, long connectionID) throws DatabaseConnectionException {
        this.inputStream = in;
        this.outputStream = out;
        this.debugTag = debugTag;
        this.debug = debug;
        this.ioLog = ioLog;
        this.ioLogDirectory = ioLogDirectory;
        this.connectionID = connectionID;
        this.storage = new DBMSStorageManager(new MySQLDatabaseConnectionFactory().create());
        this.storage.connect(databaseName, user, passwd);
    }

    public void setCompressStreamByGzip(boolean flag) {
        this.compressStreamByGzip = flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object = lock;
        synchronized (object) {
            try {
                LogWriter.qwrite("INFO", "[" + Itk.getCurrentTimeStr() + "] ", "Open  :", this.debugTag);
                this.runImplement();
            }
            catch (Throwable throwable) {
                LogWriter.qwrite("INFO", "[" + Itk.getCurrentTimeStr() + "] ", "Close :", this.debugTag);
                throw throwable;
            }
            LogWriter.qwrite("INFO", "[" + Itk.getCurrentTimeStr() + "] ", "Close :", this.debugTag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runImplement() {
        try {
            InputStream in = this.inputStream;
            OutputStream out = this.get_ostream(this.outputStream);
            if (this.compressStreamByGzip) {
                in = new GZIPInputStream(in);
                out = new GZIPOutputStream(out);
            }
            if (this.debug) {
                in = new TeeInputStream(in, System.out, false);
                out = new TeeOutputStream(out, System.out, false);
            }
            if (this.ioLog) {
                String fileNameBase = "log-" + this.connectionID;
                FileOutputStream inputLogFile = new FileOutputStream(new File(this.ioLogDirectory, fileNameBase + "-from-client"));
                FileOutputStream outputLogFile = new FileOutputStream(new File(this.ioLogDirectory, fileNameBase + "-to-client"));
                in = new TeeInputStream(in, inputLogFile, false);
                out = new TeeOutputStream(out, outputLogFile, false);
            }
            SOAPWFSProcessor p = new SOAPWFSProcessor();
            p.setDebugTag(this.debugTag);
            p.process(in, out, this.storage);
            this.storage.close();
            out.flush();
            out.close();
            in.close();
            this.inputStream.close();
            this.outputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (DatabaseConnectionException dce) {
            dce.printStackTrace();
        }
        catch (FatalException e) {
            e.printStackTrace();
        }
        finally {
            try {
                this.inputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                this.outputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private OutputStream get_ostream(OutputStream raw) {
        OutputStream enc;
        String encoding = System.getProperty("file.encoding");
        if (!encoding.equalsIgnoreCase("utf-8") && !encoding.equalsIgnoreCase("utf8")) {
            if (!cEncodingWarned.booleanValue()) {
                LogWriter.qwrite("WARN", "I/O encoding is not UTF-8. Applies trivial encoding conversion.");
                cEncodingWarned = true;
            }
            try {
                enc = new EncodingConversionOutputStream(raw, "utf-8");
            }
            catch (UnsupportedEncodingException uee) {
                LogWriter.qwrite("FATAL", "Encoding name error. Message: ", uee.getMessage());
                Object enc2 = null;
                throw new RuntimeException();
            }
        } else {
            enc = raw;
        }
        return enc;
    }
}

