/*
 * Decompiled with CFR 0.152.
 */
package daruma.server;

import daruma.server.ConnectionHandler;
import daruma.sql.DatabaseConnectionException;
import daruma.util.LogWriter;
import daruma.util.ParseException;
import daruma.util.PropertyReader;
import daruma.wfs.SOAPFaultDocumentBuilder;
import daruma.xml.URI;
import daruma.xml.util.XMLFormatConverter;
import daruma.xml.util.XPointerUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DarumaServlet
extends HttpServlet {
    private static final long serialVersionUID = 0L;
    private long connectionID = 0L;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        TreeMap<String, String> namespaceMap;
        String namespaceParam;
        response.setContentType("text/xml; charset=UTF-8");
        String service = request.getParameter("SERVICE");
        String version = request.getParameter("VERSION");
        String req = request.getParameter("REQUEST");
        String ns = request.getParameter("NAMESPACE");
        if (service == null) {
            this.returnError("no SERVICE parameter found. add SERVICE parameter.\n format: SERVICE=WFS", response);
            return;
        }
        if (!service.equals("WFS") && !service.equals("MISP")) {
            this.returnError("SERVICE type [" + service + "] unsupported", response);
            return;
        }
        if (version == null) {
            if (req == null || !req.equals("GetCapabilities")) {
                this.returnError("no VERSION parameter found. add VERSION parameter.\n format: VERSION=1.1.0", response);
                return;
            }
        } else if (!version.equals("1.1.0")) {
            this.returnError("VERSION [" + version + "] not supported," + " use VERSION=1.1.0", response);
            return;
        }
        if ((namespaceParam = request.getParameter("NAMESPACE")) == null) {
            namespaceMap = new TreeMap();
        } else {
            try {
                namespaceMap = XPointerUtil.parseXmlnsString(namespaceParam);
            }
            catch (ParseException e) {
                throw new IOException(e.getMessage());
            }
        }
        if (req == null) {
            this.returnError("no REQUEST found. add REQUEST parameter.", response);
            return;
        }
        String reqStr = null;
        try {
            if (req.equals("GetCapabilities")) {
                reqStr = "<misp:GetCapabilities xmlns:misp=\"http://www.infosharp.org/misp\"/>";
            } else if (req.equals("DescribeFeatureType")) {
                reqStr = this.getDescribeFeatureTypeRequest(request, namespaceMap);
            } else {
                if (req.equals("Transaction") || req.equals("GetFeature") || req.equals("RegisterFeatureType") || req.equals("RegisterCoordinateSystemTransformation")) {
                    this.returnError("REQUEST [" + req + "] by http GET method" + " not supported yet." + " Use http POST instead.", response);
                    return;
                }
                this.returnError("bad REQUEST [" + req + "]", response);
                return;
            }
            System.err.println(reqStr);
            this.handleConnection(new ByteArrayInputStream(reqStr.getBytes()), (OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            this.returnError(e.getMessage(), response);
            return;
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("text/xml; charset=UTF-8");
        this.handleConnection((InputStream)request.getInputStream(), (OutputStream)response.getOutputStream());
    }

    private void handleConnection(InputStream in, OutputStream out) throws IOException {
        ConnectionHandler c;
        PropertyReader.initialize(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(PropertyReader.getDefaultPropertyFile()));
        LogWriter.initialize(((Object)((Object)this)).getClass().getClassLoader().getResource(PropertyReader.getDefaultPropertyFile()));
        try {
            c = new ConnectionHandler(in, out, PropertyReader.getProperty("daruma.db.name"), PropertyReader.getProperty("daruma.db.uid"), PropertyReader.getProperty("daruma.db.pass"), "servlet", true, false, null, this.connectionID);
            ++this.connectionID;
        }
        catch (DatabaseConnectionException e) {
            throw new IOException(e.getMessage());
        }
        c.run();
    }

    private void returnError(String errorMessage, HttpServletResponse response) throws IOException {
        try {
            XMLFormatConverter.print(new SOAPFaultDocumentBuilder(errorMessage).newDocument(), (OutputStream)response.getOutputStream());
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }

    private String getDescribeFeatureTypeRequest(HttpServletRequest request, Map<String, String> namespaceMap) throws IOException {
        String typeNameParam = request.getParameter("TYPENAME");
        String namespaceParam = request.getParameter("NAMESPACE");
        if (typeNameParam == null) {
            throw new IOException("no TYPENAME parameter found. add TYPENAME parameter.");
        }
        StringBuilder buf = new StringBuilder();
        buf.append("<misp:DescribeFeatureType xmlns:misp=\"" + URI.MISP + "\"");
        for (Map.Entry<String, String> e : namespaceMap.entrySet()) {
            buf.append(" ");
            if (e.getKey() == null) {
                buf.append("xmlns=\"");
                buf.append(e.getValue());
                buf.append("\"");
                continue;
            }
            buf.append("xmlns:");
            buf.append(e.getKey());
            buf.append("=\"");
            buf.append(e.getValue());
            buf.append("\"");
        }
        buf.append(">\n");
        buf.append(" ");
        buf.append("<misp:TypeName>");
        buf.append(typeNameParam);
        buf.append("</misp:TypeName>");
        buf.append("</misp:DescribeFeatureType>");
        return buf.toString();
    }
}

