/*
 * Decompiled with CFR 0.152.
 */
package daruma.wfs;

import daruma.geometry.CoordinateSystem;
import daruma.geometry.DrmEnvelope;
import daruma.geometry.TransformationContext;
import daruma.storage_manager.StorageException;
import daruma.storage_manager.StorageManager;
import daruma.storage_manager.type_definition.ElementName;
import daruma.storage_manager.type_definition.NoNeedToConvertTypeException;
import daruma.storage_manager.type_definition.TypeDefinition;
import daruma.storage_manager.type_definition.TypeException;
import daruma.storage_manager.type_definition.TypeName;
import daruma.storage_manager.type_definition.TypedInstance;
import daruma.storage_manager.type_definition.TypedInstanceSet;
import daruma.util.LogWriter;
import daruma.wfs.ResponseInfo;
import daruma.wfs.SOAPFaultDocumentBuilder;
import daruma.wfs.filter.FilterHandler;
import daruma.wfs.filter.PropertyPathConverter;
import daruma.xml.Lexicon;
import daruma.xml.NameSpace;
import daruma.xml.SAXExceptionObserver;
import daruma.xml.handler.XSAXDOMCreateHandler;
import daruma.xml.util.ElementUtil;
import daruma.xml.util.XMLFormatConverter;
import daruma.xml.util.XMLParseErrorException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Date;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class GetFeatureHandler
extends XSAXDOMCreateHandler
implements SAXExceptionObserver {
    private StorageManager storage;
    private Date startTime;
    private Date endTime;
    private ElementName specifiedElement;
    private TypeDefinition specifiedElementType;
    private TransformationContext transformationContext;
    private boolean filterTagFound;
    private boolean queryTagFound;
    private long tagCount;
    private String queryMode;
    private String propertyColName;
    private long limitCount;
    private FilterHandler filter = null;

    public GetFeatureHandler(OutputStream out, XMLReader parser, boolean isTopLevelHandler, StorageManager storage) {
        super(out, parser, isTopLevelHandler);
        this.storage = storage;
        this.startTime = null;
        this.endTime = null;
        this.specifiedElement = null;
        this.specifiedElementType = null;
        this.transformationContext = null;
        this.queryTagFound = false;
        this.filterTagFound = false;
        this.tagCount = 0L;
        this.queryMode = Lexicon.MispAttrQueryMode_Features.localname;
        this.propertyColName = null;
        this.limitCount = -1L;
    }

    public void xStartElementWrapper(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        super.xStartElement(uri, localName, qName, attrs);
    }

    public void xCharacters(char[] str, int offset, int length) throws SAXException {
        super.xCharacters(str, offset, length);
    }

    public void xStartElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        this.xStartElementWrapper(uri, localName, qName, attrs);
        assert (super.getCurrentLevel() == 1 || super.getCurrentLevel() == 2 || super.getCurrentLevel() == 3);
        ++this.tagCount;
        if (super.getCurrentLevel() == 1) {
            try {
                Lexicon.MispGetFeature.matchesOrSaxException(this.getCurrentNode(), super.getLocator(), "GetFeature");
            }
            catch (SAXParseException ex) {
                this.throwError(ex);
            }
            try {
                this.startTime = this.storage.getCurrentTime();
            }
            catch (StorageException e) {
                this.throwError(new SAXParseException(e.getMessage(), super.getLocator(), e));
            }
            return;
        }
        if (super.getCurrentLevel() == 2) {
            String limitStr;
            try {
                Lexicon.MispQuery.matchesOrSaxException(this.getCurrentNode(), super.getLocator(), "GetFeature/Query");
            }
            catch (SAXParseException ex) {
                this.throwError(ex);
            }
            this.queryTagFound = true;
            String typeNameString = attrs.getValue("", Lexicon.MispAttrTypeName.localname);
            if (typeNameString == null) {
                this.throwError(new SAXParseException("typeName attribute not found in " + localName + " tag.", super.getLocator()));
            }
            this.transformationContext = new TransformationContext(TransformationContext.TransformationType.Conv, new CoordinateSystem(attrs.getValue("", "srsName")));
            String transformType = attrs.getValue("", "transformType");
            if (transformType == null || transformType.equals("conv")) {
                this.transformationContext.setTransformationType(TransformationContext.TransformationType.Conv);
            } else if (transformType.equals("selective")) {
                this.transformationContext.setTransformationType(TransformationContext.TransformationType.Selective);
            } else if (transformType.equals("noconv")) {
                this.transformationContext.setTransformationType(TransformationContext.TransformationType.NoConv);
            } else {
                this.throwError(new SAXParseException("invalid transformType, expected was one of [selective|conv|noconv]", super.getLocator()));
            }
            try {
                this.transformationContext.setCoordTransDictionary(this.storage.getCoordTransDictionary());
            }
            catch (StorageException e) {
                this.throwError(new SAXParseException(e.getMessage(), super.getLocator()));
            }
            try {
                this.specifiedElement = new ElementName(super.convertQNameStringToUniversalName(typeNameString));
            }
            catch (SAXException e) {
                this.throwError(new SAXParseException(e.getMessage(), super.getLocator()));
            }
            String modeStr = attrs.getValue(Lexicon.MispAttrQueryMode.localname);
            if (modeStr != null) {
                if (modeStr.equals(Lexicon.MispAttrQueryMode_Features.localname)) {
                    this.queryMode = modeStr;
                } else if (modeStr.equals(Lexicon.MispAttrQueryMode_Count.localname)) {
                    this.queryMode = modeStr;
                } else if (modeStr.equals(Lexicon.MispAttrQueryMode_BoundedBy.localname)) {
                    this.queryMode = modeStr;
                    this.propertyColName = this.getPropertyColNameForBoundedByMode(attrs);
                } else {
                    this.throwError(new SAXParseException("unknown mode for GetFeature Query:" + modeStr, super.getLocator()));
                }
            }
            if ((limitStr = attrs.getValue(Lexicon.MispAttrQueryLimit.localname)) != null) {
                try {
                    this.limitCount = Long.valueOf(limitStr);
                }
                catch (NumberFormatException ex) {
                    this.throwError(new SAXParseException("Illegal limit specification:" + limitStr + "." + " This should be a integer string.", super.getLocator()));
                }
            }
            TypeName elementTypeName = null;
            try {
                elementTypeName = this.storage.getElementTypeName(this.specifiedElement);
            }
            catch (StorageException e) {
                this.throwError(new SAXParseException(e.getMessage(), super.getLocator(), e));
            }
            if (elementTypeName == null) {
                this.throwError(new SAXParseException("element " + this.specifiedElement.getLocalName() + " in namespace " + this.specifiedElement.getNamespace() + " not registered", super.getLocator()));
            }
            try {
                this.specifiedElementType = this.storage.getTypeDefinition(elementTypeName);
                if (this.specifiedElementType == null) {
                    throw new StorageException("");
                }
            }
            catch (StorageException e) {
                this.throwError(new SAXParseException("type of element " + this.specifiedElement.getLocalName() + " in namespace " + this.specifiedElement.getNamespace() + " not registered", super.getLocator()));
            }
            return;
        }
        if (super.getCurrentLevel() == 3) {
            try {
                Lexicon.MispFilter.matchesOrSaxException(this.getCurrentNode(), super.getLocator(), "in GetFeature/Query");
            }
            catch (SAXParseException ex) {
                this.throwError(ex);
            }
            this.filterTagFound = true;
            this.filter = new FilterHandler(super.getOutputStream(), super.getParser(), false, this.specifiedElementType, this.transformationContext, this.storage, this);
            super.setContentHandlerDelegator(this.filter, uri, localName, qName, attrs);
            return;
        }
    }

    public void xEndDocument() throws SAXException {
        if (!this.filterTagFound) {
            this.throwError(new SAXParseException("Filter tag not found", super.getLocator()));
        }
        if (!this.queryTagFound) {
            this.throwError(new SAXParseException("Query tag not found", super.getLocator()));
        }
        if (this.specifiedElement == null) {
            this.throwError(new SAXParseException("element not specified", super.getLocator()));
        }
        if (this.tagCount < 3L) {
            this.throwError(new SAXParseException("too few tags found", super.getLocator()));
        }
        if (this.tagCount > 3L) {
            this.throwError(new SAXParseException("too many tags found", super.getLocator()));
        }
        try {
            this.endTime = this.storage.getCurrentTime();
        }
        catch (StorageException e) {
            this.throwError(new SAXParseException(e.getMessage(), super.getLocator(), e));
        }
        this.outputResult();
    }

    private String getPropertyColNameForBoundedByMode(Attributes attrs) throws SAXException {
        String propName = attrs.getValue(Lexicon.MispAttrQueryProp.localname);
        if (propName == null) {
            this.throwError(new SAXParseException("a property name for " + this.queryMode + " should be specified.", super.getLocator()));
        }
        String colName = null;
        try {
            colName = PropertyPathConverter.convertPropertyPathToShortXPath(propName, this.getCurrentNode(), this.storage);
        }
        catch (XMLParseErrorException ex) {
            this.throwError(new SAXParseException("a property name for " + this.queryMode + " should be specified.", super.getLocator(), ex));
        }
        return colName;
    }

    public void outputResult() throws SAXException {
        if (this.queryMode.equals(Lexicon.MispAttrQueryMode_Features.localname)) {
            this.outputResultFeatures();
        } else if (this.queryMode.equals(Lexicon.MispAttrQueryMode_Count.localname)) {
            this.constructResultCount();
        } else if (this.queryMode.equals(Lexicon.MispAttrQueryMode_BoundedBy.localname)) {
            this.constructResultBoundedBy();
        } else {
            throw new SAXException("unknown query mode:" + this.queryMode);
        }
    }

    public void outputResultFeatures() throws SAXException {
        PrintWriter out = super.getPrintWriter();
        this.constructResponseInfo(true);
        this.getResponse().outputHeaderPart(out);
        try {
            this.getOutputStream().flush();
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
        TypedInstanceSet objectSet = null;
        try {
            try {
                objectSet = this.storage.getTypedInstanceSet(this.specifiedElement, this.filter.getSQLExpression(), this.transformationContext, this.limitCount);
            }
            catch (StorageException e) {
                SAXParseException se = new SAXParseException("Can't retrieve objects: " + e.getMessage(), super.getLocator(), e);
                se.setStackTrace(e.getStackTrace());
                this.throwError(se);
            }
            TypedInstance obj = null;
            while ((obj = objectSet.getNextTypedInstance()) != null) {
                Node objElement;
                try {
                    objElement = obj.convertToXMLElement(this.specifiedElement, this.storage, this.transformationContext);
                }
                catch (NoNeedToConvertTypeException e) {
                    LogWriter.qwrite("DEBUG", "skip: ", e.getMessage());
                    continue;
                }
                out.println("    <gml:featureMember>");
                out.flush();
                this.getOutputStream().flush();
                try {
                    XMLFormatConverter.printElement(objElement, this.getOutputStream());
                }
                catch (TransformerException te) {
                    this.throwError(new SAXParseException(te.getMessage(), super.getLocator(), te));
                }
                out.println("    </gml:featureMember>");
                out.flush();
                this.getOutputStream().flush();
            }
        }
        catch (TypeException e) {
            this.throwError(new SAXParseException(e.getMessage(), super.getLocator(), e));
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
        finally {
            try {
                if (objectSet != null) {
                    objectSet.close();
                }
            }
            catch (TypeException e) {
                this.throwError(new SAXParseException(e.getMessage(), super.getLocator(), e));
            }
        }
    }

    public void constructResultCount() throws SAXException {
        try {
            this.constructResponseInfo(false);
            long count = this.storage.getCountOfTypedInstanceSet(this.specifiedElement, this.filter.getSQLExpression(), this.limitCount);
            ResponseInfo responseInfo = this.getResponse();
            ElementUtil.genElementSimple(Lexicon.MispFeatureCount, Long.toString(count), responseInfo.document, responseInfo.leaf, true);
        }
        catch (StorageException ex) {
            this.throwError(new SAXParseException("Can't retrieve objects " + ex.getMessage(), super.getLocator(), ex));
        }
    }

    public void constructResultBoundedBy() throws SAXException {
        try {
            this.constructResponseInfo(false);
            DrmEnvelope env = this.storage.getEnvelopeOfTypedInstanceSet(this.specifiedElement, this.propertyColName, this.filter.getSQLExpression(), this.limitCount);
            ResponseInfo responseInfo = this.getResponse();
            Element boundedBy = ElementUtil.genElementSimple(Lexicon.MispBoundedBy, null, responseInfo.document, responseInfo.leaf, true);
            if (env == null) {
                ElementUtil.genElementSimple(Lexicon.GmlNull, Lexicon.GmlNull_Inapplicable.localname, responseInfo.document, boundedBy, true);
            } else {
                Element envElm = ElementUtil.genElementSimple(Lexicon.GmlEnvelope, null, responseInfo.document, boundedBy, true);
                String coord = Double.toString(env.getPointNE().getX()) + "," + Double.toString(env.getPointNE().getY()) + " " + Double.toString(env.getPointSW().getX()) + "," + Double.toString(env.getPointSW().getY());
                ElementUtil.genElementSimple(Lexicon.GmlCoordinates, coord, responseInfo.document, envElm, true);
            }
        }
        catch (StorageException ex) {
            this.throwError(new SAXParseException("Can't retrieve objects " + ex.getMessage(), super.getLocator(), ex));
        }
    }

    private void constructResponseInfo(boolean addCollectionP) throws SAXException {
        try {
            ResponseInfo responseInfo = this.getResponse();
            Element response = ElementUtil.genElementSimple(Lexicon.MispGetFeatureResponse, null, responseInfo.document, responseInfo.leaf, true);
            responseInfo.setResponseToLeaf(response);
            NameSpace.GML.addNsDeclToIfNeeded(response);
            responseInfo.addResponseStatusToLeaf(this.storage.getMostRecentTransactionURI(), this.startTime, this.endTime);
            if (addCollectionP) {
                Element collection = ElementUtil.genElementSimple(Lexicon.MispFeatureCollection, null, responseInfo.document, response, true);
                responseInfo.setResponseToLeaf(collection);
            }
        }
        catch (StorageException ex) {
            throw new SAXException(ex);
        }
    }

    public void notifyError(SAXParseException e) throws SAXException {
        this.throwError(e);
    }

    public void throwError(SAXParseException e) throws SAXException {
        try {
            XMLFormatConverter.print(new SOAPFaultDocumentBuilder(e).newDocument(), this.getOutputStream());
        }
        catch (ParserConfigurationException pe) {
            throw new SAXException(pe);
        }
        catch (TransformerException te) {
            throw new SAXException(te);
        }
        throw e;
    }
}

