/*
 * Decompiled with CFR 0.152.
 */
package daruma.wfs.filter.predicates;

import daruma.geometry.TransformationContext;
import daruma.sql.SQLDataType;
import daruma.sql.SQLTimeFormatConverter;
import daruma.sql.TableColumnDefinition;
import daruma.storage_manager.StorageManager;
import daruma.storage_manager.type_definition.TypeDefinition;
import daruma.storage_manager.type_definition.TypeException;
import daruma.util.ISO8601DateFormat;
import daruma.util.LogWriter;
import daruma.wfs.filter.PredicateDescription;
import daruma.wfs.filter.PropertyPathConverter;
import daruma.xml.DeclaredName;
import daruma.xml.Lexicon;
import daruma.xml.util.ElementUtil;
import daruma.xml.util.XMLParseErrorException;
import java.sql.Timestamp;
import java.text.ParsePosition;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PropertyComparationPredicateDescription
extends PredicateDescription {
    private String sqlOperator;
    private String sqlExpression;
    private String propertyXPath;
    private Element xpathContext;
    private String value;
    private static DeclaredName.Table<String> operatorTable = new DeclaredName.Table();

    public static boolean isAcceptablePredicate(String localName) {
        return operatorTable.getByLocalName(localName) != null;
    }

    public PropertyComparationPredicateDescription(Element comparePredicateElement, TypeDefinition type, TransformationContext trans, StorageManager storage) throws XMLParseErrorException {
        super(storage, type, trans);
        DeclaredName.Table.Entry entry = operatorTable.getEntry(comparePredicateElement);
        this.sqlOperator = (String)entry.getValue();
        this.tagName = entry.getName();
        if (this.sqlOperator == null) {
            throw new XMLParseErrorException("cannot handle filter \"" + comparePredicateElement.getLocalName() + "\"");
        }
        this.sqlExpression = this.parsePropertyComparation(comparePredicateElement);
    }

    public String getSQLExpression() {
        return this.sqlExpression;
    }

    private String parsePropertyComparation(Element comp) throws XMLParseErrorException {
        List<Element> childElements = ElementUtil.getChildElements(comp);
        if (childElements.size() != 2) {
            throw new XMLParseErrorException("filter \"" + comp.getLocalName() + "\"" + " has invalid number of child elements," + " expected was 2");
        }
        Element propertyNameElement = childElements.get(0);
        Element literalElement = childElements.get(1);
        Lexicon.MispPropertyName.matchesOrXmlException(propertyNameElement, "in Property Compariton Operator");
        Lexicon.MispLiteral.matchesOrXmlException(literalElement, "in Property Compariton Operator");
        String literalString = ElementUtil.getChildNodesWholeText(literalElement);
        String shortXPath = PropertyPathConverter.convertPropertyElementToShortXPath(propertyNameElement, super.getStorage());
        String sqlValueString = this.convertValueToSQL(shortXPath, literalString);
        String leftArg = shortXPath;
        String rightArg = null;
        rightArg = shortXPath.equals("_transaction_id_") ? this.genSubQueryForTransactionSN(literalString) : "\"" + sqlValueString + "\"";
        this.propertyXPath = ElementUtil.getChildNodesWholeText(propertyNameElement);
        this.xpathContext = propertyNameElement;
        this.value = literalString;
        return "`" + leftArg + "`" + this.sqlOperator + rightArg;
    }

    private String convertValueToSQL(String columnName, String value) throws XMLParseErrorException {
        SQLDataType sqlType = super.getTypeDefinition().getSingleSQLDataType();
        if (sqlType == null) {
            List<TableColumnDefinition> columns;
            try {
                columns = super.getTypeDefinition().getCompositeSQLDataType(super.getStorage(), null);
            }
            catch (TypeException e) {
                throw new XMLParseErrorException("type definition error", e);
            }
            for (TableColumnDefinition c : columns) {
                if (!c.getColumnName().equals(columnName)) continue;
                sqlType = c.getSQLDataType();
                break;
            }
        }
        if (sqlType == null) {
            if (columnName.equals("_transaction_id_")) {
                sqlType = new SQLDataType("integer", Integer.class);
            } else if (columnName.equals("_create_time_") || columnName.equals("_update_time_")) {
                sqlType = new SQLDataType("datetime", Timestamp.class);
            }
        }
        if (sqlType == null) {
            LogWriter.qwrite("DEBUG", "columnName [", columnName, "] not found");
            throw new XMLParseErrorException("property not found");
        }
        if (sqlType.isTimeFamilyType()) {
            ISO8601DateFormat dateParser = new ISO8601DateFormat();
            Date date = dateParser.parse(value, new ParsePosition(0));
            if (date == null) {
                throw new XMLParseErrorException("Illegal datetime format:'" + value + "'" + " It should be yyyy-mm-ddThh:mm:ss.sss" + "[+/-]HH:MM");
            }
            String dateString = SQLTimeFormatConverter.convertDateToString(date);
            return dateString;
        }
        return value;
    }

    private String genSubQueryForTransactionSN(String uriString) {
        return "ifnull((select id from __transaction_log__ where uri=\"" + uriString + "\"" + ")" + "," + "0" + ")";
    }

    public boolean detailedCheck(Node feature) throws XMLParseErrorException {
        return true;
    }

    static {
        operatorTable.put(Lexicon.MispFilterPropertyIsEqualTo, "=");
        operatorTable.put(Lexicon.MispFilterPropertyIsLessThan, "<");
        operatorTable.put(Lexicon.MispFilterPropertyIsGreaterThan, ">");
        operatorTable.put(Lexicon.MispFilterPropertyIsLessThanOrEqualTo, "<=");
        operatorTable.put(Lexicon.MispFilterPropertyIsGreaterThanOrEqualTo, ">=");
    }
}

