package daruma.wfs;

import daruma.wfs.transaction.InsertAnElementHandler;

/* !!! [06/08/22 18:56 I.Noda] !!! 
 * TransactionResultInfo Ƴ
 */
import daruma.wfs.TransactionResultInfo ;

import daruma.xml.handler.MispDefaultHandler;
import daruma.xml.Lexicon ;

import daruma.storage_manager.StorageManager;

import org.xml.sax.XMLReader;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

import java.io.OutputStream;


public class TransactionInsertHandler extends MispDefaultHandler
{
    private	StorageManager		storage;
    private	TransactionHandler	errorReceiver;

    /* !!! [06/10/18 00:41 I.Noda] !!! 
     * ̵̤ InsertAnElementHandler ʤˡ
     * Ȥޤ路롣
     */
    private     InsertAnElementHandler  insertHandler ;

    /* !!! [06/08/22 18:56 I.Noda] !!! 
     * TransactionResultInfo Ƴ
     */
    private TransactionResultInfo resultInfo ;

    public	TransactionInsertHandler( OutputStream  out ,
					  XMLReader  parser ,
					  boolean  isTopLevelHandler ,
					  StorageManager  storage ,
					  TransactionHandler  errorReceiver,
					  /* !!! [06/08/22 18:56 I.Noda] !!! 
					   * TransactionResultInfo Ƴ
					   */
					  TransactionResultInfo resultInfo)
    {
	super( out , parser , isTopLevelHandler );

	this.storage       = storage;
	this.errorReceiver = errorReceiver;

	/* !!! [06/08/22 18:56 I.Noda] !!! 
	 * TransactionResultInfo Ƴ
	 */
	this.resultInfo  = resultInfo;
	if(this.resultInfo.countInsert < 0) {
	    this.resultInfo.countInsert = 0 ;
	}

	/* !!! [06/10/18 00:41 I.Noda] !!! 
	 * ̵̤ InsertAnElementHandler ʤˡ
	 * Ȥޤ路롣
	 */
	this.insertHandler = null ;
		    
    }

    public	void	xStartElement( String uri ,
				       String localName ,
				       String qName ,
				       Attributes  attrs ) throws SAXException
    {
	assert super.getCurrentLevel() == 1
	    || super.getCurrentLevel() == 2;

	//XMLTag	t = new XMLTag( uri , localName );

	if ( super.getCurrentLevel() == 1 ) {
	    Lexicon.MispInsert.matchesOrSaxException(uri, null, localName,
						     super.getLocator(),
						     "in Transaction") ;
	    return;
	}
	
	/* !!! [06/10/18 00:41 I.Noda] !!! 
	 * ̵̤ InsertAnElementHandler ʤˡ
	 * Ȥޤ路롣
	 */
	/* <<< [06/10/18 00:41 I.Noda] <<< */
	//super.setContentHandlerDelegator
	//    ( new InsertAnElementHandler
	//      ( super.getOutputStream() ,
	//	super.getParser() ,
	//	false ,
	//	this.storage ,
	//	this.errorReceiver,
	//	this.resultInfo) ,
	//     uri , localName , qName , attrs );
	/* === [06/10/18 00:41 I.Noda] === */
	if(this.insertHandler == null) {
	    this.insertHandler = 
		new InsertAnElementHandler(super.getOutputStream(),
					   super.getParser(),
					   false ,
					   this.storage ,
					   this.errorReceiver,
					   this.resultInfo) ;
	}
	this.insertHandler.reset() ;
	super.setContentHandlerDelegator(this.insertHandler,
					 uri, localName, qName, attrs);
	/* >>> [06/10/18 00:41 I.Noda] >>> */
    }


    private	void	throwError( SAXParseException  e ) throws SAXException
    {
	this.errorReceiver.notifyError( e );

	throw e;
    }
}
