/*
 * Decompiled with CFR 0.152.
 */
package daruma.sql;

import daruma.geometry.DrmGeometry;
import daruma.sql.DatabaseConnection;
import daruma.sql.DatabaseConnectionException;
import daruma.sql.SQLTimeFormatConverter;
import daruma.sql.TableColumn;
import daruma.storage_manager.type_definition.ColumnNameFactory;
import daruma.storage_manager.type_definition.TypedInstance;
import daruma.util.ISO8601DateFormat;
import daruma.util.LogWriter;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Date;
import java.util.List;

public class ElementInserter {
    private ElementInserter() {
    }

    public static void executeInsert(DatabaseConnection db, String tableName, List<TableColumn> columns, long transactionSN) throws DatabaseConnectionException {
        PreparedStatement st = ElementInserter.getPreparedStatement(db, tableName, columns);
        long objectID = db.getMaxLongValueFromTable(tableName, "_id_");
        ++objectID;
        ElementInserter.setValuesToPreparedStatement(st, transactionSN, columns);
        try {
            db.executeUpdate(st);
            st.close();
        }
        catch (SQLException e) {
            throw new DatabaseConnectionException(e.getMessage(), e);
        }
        ElementInserter.executeInsertToSubTable(db, columns, objectID);
    }

    public static void executeBulkInsert(DatabaseConnection db, String tableName, List<TypedInstance> objs, long transactionSN) throws DatabaseConnectionException {
        PreparedStatement st = ElementInserter.getPreparedStatement(db, tableName, objs.get(0).getColumns());
        long objectID = db.getMaxLongValueFromTable(tableName, "_id_");
        ++objectID;
        for (TypedInstance obj : objs) {
            List<TableColumn> columns = obj.getColumns();
            ElementInserter.setValuesToPreparedStatement(st, transactionSN, columns);
            try {
                st.addBatch();
                st.clearParameters();
            }
            catch (SQLException e) {
                throw new DatabaseConnectionException(e.getMessage(), e);
            }
            ElementInserter.executeInsertToSubTable(db, columns, objectID);
            ++objectID;
        }
        try {
            st.executeBatch();
            st.close();
        }
        catch (SQLException e) {
            throw new DatabaseConnectionException(e.getMessage(), e);
        }
    }

    private static PreparedStatement getPreparedStatement(DatabaseConnection db, String tableName, List<TableColumn> columns) throws DatabaseConnectionException {
        StringBuilder s = new StringBuilder();
        s.append("INSERT INTO `" + tableName + "` (");
        s.append("_transaction_id_");
        s.append(",");
        s.append("_create_time_");
        s.append(",");
        s.append("_update_time_");
        for (TableColumn c : columns) {
            s.append(",");
            s.append("`");
            s.append(c.getDefinition().getColumnName());
            s.append("`");
        }
        s.append(") ");
        s.append("VALUES (");
        int wildcardCount = 0;
        s.append("?");
        ++wildcardCount;
        s.append(",");
        s.append("NULL");
        s.append(",");
        s.append("NULL");
        for (TableColumn c : columns) {
            s.append(",");
            Class javaClass = c.getDefinition().getSQLDataType().getJavaClass();
            if (DrmGeometry.class.isAssignableFrom(javaClass)) {
                ++wildcardCount;
                s.append("GeomFromText(?)");
                continue;
            }
            if (Date.class.isAssignableFrom(javaClass)) {
                ++wildcardCount;
                s.append("?");
                continue;
            }
            ++wildcardCount;
            s.append("?");
        }
        s.append(")");
        LogWriter.qwrite("DEBUG", "#", s);
        PreparedStatement st = null;
        st = db.prepareStatement(s.toString());
        return st;
    }

    private static void setValuesToPreparedStatement(PreparedStatement st, long transactionSerialNumber, List<TableColumn> columns) throws DatabaseConnectionException {
        try {
            int wildcardIndex = 1;
            st.setLong(wildcardIndex, new Long(transactionSerialNumber));
            ++wildcardIndex;
            for (int i = 0; i < columns.size(); ++i) {
                TableColumn col = columns.get(i);
                if (col.isEmptyColumn() || col.getValue() == null) {
                    st.setNull(wildcardIndex, 0);
                    ++wildcardIndex;
                    continue;
                }
                Class c = col.getDefinition().getSQLDataType().getJavaClass();
                if (c.equals(String.class)) {
                    st.setString(wildcardIndex, col.getValue());
                    ++wildcardIndex;
                    continue;
                }
                if (c.equals(Boolean.class)) {
                    boolean value = Boolean.parseBoolean(col.getValue());
                    st.setBoolean(wildcardIndex, value);
                    ++wildcardIndex;
                    continue;
                }
                if (c.equals(Double.class)) {
                    double value = Double.parseDouble(col.getValue());
                    st.setDouble(wildcardIndex, value);
                    ++wildcardIndex;
                    continue;
                }
                if (c.equals(Float.class)) {
                    float value = Float.parseFloat(col.getValue());
                    st.setFloat(wildcardIndex, value);
                    ++wildcardIndex;
                    continue;
                }
                if (Date.class.isAssignableFrom(c)) {
                    Date dateTime;
                    ISO8601DateFormat f = new ISO8601DateFormat();
                    try {
                        dateTime = f.parse(col.getValue());
                    }
                    catch (ParseException e) {
                        throw new DatabaseConnectionException(e);
                    }
                    st.setString(wildcardIndex, SQLTimeFormatConverter.convertDateToString(dateTime));
                    ++wildcardIndex;
                    continue;
                }
                if (DrmGeometry.class.isAssignableFrom(c)) {
                    st.setString(wildcardIndex, col.getValue());
                    ++wildcardIndex;
                    continue;
                }
                st.setString(wildcardIndex, col.getValue());
                ++wildcardIndex;
            }
        }
        catch (SQLException e) {
            throw new DatabaseConnectionException(e.getMessage(), e);
        }
    }

    private static void executeInsertToSubTable(DatabaseConnection db, List<TableColumn> columns, long parentID) throws DatabaseConnectionException {
        for (TableColumn c : columns) {
            if (c.isEmptyColumn() || !c.getDefinition().isExternalTable()) continue;
            String tableName = c.getValue();
            LogWriter.qwrite("DEBUG", "tableName = [", tableName, "]");
            long id = db.getMaxLongValueFromTable(tableName, "_id_");
            ++id;
            for (String v : c.getSubValues()) {
                LogWriter.qwrite("DEBUG", "value = [", v, "]");
                String sql = "INSERT INTO `" + c.getValue() + "` (`_id_`,`_parent_id_`, `" + ColumnNameFactory.getTopLevelElementColumnName() + "`) VALUES (" + id + "," + parentID + ",?)";
                PreparedStatement st = null;
                st = db.prepareStatement(sql);
                LogWriter.qwrite("DEBUG", "#", sql);
                try {
                    st.setString(1, v);
                    db.executeUpdate(st);
                    st.close();
                }
                catch (SQLException e) {
                    throw new DatabaseConnectionException(e.getMessage(), e);
                }
            }
        }
    }
}

