/*
 * Decompiled with CFR 0.152.
 */
package daruma.storage_manager.type_definition.types;

import daruma.sql.TableColumn;
import daruma.storage_manager.StorageException;
import daruma.storage_manager.StorageManager;
import daruma.storage_manager.type_definition.AbstractCompositorTypeDefinition;
import daruma.storage_manager.type_definition.ElementName;
import daruma.storage_manager.type_definition.TypeDefinition;
import daruma.storage_manager.type_definition.TypeException;
import daruma.storage_manager.type_definition.TypeName;
import daruma.storage_manager.type_definition.TypedInstance;
import daruma.util.LogWriter;
import daruma.util.Pair;
import daruma.xml.SimpleXPath;
import daruma.xml.UniversalName;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AllTypeDefinition
extends AbstractCompositorTypeDefinition {
    @Override
    public Pair<TypedInstance, Integer> createInstance(Element element, ElementName topLevelElement, SimpleXPath path, StorageManager storage, int elementIndex) throws TypeException {
        LogWriter.qwrite("DEBUG", "");
        LogWriter.qwrite("DEBUG", "");
        LogWriter.qwrite("DEBUG", this.getClass().getName(), ": createInstance()");
        LogWriter.qwrite("DEBUG", "elementIndex = ", elementIndex);
        LogWriter.qwrite("DEBUG", "--");
        super.debugPrint();
        LogWriter.qwrite("DEBUG", "--");
        ElementName parentElementName = new ElementName(element);
        int nThChildNode = elementIndex;
        NodeList childNodes = element.getChildNodes();
        ArrayList<Element> tagList = new ArrayList<Element>();
        while (true) {
            if (nThChildNode >= childNodes.getLength()) {
                throw new TypeException("too few child elements of " + parentElementName.toString());
            }
            Node n = childNodes.item(nThChildNode);
            if (n instanceof Element) {
                tagList.add((Element)n);
                if (tagList.size() == this.getEntries().size()) {
                    ++nThChildNode;
                    break;
                }
            }
            ++nThChildNode;
        }
        for (AbstractCompositorTypeDefinition.Entry entry : this.getEntries()) {
            ElementName expectedElementName = entry.getAtomEntry().getElementName();
            LogWriter.qwrite("DEBUG", "[", expectedElementName, "]");
        }
        for (Element t : tagList) {
            ElementName tag = new ElementName(t);
            LogWriter.qwrite("DEBUG", "[[", tag, "]]");
        }
        ArrayList<Element> sortedTagList = new ArrayList<Element>();
        block5: for (AbstractCompositorTypeDefinition.Entry entry : this.getEntries()) {
            for (Element t : tagList) {
                if (!entry.getAtomEntry().getElementName().equals(new ElementName(t))) continue;
                sortedTagList.add(t);
                continue block5;
            }
        }
        if (sortedTagList.size() != this.getEntries().size()) {
            throw new TypeException("invalid child elements of " + parentElementName.toString());
        }
        ArrayList<TableColumn> columnList = new ArrayList<TableColumn>();
        for (int i = 0; i < super.getEntries().size(); ++i) {
            TypeDefinition type;
            AbstractCompositorTypeDefinition.Entry entry = super.getEntries().get(i);
            assert (!entry.isCompositeEntry());
            ElementName expectedElementName = entry.getAtomEntry().getElementName();
            LogWriter.qwrite("DEBUG", "expected element = [", expectedElementName, "]");
            TypeName typeName = entry.getAtomEntry().getTypeName();
            LogWriter.qwrite("DEBUG", "typeName = [", typeName, "]");
            try {
                type = storage.getTypeDefinition(typeName);
            }
            catch (StorageException se) {
                throw new TypeException(se);
            }
            LogWriter.qwrite("DEBUG", "type.class = ", type.getClass().getName());
            SimpleXPath p = new SimpleXPath(path);
            if (path != null) {
                p.add(new UniversalName(element));
            }
            TypedInstance obj = type.createInstance((Element)sortedTagList.get(i), topLevelElement, p, storage, 0).getFirst();
            columnList.addAll(obj.getColumns());
        }
        LogWriter.qwrite("DEBUG", "");
        LogWriter.qwrite("DEBUG", "");
        return new Pair<TypedInstance, Integer>(new TypedInstance(columnList, this), nThChildNode);
    }
}

