/*
 * Decompiled with CFR 0.152.
 */
package daruma.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class CountOutputStream
extends FilterOutputStream {
    private long byteCount = 0L;

    public CountOutputStream(OutputStream out) {
        super(out);
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        ++this.byteCount;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.out.write(b);
        this.byteCount += (long)b.length;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.byteCount += (long)len;
    }

    public long getByteCount() {
        return this.byteCount;
    }
}

