package daruma.storage_manager.type_definition;

import daruma.sql.Separators;
import daruma.xml.SimpleXPath;
import daruma.xml.UniversalName;

import daruma.storage_manager.StorageManager;
import daruma.storage_manager.StorageException;


/* !!! [06/08/16 02:50 I.Noda] !!! 
 * TopLevelElementColumnNameFactory.java ܿ
 * Ū naming Τˡ
 */
public class ColumnNameFactory
{

    /**
     * column̾³ʸ
     */
    public static final String ColNameSep = Separators.PATH_SEPARATOR ;

    /**
     * attribute  column̾³ʸ
     */
    public static final String ColNameAttributePrefix = "@";

    /**
     * column̾γĥ³ʸ
     */
    public static final String ColNameSuffixSep = "_" ;

    /**
     * toplevel ͡뤤 geometrytimeʸȤƤ
     */
    public static final String ColNameForValue = "_value_" ;
    

    /**
     * constructor 򱣤
     */
	private	ColumnNameFactory()
	{
	}

	public	static	String	createColumnName
				    ( SimpleXPath  path ,
				      StorageManager  storage )
							throws StorageException
	{
		String	columnName;

		if ( path == null || path.getList().size() == 0 )
		{
			columnName = ColumnNameFactory
					.getTopLevelElementColumnName();

			if ( path != null && path.isAttribute() )
			{
				columnName += ColumnNameFactory.ColNameSep;
				columnName += ColumnNameFactory
						.ColNameAttributePrefix;
				columnName += storage.getUniversalNameID
						( path.getAttributeName() );
			}
		}
		else
		{
			SimpleXPath	newPath = new SimpleXPath( path );

			columnName = storage.getShortXPathStringForDB
								( newPath );
		}

		return( columnName );
	}


	public	static	String	createAttributeColumnName
				    ( SimpleXPath  path ,
				      UniversalName  attributeName ,
				      StorageManager  storage )
							throws StorageException
	{
		String	baseColumnName;

		if ( path == null )
		{
			baseColumnName = ColumnNameFactory
					.getTopLevelElementColumnName();
		}
		else
		{
			SimpleXPath	newPath = new SimpleXPath( path );

			baseColumnName = storage.getShortXPathStringForDB
								( newPath );
		}

		String	columnName = baseColumnName
				     + ColumnNameFactory.ColNameSep
				     + ColumnNameFactory.ColNameAttributePrefix
				     + storage.getUniversalNameID
							( attributeName );

		return( columnName );
	}

	public	static	String	createAttributeColumnName
				    ( SimpleXPath  path ,
				      ElementName  elementName ,
				      UniversalName  attributeName ,
				      StorageManager  storage )
							throws StorageException
	{
		String	baseColumnName;

		if ( path == null )
		{
			baseColumnName = ColumnNameFactory
					.getTopLevelElementColumnName();
		}
		else
		{
			SimpleXPath	newPath = new SimpleXPath
							( path , elementName );

			baseColumnName = storage.getShortXPathStringForDB
								( newPath );
		}

		String	columnName = baseColumnName
				     + ColumnNameFactory.ColNameSep
				     + ColumnNameFactory.ColNameAttributePrefix
				     + storage.getUniversalNameID
							( attributeName );

		return( columnName );
	}


    /**
     * toplevel ΥȤͤΤΥ̾
     */
	public	static	final	String	getTopLevelElementColumnName()
	{
	    /* !!! [06/08/16 02:50 I.Noda] !!! 
	     * ΤˡʸϤǤ final ѿ
	     */
	    //return( "_value_" );
	    return( ColNameForValue ) ;
	}

    public	static	final	String	getTopLevelElementColumnName
							( String  suffix )
	{
	    return( ColNameForValue + ColNameSep + suffix ) ;
	}

    /* !!! [06/08/16 02:50 I.Noda] !!! 
     * suffix դ̾
     */
    public static final	String	getColumnName(String shortName,
					      String suffix)
    {
	return( shortName + ColNameSep + suffix ) ;
    }

    /* !!! [06/08/16 02:50 I.Noda] !!! 
     * 餯夯βԡElementColumnNameFactory顣
     */
    public	static	final	String	getCoiceElementIndexColumnName
						     ( String  base )
	{
		return( base + ColNameSep
			+ "choice_element_index" );
	}

}
