package daruma.wfs.filter.predicates;

import daruma.wfs.filter.PredicateDescription;
import daruma.xml.util.XMLParseErrorException;
import daruma.xml.Lexicon;

import org.w3c.dom.Element;
import org.w3c.dom.Node;

import daruma.storage_manager.StorageManager;
import daruma.storage_manager.type_definition.TypeDefinition;

import daruma.geometry.TransformationContext;

public class ImmidiateValueBooleanDescription extends PredicateDescription
{
	public	static	boolean	isAcceptablePredicate( String  localName )
	{
		return( localName.equals(Lexicon.MispFilterTrue.localname)
		     || localName.equals(Lexicon.MispFilterFalse.localname));
	}

	private	String	sqlExpression;

	public	ImmidiateValueBooleanDescription
				( Element  element ,
				  TypeDefinition  type ,
				  TransformationContext  trans ,
				  StorageManager  storage )
					    throws XMLParseErrorException
	{
		super( storage , type , trans );

		if ( Lexicon.MispFilterTrue.matches(element) ){
		    this.tagName = Lexicon.MispFilterTrue ;
		    this.sqlExpression = "TRUE";
		}
		else if ( Lexicon.MispFilterFalse.matches(element) ) {
		    this.tagName = Lexicon.MispFilterFalse ;
		    this.sqlExpression = "FALSE";
		}
		else {
		    throw new XMLParseErrorException
			( "cannot handle filter \""
			  + element.getTagName() + "\"" );
		}
	}

	public	String	getSQLExpression()
	{
		return( this.sqlExpression );
	}

    //--------------------------------------------------
    /**
     * ܺ٥å
     * ʤɤΥå̩˹Ԥ2nd pass ν
     */
    public boolean detailedCheck(Node feature) 
    	throws XMLParseErrorException
    {
	return (this.tagName != Lexicon.MispFilterFalse) ;
    }
    
}
