#include <stdio.h>
#include <stdlib.h>
#include "mpi.h"
 
static FILE* logfile;

#define replay(buf, byte, count) \
  fread(buf, byte, count, logfile)

int
MPI_Init(int* argc, char*** argv)
{
  int ret;
  char filename[32];
  
  strncpy(filename, (*argv)[*argc-1], 32);

  if(NULL == (logfile = fopen(filename, "rb"))) {
    printf("Replaying Error: Can't open %s\n", filename);
    exit(-1);
  }

  PMPI_Init(argc, argv);
  
  replay(&ret, sizeof(int), 1);

  return ret;
}

int
MPI_Comm_size(MPI_Comm comm, int* numprocs)
{
  int ret;

  replay(&ret, sizeof(int), 1);
  replay(numprocs, sizeof(int), 1);
  
  return ret;
}

int
MPI_Comm_rank(MPI_Comm comm, int* rank)
{
  int ret;

  replay(&ret, sizeof(int), 1);
  replay(rank, sizeof(int), 1);
  
  return ret;
}

int
MPI_Send(void *buf, int count, MPI_Datatype datatype,
         int dest, int tag, MPI_Comm comm)
{
  int ret;
  
  replay(&ret, sizeof(int), 1);
  
  return ret;
}

int
MPI_Recv(void *buf, int count, MPI_Datatype datatype,
         int src, int tag, MPI_Comm comm, MPI_Status *status)
{
  int ret, size;
  int *d;
  
  replay(&ret, sizeof(int), 1);
  MPI_Type_size(datatype, &size);
  replay(buf, size, count);
  replay(status, sizeof(MPI_Status), 1);

  return ret;
}

int
MPI_Bcast(void* buf, int count, MPI_Datatype datatype,
          int root, MPI_Comm comm)
{
  int ret, size;

  replay(&ret, sizeof(int), 1);
  MPI_Type_size(datatype, &size);
  replay(buf, size, count);
  
  return ret;
}

int
MPI_Scatter(void* sendbuf, int sendcnt, MPI_Datatype sendtype,
            void* recvbuf, int recvcnt, MPI_Datatype recvtype,
            int root, MPI_Comm comm)
{
  int ret, size;

  replay(&ret, sizeof(int), 1);
  MPI_Type_size(recvtype, &size);
  replay(recvbuf, size, recvcnt);
  
  return ret;
}

int
MPI_Gather(void* sendbuf, int sendcnt, MPI_Datatype sendtype,
           void* recvbuf, int recvcnt, MPI_Datatype recvtype,
           int root, MPI_Comm comm)
{
  int ret, size;

  replay(&ret, sizeof(int), 1);
  MPI_Type_size(recvtype, &size);
  replay(recvbuf, size, recvcnt);

  return ret;
}

int
MPI_Barrier(MPI_Comm comm)
{
  int ret;

  replay(&ret, sizeof(int), 1);

  return ret;
}

int
MPI_Allreduce(void* operand, void* result, int count,
              MPI_Datatype datatype, MPI_Op operator, MPI_Comm comm)
{
  int ret, size;

  replay(&ret, sizeof(int), 1);
  MPI_Type_size(datatype, &size);
  replay(result, size, count);

  return ret;
}

int
MPI_Cart_create(MPI_Comm oldcomm, int ndims, int dimsizes[],
                int wraparound[], int reorder, MPI_Comm* cart)
{
  int ret;

  replay(&ret, sizeof(int), 1);
  replay(cart, sizeof(MPI_Comm), 1);

  return ret;
}

int
MPI_Cart_get(MPI_Comm comm, int maxdims, int dims[], int periods[],
             int coords[])
{
  int ret;

  replay(&ret, sizeof(int), 1);
  replay(dims, sizeof(int), maxdims);
  replay(periods, sizeof(int), maxdims);
  replay(coords, sizeof(int), maxdims);

  return ret;
}

int
MPI_Cart_shift(MPI_Comm comm, int direction, int displacement,
               int* ranksrc, int* rankdest)
{
  int ret;

  replay(&ret, sizeof(int), 1);
  replay(ranksrc, sizeof(int), 1);
  replay(rankdest, sizeof(int), 1);

  return ret;
}

int
MPI_Isend(void* buf, int count, MPI_Datatype datatype, int dest,
          int tag, MPI_Comm comm, MPI_Request* req)
{
  int ret;

  replay(&ret, sizeof(int), 1);
  replay(req, sizeof(MPI_Request), 1);

  return ret;
}

int
MPI_Irecv(void* buf, int count, MPI_Datatype datatype, int src,
          int tag, MPI_Comm comm, MPI_Request* req)
{
  int ret, size;

  replay(&ret, sizeof(int), 1);
  MPI_Type_size(datatype, &size);
  replay(buf, size, count);
  replay(req, sizeof(MPI_Request), 1);

  return ret;
}

int
MPI_Wait(MPI_Request* req, MPI_Status* st)
{
  int ret;

  replay(&ret, sizeof(int), 1);
  replay(req, sizeof(MPI_Request), 1);
  replay(st, sizeof(MPI_Status), 1);

  return ret;
}

int
MPI_Waitall(int arysize, MPI_Request req[], MPI_Status st[])
{
  int ret;

  replay(&ret, sizeof(int), 1);
  replay(req, sizeof(MPI_Request), arysize);
  replay(st, sizeof(MPI_Status), arysize);

  return ret;
}
