﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using DataUnit.Core;
using System.IO;
using System.Diagnostics;
using System.Text.RegularExpressions;
using log4net;
using System.Reflection;

namespace DataUnit.Windows
{
    public partial class frmMain : Form
    {

        string _defaultConfigPath = Application.StartupPath + @"\config.xml";
        private static readonly ILog _logger
              = LogManager.GetLogger(MethodBase.GetCurrentMethod().DeclaringType);

        public frmMain()
        {
            InitializeComponent();
        }

        #region プライベートメソッド

        private Config PopulateConfig()
        {
            Config config = new Config();
            PoplateConnection(config);

            config.SqlPath = txtDirSql.Text;
            config.OutputPath = txtDirResult.Text;

            config.MailConfig.IsSend = chkMailExecute.Checked;
            config.MailConfig.To = txtMailTo.Text;
            config.MailConfig.From = txtMailFrom.Text;
            config.MailConfig.Cc = txtMailCc.Text;
            config.MailConfig.Bcc = txtMailBcc.Text;

            config.MailConfig.Title = txtMailTitle.Text;
            config.MailConfig.IsFileNameAddToTitle = chkTitleAdd.Checked;

            config.MailConfig.Body = txtMailBody.Text;

            config.MailConfig.SmtpServer = txtMailSmtp.Text;
            config.MailConfig.PopServer = txtMailPop.Text;

            config.MailConfig.SmtpUser = txtMailUser.Text;
            config.MailConfig.SmtpPassword = txtMailPassword.Text;
            config.MailConfig.AuthType = (MailAuth)cboSmtpAuth.SelectedIndex;

            if (config.MailConfig.AuthType == MailAuth.Smtp && chkSubmission.Checked)
            {
                config.MailConfig.SmtpPort = 587;
            }else{
                config.MailConfig.SmtpPort = 25;
            }

            return config;
            
        }

        private void PoplateConnection(Config config)
        {
            switch (tabConnect.SelectedIndex)
            {
                case 0:
                    config.DbKind = DbKind.SqlServer;
                    List<string> conSs = new List<string>();
                    conSs.Add(String.Format("Data Source={0}", txtServerSS.Text));
                    conSs.Add(String.Format("Initial Catalog={0}", txtDatabaseSS.Text));

                    if (chkWindowsAuth.Checked)
                    {
                        conSs.Add("Integrated Security=SSPI");
                    }
                    else
                    {
                        conSs.Add(String.Format("uid={0}",txtUserSS.Text));
                        conSs.Add(String.Format("pwd={0}", txtPasswordSS.Text));
                    }
                    config.ConnectionString = conSs.ToArray();
                    break;
                case 1:
                    config.DbKind = DbKind.Oracle;
                    string[] conOra = new string[3];
                    conOra[0] = String.Format("User Id={0}",txtUserOra.Text);
                    conOra[1] = String.Format("Password={0}", txtPasswordOra.Text);
                    conOra[2] = String.Format("Data Source={0}", txtServiceNameOra.Text);
                    config.ConnectionString = conOra;
                    break;
                case 2:
                    config.DbKind = DbKind.Mdb;
                    string[] conMdb = new string[2];
                    conMdb[0] = "Provider=Microsoft.Jet.OLEDB.4.0";
                    conMdb[1] = String.Format("Data Source={0}", txtMdbPath.Text);
                    config.ConnectionString = conMdb;
                    break;
                case 3:
                    config.DbKind = DbKind.Odbc;
                    string[] conOdbc = new string[3];
                    conOdbc[0] = String.Format("dsn={0}", txtOdbcDsn.Text);
                    conOdbc[1] = String.Format("UID={0}", txtUserOdbc.Text);
                    conOdbc[2] = String.Format("PWD={0}", txtPasswordOdbc.Text);
                    config.ConnectionString = conOdbc;
                    break;
            }


        }


        private void SetControls(Config config)
        {
            SetConnectionControls(config);
            txtDirSql.Text = config.SqlPath;
            txtDirResult.Text = config.OutputPath;

            chkMailExecute.Checked = config.MailConfig.IsSend;
            txtMailTo.Text = config.MailConfig.To;
            txtMailFrom.Text = config.MailConfig.From;
            txtMailCc.Text = config.MailConfig.Cc;
            txtMailBcc.Text = config.MailConfig.Bcc;
            txtMailTitle.Text = config.MailConfig.Title;
            chkTitleAdd.Checked = config.MailConfig.IsFileNameAddToTitle;
            txtMailBody.Text = config.MailConfig.Body;

            cboSmtpAuth.SelectedIndex = (int)config.MailConfig.AuthType;
            txtMailSmtp.Text = config.MailConfig.SmtpServer;
            txtMailPop.Text = config.MailConfig.PopServer;
            txtMailUser.Text = config.MailConfig.SmtpUser;
            txtMailPassword.Text = config.MailConfig.SmtpPassword;
            if (config.MailConfig.SmtpPort == 587)
            {
                chkSubmission.Checked = true;
            }else{
                chkSubmission.Checked = false;
            }

        }

        private void SetConnectionControls(Config config)
        {
            Dictionary<string, string> dic = new Dictionary<string, string>();
            foreach (string conStr in config.ConnectionString)
            {
                string key = conStr.Split('=')[0];
                string value = conStr.Split('=')[1];
                dic.Add(key.ToUpper(), value);
            }

            switch (config.DbKind)
            {
                case DbKind.SqlServer:
                    tabConnect.SelectedIndex = 0;

                    txtServerSS.Text = dic["DATA SOURCE"];
                    txtDatabaseSS.Text = dic["INITIAL CATALOG"];

                    if (dic.ContainsKey("INTEGRATED SECURITY"))
                    {
                        chkWindowsAuth.Checked = true;
                    }else{
                        chkWindowsAuth.Checked = false;
                        txtUserSS.Text = dic["UID"];
                        txtPasswordSS.Text = dic["PWD"];
                    }
                    break;

                case DbKind.Oracle:
                    tabConnect.SelectedIndex = 1;
                    txtUserOra.Text = dic["USER ID"];
                    txtPasswordOra.Text = dic["PASSWORD"];
                    txtServiceNameOra.Text = dic["DATA SOURCE"];
                    break;

                case DbKind.Mdb:
                    tabConnect.SelectedIndex = 2;
                    txtMdbPath.Text = dic["DATA SOURCE"];
                    break;

                case DbKind.Odbc:
                    tabConnect.SelectedIndex = 3;
                    txtOdbcDsn.Text = dic["DSN"];
                    txtUserOdbc.Text = dic["UID"];
                    txtPasswordOdbc.Text = dic["PWD"];
                    break;
            }

        }

        #endregion

        #region イベント

        private void frmMain_Load(object sender, EventArgs e)
        {
            _logger.Info("───────────────");
            _logger.Info("Windowsアプリケーション起動");

            Assembly mainAssembly = Assembly.GetEntryAssembly();
            AssemblyName mainAssemName = mainAssembly.GetName();
            Version ver = mainAssemName.Version;
            lblVersion.Text += String.Format("{0}.{1}.{2}", ver.Major, ver.Minor, ver.Build);


            if (File.Exists(_defaultConfigPath))
            {
                Host host = new Host();
                host.ConfigPath = _defaultConfigPath;
                host.ReadConfig();
                SetControls(host.Config);
            }
            else
            {
                cboSmtpAuth.SelectedIndex = 0;
                tabConnect.SelectedIndex = 2;
                txtMdbPath.Text = Path.GetFullPath(@"Demo\DB\sample.mdb");
                txtDirSql.Text = Path.GetFullPath(@"Demo\SQL");
                txtDirResult.Text = Path.GetFullPath(@"Demo\SQL\Output");
                btnExpSql.Enabled = Directory.Exists(txtDirSql.Text);
                btnExpResult.Enabled = Directory.Exists(txtDirResult.Text);
            }
        }

        private void btnDirSql_Click(object sender, EventArgs e)
        {
            this.fbdDir.SelectedPath = this.txtDirSql.Text;
            this.fbdDir.ShowDialog();
            this.txtDirSql.Text = this.fbdDir.SelectedPath;
        }

        private void btnExpSql_Click(object sender, EventArgs e)
        {
            UICommon.ShowExplorer(this.txtDirSql.Text);
        }

        private void txtDirSql_TextChanged(object sender, EventArgs e)
        {

            this.btnExpSql.Enabled = Directory.Exists(txtDirSql.Text);
            this.btnTimer.Enabled = Directory.Exists(txtDirSql.Text);

            if (this.chkSync.Checked)
            {
                this.txtDirResult.Text = this.txtDirSql.Text + "\\" + this.txtSync.Text;
            }
        }

        private void txtDirResult_TextChanged(object sender, EventArgs e)
        {
            btnExpResult.Enabled = Directory.Exists(txtDirResult.Text);
        }

        private void btnDirResult_Click(object sender, EventArgs e)
        {
            this.fbdDir.SelectedPath = this.txtDirResult.Text;
            this.fbdDir.ShowDialog();
            this.txtDirResult.Text = this.fbdDir.SelectedPath;
        }

        private void btnExpResult_Click(object sender, EventArgs e)
        {
            UICommon.ShowExplorer(this.txtDirResult.Text);
        }

        private void txtSync_TextChanged(object sender, EventArgs e)
        {
            this.txtDirResult.Text = this.txtDirSql.Text + "\\" + this.txtSync.Text;
        }

        private void chkSync_CheckedChanged(object sender, EventArgs e)
        {
            this.txtDirResult.Enabled = !chkSync.Checked;
            this.txtSync.Enabled = chkSync.Checked;
            this.btnDirResult.Enabled = !chkSync.Checked;
            if (chkSync.Checked)
            {
                this.txtDirResult.Text = this.txtDirSql.Text + "\\" + this.txtSync.Text;
            }
        }

        private void chkMailExecute_CheckedChanged(object sender, EventArgs e)
        {
            grpMail.Enabled = this.chkMailExecute.Checked;
        }

        private void lnkLog_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            if (Directory.Exists(@"Log\"))
            {
                lnkLog.LinkVisited = true;
                System.Diagnostics.Process.Start(@"Log\");
            }
        }

        private void lnkManual_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            lnkManual.LinkVisited = true;
            System.Diagnostics.Process.Start("http://dataunit.sourceforge.jp/");
        }

        private void lnkHomePage_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            lnkHomePage.LinkVisited = true;
            System.Diagnostics.Process.Start("http://sourceforge.jp/projects/dataunit/");
        }

        private void btnClose_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void btnDirMdb_Click(object sender, EventArgs e)
        {
            this.ofdDir.InitialDirectory = this.txtMdbPath.Text;
            this.ofdDir.Filter = "MDBファイル(*.mdb) | *.mdb";
            if (this.ofdDir.ShowDialog() == DialogResult.OK)
            {
                this.txtMdbPath.Text = this.ofdDir.FileName;
            }
        }

        private void chkWindowsAuth_CheckedChanged(object sender, EventArgs e)
        {
            txtUserSS.Enabled = !chkWindowsAuth.Checked;
            txtPasswordSS.Enabled = !chkWindowsAuth.Checked;
        }

        private void btnSave_Click(object sender, EventArgs e)
        {
            Host host = new Host(PopulateConfig());
            svfDir.Filter = "設定ファイル(*.xml)|*.xml";
            if (svfDir.ShowDialog() == DialogResult.OK)
            {
                host.ConfigPath = svfDir.FileName;
                host.WriteConfig();
                MessageBox.Show("設定ファイルを保存しました", "確認", MessageBoxButtons.OK, MessageBoxIcon.Information);
            }
           
        }

        private void btnLoad_Click(object sender, EventArgs e)
        {
            Host host = new Host();
            this.ofdDir.Filter = "設定ファイル(*.xml)|*.xml";
            if (this.ofdDir.ShowDialog() == DialogResult.OK)
            {
                host.ConfigPath = this.ofdDir.FileName;
                host.ReadConfig();
                SetControls(host.Config);
                MessageBox.Show("設定ファイルを読み込みました", "確認", MessageBoxButtons.OK, MessageBoxIcon.Information);
            }

        }

        private void cboSmtpAuth_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (cboSmtpAuth.SelectedIndex == 0)
            {   //認証なし
                txtMailPop.Enabled = false;
                txtMailUser.Enabled = false;
                txtMailPassword.Enabled = false;
                chkSubmission.Enabled = false;
            }
            else if (cboSmtpAuth.SelectedIndex == 1)
            {   //SMTP
                txtMailPop.Enabled = false;
                txtMailUser.Enabled = true;
                txtMailPassword.Enabled = true;
                chkSubmission.Enabled = true;
            }
            else
            {   //Pop Before SMTP
                txtMailPop.Enabled = true;
                txtMailUser.Enabled = true;
                txtMailPassword.Enabled = true;
                chkSubmission.Enabled = false;
            }
        }

        private void frmMain_FormClosing(object sender, FormClosingEventArgs e)
        {
            Host host = new Host(PopulateConfig());
            host.ConfigPath = _defaultConfigPath;
            host.WriteConfig();
            _logger.Info("Windowsアプリケーション終了");
        }

        private void btnTimer_Click(object sender, EventArgs e)
        {
            Host host = new Host(PopulateConfig());
            frmSql frmTimer = new frmSql(host.Config);
            this.Visible = false;
            frmTimer.ShowDialog(this);
            this.Visible = true;
        }
        #endregion 




    }
}
