using System;
using System.Data;
using System.Data.OracleClient;
using System.IO;

namespace DBConnect
{
	public class Db
	{

		//OraclẽRlNV
		OracleConnection conn = null;

		//DBڑ{郁\bh
		public void Connect(string user,string pass,string service)
		{
			Console.WriteLine("DBڑ");
			conn = new OracleConnection ("User Id=" + user +";Password=" + pass + ";Data Source=" + service);
			conn.Open();
		}

		//SQLs郁\bh
		//Y1ȏ゠ꍇ́ACSVt@Co͂[őt
		public void ExecSql(string sql,string outputFileName,string mailFrom,
			string mailTo,string mailCc ,string mailSmtp)
		{
			string cmdSql= sql;
			long lCnt = 0;

			try
			{
				//SQLsAOracleDataReaderɕۑ܂B
				Console.WriteLine("SQLs");
				OracleCommand cmd = new OracleCommand(cmdSql, conn);
				OracleDataReader myReader = cmd.ExecuteReader();
			    
				//CSVo͗pStreamWriter܂B
				StreamWriter sw = File.CreateText(outputFileName);

				//SQL̎sʂ̌񃋁[v܂B

				while(myReader.Read()) 
				{
					OutputHeader(sw , myReader,lCnt);           //wb_[p̗񖼂o
					OutputValue(sw,myReader);  					//lo
					lCnt ++;
				}

				myReader.Close();
				sw.Close();			
			}

			catch(Exception ex)
			{
				Console.WriteLine("SQLsɃG[");
				Console.WriteLine(ex.Message);
				Console.WriteLine(ex.Source);
				Console.WriteLine(ex.StackTrace);
				throw new Exception(ex.Message + "\n\n" + sql + "\n\no̓t@CF" +outputFileName + "\n\n()SQL̍Ō;/͕Kv܂B",ex);
			}

			//Y1ȏ゠ꍇ́A[CSVt@C𑗕t܂B
			if (lCnt != 0)
			{
				SendMail(outputFileName,mailFrom,mailTo,mailCc ,mailSmtp);
			}
		}

		//DBƂ̐ؒfs\bh
		public void DisConnect()
			{
				Console.WriteLine("DBؒf");
				if (conn != null)
					conn.Close();
					conn.Dispose();
			}
			
		//񖼂wb_[ƂCSV`ŏo͂郁\bh
		private void OutputHeader(StreamWriter sr,OracleDataReader myReader,long lCnt)
		{
			if (lCnt == 0)
			{

				for (int i = 0; i < myReader.FieldCount; i++)
				{
					sr.Write(myReader.GetName(i));
					if ( i < myReader.FieldCount-1 )
					{
						sr.Write(",");  //R}؂
					}
				}
				sr.WriteLine(""); //s
			}
		}

		//ʂCSV`ŏo͂郁\bh
		private void OutputValue(StreamWriter sr,OracleDataReader myReader)
		{

			for (int i = 0 ; i < myReader.FieldCount; i++)
			{
				sr.Write(myReader.GetValue(i));
				if ( i < myReader.FieldCount-1 )
				{
					sr.Write(",");  //R}؂
				}
			}
			sr.WriteLine(""); //s
		}


		//[𑗐M郁\bh
		private void SendMail(string outputFileName,string mailFrom,
			string mailTo,string mailCc ,string mailSmtp)
		{
			try
			{
				Console.WriteLine("[M");
				System.Web.Mail.SmtpMail.SmtpServer = mailSmtp;

				System.Web.Mail.MailMessage message
					= new System.Web.Mail.MailMessage();
				message.From =mailFrom;
				message.To = mailTo;
				message.Cc = mailCc;
				message.Subject = "[DataUnit]M(" + outputFileName.Substring(outputFileName.LastIndexOf("\\")+1
					,outputFileName.Length-((outputFileName.LastIndexOf("\\")+1))) +")";
				message.BodyEncoding = System.Text.Encoding.UTF8;
				message.BodyFormat = System.Web.Mail.MailFormat.Text;

				message.Body = "`̃[͎Mł`B\n\n"
					+"`FbNSQLɊYf[^邽߁A\nsʂYt܂B\n\n\n";


				System.Web.Mail.MailAttachment attachment = new System.Web.Mail.MailAttachment(
					outputFileName,System.Web.Mail.MailEncoding.Base64);
				message.Attachments.Add(attachment); 


				System.Web.Mail.SmtpMail.Send(message);
			}
			catch(Exception ex){
				Console.WriteLine("[MsɃG[");
				Console.WriteLine(ex.Message);
				Console.WriteLine(ex.Source);
				Console.WriteLine(ex.StackTrace);
				throw new Exception("[̑MɃG[܂B\nSMTP̐ݒmFĂ\n" + ex.Message ,ex);
			}
}
	}
}


