/*****************************************************************************/
/* The development of this program is partly supported by IPA                */
/* (Information-Technology Promotion Agency, Japan).                         */
/*****************************************************************************/

/*****************************************************************************/
/*  if.c - disk allocation checker GUI                                       */
/*  Copyright: Copyright (c) Hitachi, Ltd. 2004-2005                         */
/*             Authors: Yumiko Sugita (sugita@sdl.hitachi.co.jp),            */
/*                      Satoshi Fujiwara (sa-fuji@sdl.hitachi.co.jp)         */
/*                                                                           */
/*  This program is free software; you can redistribute it and/or modify     */
/*  it under the terms of the GNU General Public License as published by     */
/*  the Free Software Foundation; either version 2 of the License, or        */
/*  (at your option) any later version.                                      */
/*                                                                           */
/*  This program is distributed in the hope that it will be useful,          */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of           */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            */
/*  GNU General Public License for more details.                             */
/*                                                                           */
/*  You should have received a copy of the GNU General Public License        */
/*  along with this program; if not, write to the Free Software              */
/*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111 USA      */
/*****************************************************************************/

#include <gtk/gtk.h>
#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#include "dav.h"



GtkWidget* create_window(t_all_data* all)
{
	t_app_status	*app = ((t_all_data*)all)->app;
	gint		i;

	GtkWidget *window1;
	GtkWidget *vbox1;
	GtkWidget *menubar1;
	GtkWidget *menu_help;
	GtkWidget *item_help;
	GtkWidget *item_version;
	GtkWidget *hbox1;
	GtkWidget *table1;
	GtkWidget *label1;
	GtkWidget *label2;
	GtkWidget *combo1;
	GtkWidget *combo_entry1;
	GtkWidget *combo2;
	GtkWidget *combo_entry2;
	GtkWidget *vbox2;
	GtkWidget *w_exec;
	GtkWidget *w_abort;
	GtkWidget *hbox2;
	GtkWidget *scrolledwindow2;
	GtkWidget *t_output;
	GtkWidget *frame1;
	GtkWidget *area_note;
	GtkWidget *hbox3;
	GtkWidget *hbox9;
	GtkWidget *c_fbview1;
	GtkWidget *c_fbview2;
	GtkWidget *frame2;
	GtkWidget *hbox4;
	GtkWidget *label5;
	GtkWidget *hbox5;
	GtkWidget *label9;
	GtkObject *spinbutton1_adj;
	GtkWidget *spinbutton1;
	GtkWidget *button9;
	GtkWidget *notebook1;
	GtkWidget *vbox4;
	GtkWidget *hbox7;
	GtkWidget *button7;
	GtkWidget *button8;
	GtkWidget *label8;
	GtkWidget *scrolledwindow6;
	GtkWidget *viewport4;
	GtkWidget *area_fblocks;
	GtkWidget *label3;
	GtkWidget *vpaned1;
	GtkWidget *vbox5;
	GtkWidget *hbox8;
	GtkWidget *button10;
	GtkWidget *button11;
	GtkWidget *label10;
	GtkWidget *scrolledwindow4;
	GtkWidget *clist1;
	GtkWidget *label11;
	GtkWidget *label12;
	GtkWidget *label13;
	GtkWidget *label14;
	GtkWidget *label15;
	GtkWidget *label16;
	GtkWidget *vbox6;
	GtkWidget *hbox6;
	GtkWidget *button5;
	GtkWidget *button6;
	GtkWidget *label7;
	GtkWidget *scrolledwindow5;
	GtkWidget *viewport3;
	GtkWidget *drawingarea2;
	GtkWidget *label4;
	GtkWidget *status;


	window1 = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_object_set_data (GTK_OBJECT (window1), "window1", window1);
	gtk_window_set_title (GTK_WINDOW (window1), "DAV");

	vbox1 = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (vbox1);
	gtk_object_set_data_full (GTK_OBJECT (window1), "vbox1", vbox1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox1);
	gtk_container_add (GTK_CONTAINER (window1), vbox1);

	menubar1 = gtk_menu_bar_new ();
	gtk_widget_ref (menubar1);
	gtk_object_set_data_full (GTK_OBJECT (window1), "menubar1", menubar1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (menubar1);
	gtk_box_pack_start (GTK_BOX (vbox1), menubar1, FALSE, FALSE, 0);

	menu_help = gtk_menu_new();
	item_version = gtk_menu_item_new_with_label("version");
	gtk_menu_append(GTK_MENU(menu_help), item_version);
	gtk_widget_show(item_version);

	item_help = gtk_menu_item_new_with_label("help");
	gtk_widget_show(item_help);
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(item_help), menu_help);

	gtk_menu_item_right_justify(GTK_MENU_ITEM(item_help));
	gtk_menu_bar_append(GTK_MENU_BAR(menubar1), item_help);

	hbox1 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox1);
	gtk_object_set_data_full (GTK_OBJECT (window1), "hbox1", hbox1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox1);
	gtk_box_pack_start (GTK_BOX (vbox1), hbox1, FALSE, TRUE, 0);

	table1 = gtk_table_new (2, 2, FALSE);
	gtk_widget_ref (table1);
	gtk_object_set_data_full (GTK_OBJECT (window1), "table1", table1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (table1);
	gtk_box_pack_start (GTK_BOX (hbox1), table1, TRUE, TRUE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (table1), 5);
	gtk_table_set_row_spacings (GTK_TABLE (table1), 5);
	gtk_table_set_col_spacings (GTK_TABLE (table1), 5);

	label1 = gtk_label_new ("device:");
	gtk_widget_ref (label1);
	gtk_object_set_data_full (GTK_OBJECT (window1), "label1", label1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label1);
	gtk_table_attach (GTK_TABLE (table1), label1, 0, 1, 0, 1,
			  (GtkAttachOptions) (GTK_FILL),
	                  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (label1), 0, 0.5);

	label2 = gtk_label_new ("path:");
	gtk_widget_ref (label2);
	gtk_object_set_data_full (GTK_OBJECT (window1), "label2", label2,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label2);
	gtk_table_attach (GTK_TABLE (table1), label2, 0, 1, 1, 2,
	                  (GtkAttachOptions) (GTK_FILL),
	                  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (label2), 0, 0.5);

	combo1 = gtk_combo_new ();
	gtk_widget_ref (combo1);
	gtk_object_set_data_full (GTK_OBJECT (window1), "combo1", combo1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (combo1);
	gtk_table_attach (GTK_TABLE (table1), combo1, 1, 2, 0, 1,
	                  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
	                  (GtkAttachOptions) (0), 0, 0);

	combo_entry1 = GTK_COMBO (combo1)->entry;
	gtk_widget_ref (combo_entry1);
	gtk_object_set_data_full (GTK_OBJECT (window1), "combo_entry1",
				  combo_entry1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (combo_entry1);

	combo2 = gtk_combo_new ();
	gtk_widget_ref (combo2);
	gtk_object_set_data_full (GTK_OBJECT (window1), "combo2", combo2,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (combo2);
	gtk_table_attach (GTK_TABLE (table1), combo2, 1, 2, 1, 2,
	                  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
	                  (GtkAttachOptions) (0), 0, 0);

	combo_entry2 = GTK_COMBO (combo2)->entry;
	gtk_widget_ref (combo_entry2);
	gtk_object_set_data_full (GTK_OBJECT (window1), "combo_entry2",
				  combo_entry2,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (combo_entry2);

	vbox2 = gtk_vbox_new (FALSE, 5);
	gtk_widget_ref (vbox2);
	gtk_object_set_data_full (GTK_OBJECT (window1), "vbox2", vbox2,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox2);
	gtk_box_pack_start (GTK_BOX (hbox1), vbox2, FALSE, TRUE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (vbox2), 5);

	w_exec = gtk_button_new_with_label ("exec");
	gtk_widget_ref (w_exec);
	gtk_object_set_data_full (GTK_OBJECT (window1), "w_exec", w_exec,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (w_exec);
	gtk_box_pack_start (GTK_BOX (vbox2), w_exec, FALSE, FALSE, 0);

	w_abort = gtk_button_new_with_label ("abort");
	gtk_widget_ref (w_abort);
	gtk_object_set_data_full (GTK_OBJECT (window1), "w_abort", w_abort,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (w_abort);
	gtk_box_pack_start (GTK_BOX (vbox2), w_abort, FALSE, FALSE, 0);

	hbox2 = gtk_hbox_new (FALSE, 5);
	gtk_widget_ref (hbox2);
	gtk_object_set_data_full (GTK_OBJECT (window1), "hbox2", hbox2,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox2);
	gtk_box_pack_start (GTK_BOX (vbox1), hbox2, FALSE, TRUE, 0);
	/* note height = 105 */
	gtk_widget_set_usize (hbox2, -2, 105);
	gtk_container_set_border_width (GTK_CONTAINER (hbox2), 5);

	scrolledwindow2 = gtk_scrolled_window_new (NULL, NULL);
	gtk_widget_ref (scrolledwindow2);
	gtk_object_set_data_full (GTK_OBJECT (window1), "scrolledwindow2",
				  scrolledwindow2,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (scrolledwindow2);
	gtk_box_pack_start (GTK_BOX (hbox2), scrolledwindow2, TRUE, TRUE, 0);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow2),
					GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);

	t_output = gtk_text_new (NULL, NULL);
	gtk_widget_ref (t_output);
	gtk_object_set_data_full (GTK_OBJECT (window1), "t_output", t_output,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (t_output);
	gtk_container_add (GTK_CONTAINER (scrolledwindow2), t_output);

	frame1 = gtk_frame_new (NULL);
	gtk_widget_ref (frame1);
	gtk_object_set_data_full (GTK_OBJECT (window1), "frame1", frame1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (frame1);
	gtk_box_pack_start (GTK_BOX (hbox2), frame1, FALSE, TRUE, 0);
	/* note width = 270 */
	gtk_widget_set_usize (frame1, 270, -2);

	area_note = gtk_drawing_area_new ();
	gtk_widget_ref (area_note);
	gtk_object_set_data_full (GTK_OBJECT (window1), "area_note", area_note,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (area_note);
	gtk_container_add (GTK_CONTAINER (frame1), area_note);

	hbox3 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox3);
	gtk_object_set_data_full (GTK_OBJECT (window1), "hbox3", hbox3,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox3);
	gtk_box_pack_start (GTK_BOX (vbox1), hbox3, FALSE, TRUE, 0);

	hbox9 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox9);
	gtk_object_set_data_full (GTK_OBJECT (window1), "hbox9", hbox9,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox9);
	gtk_box_pack_start (GTK_BOX (hbox3), hbox9, FALSE, FALSE, 5);

	c_fbview1 = gtk_check_button_new_with_label ("file blocks view");
	gtk_widget_ref (c_fbview1);
	gtk_object_set_data_full (GTK_OBJECT (window1), "c_fbview1", c_fbview1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (c_fbview1);
	gtk_box_pack_start (GTK_BOX (hbox9), c_fbview1, FALSE, FALSE, 0);

	c_fbview2 = gtk_check_button_new_with_label ("file blocks view");
	gtk_widget_ref (c_fbview2);
	gtk_object_set_data_full (GTK_OBJECT (window1), "c_fbview2", c_fbview2,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_box_pack_start (GTK_BOX (hbox9), c_fbview2, FALSE, FALSE, 0);

	frame2 = gtk_frame_new (NULL);
	gtk_widget_ref (frame2);
	gtk_object_set_data_full (GTK_OBJECT (window1), "frame2", frame2,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (frame2);
	gtk_box_pack_start (GTK_BOX (hbox3), frame2, TRUE, TRUE, 5);

	hbox4 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox4);
	gtk_object_set_data_full (GTK_OBJECT (window1), "hbox4", hbox4,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox4);
	gtk_container_add (GTK_CONTAINER (frame2), hbox4);

	label5 = gtk_label_new ("summarize blocks: ");
	gtk_widget_ref (label5);
	gtk_object_set_data_full (GTK_OBJECT (window1), "label5", label5,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label5);
	gtk_box_pack_start (GTK_BOX (hbox4), label5, FALSE, FALSE, 5);

	hbox5 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox5);
	gtk_object_set_data_full (GTK_OBJECT (window1), "hbox5", hbox5,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox5);
	gtk_box_pack_start (GTK_BOX (hbox4), hbox5, TRUE, TRUE, 0);

	label9 = gtk_label_new ("2^");
	gtk_widget_ref (label9);
	gtk_object_set_data_full (GTK_OBJECT (window1), "label9", label9,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label9);
	gtk_box_pack_start (GTK_BOX (hbox5), label9, FALSE, FALSE, 0);

	spinbutton1_adj = gtk_adjustment_new (3, 0, 24, 1, 10, 10);
	spinbutton1 = gtk_spin_button_new (GTK_ADJUSTMENT (spinbutton1_adj),
					   1, 0);
	gtk_widget_ref (spinbutton1);
	gtk_object_set_data_full (GTK_OBJECT (window1), "spinbutton1",
				  spinbutton1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (spinbutton1);
	gtk_box_pack_start (GTK_BOX (hbox5), spinbutton1, FALSE, FALSE, 0);

	button9 = gtk_button_new_with_label ("update");
	gtk_widget_ref (button9);
	gtk_object_set_data_full (GTK_OBJECT (window1), "button9", button9,
	                           (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (button9);
	gtk_box_pack_start (GTK_BOX (hbox5), button9, FALSE, FALSE, 5);

	notebook1 = gtk_notebook_new ();
	gtk_widget_ref (notebook1);
	gtk_object_set_data_full (GTK_OBJECT (window1), "notebook1", notebook1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (notebook1);
	gtk_box_pack_start (GTK_BOX (vbox1), notebook1, TRUE, TRUE, 0);

	vbox4 = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (vbox4);
	gtk_object_set_data_full (GTK_OBJECT (window1), "vbox4", vbox4,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox4);
	gtk_container_add (GTK_CONTAINER (notebook1), vbox4);

	hbox7 = gtk_hbox_new (FALSE, 5);
	gtk_widget_ref (hbox7);
	gtk_object_set_data_full (GTK_OBJECT (window1), "hbox7", hbox7,
	                          (GtkDestroyNotify) gtk_widget_unref);
	/*gtk_widget_show (hbox7);*/
	gtk_box_pack_start (GTK_BOX (vbox4), hbox7, FALSE, TRUE, 0);

	button7 = gtk_button_new_with_label ("prev");
	gtk_widget_ref (button7);
	gtk_object_set_data_full (GTK_OBJECT (window1), "button7", button7,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (button7);
	gtk_box_pack_start (GTK_BOX (hbox7), button7, FALSE, FALSE, 0);

	button8 = gtk_button_new_with_label ("next");
	gtk_widget_ref (button8);
	gtk_object_set_data_full (GTK_OBJECT (window1), "button8", button8,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (button8);
	gtk_box_pack_start (GTK_BOX (hbox7), button8, FALSE, FALSE, 0);

	label8 = gtk_label_new ("info");
	gtk_widget_ref (label8);
	gtk_object_set_data_full (GTK_OBJECT (window1), "label8", label8,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label8);
	gtk_box_pack_start (GTK_BOX (hbox7), label8, FALSE, FALSE, 0);

	scrolledwindow6 = gtk_scrolled_window_new (NULL, NULL);
	gtk_widget_ref (scrolledwindow6);
	gtk_object_set_data_full (GTK_OBJECT (window1), "scrolledwindow6",
				  scrolledwindow6,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (scrolledwindow6);
	gtk_box_pack_start (GTK_BOX (vbox4), scrolledwindow6, TRUE, TRUE, 0);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow6),
					GTK_POLICY_AUTOMATIC,
					GTK_POLICY_ALWAYS);

	viewport4 = gtk_viewport_new (NULL, NULL);
	gtk_widget_ref (viewport4);
	gtk_object_set_data_full (GTK_OBJECT (window1), "viewport4", viewport4,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (viewport4);
	gtk_container_add (GTK_CONTAINER (scrolledwindow6), viewport4);

	area_fblocks = gtk_drawing_area_new ();
	gtk_widget_ref (area_fblocks);
	gtk_object_set_data_full (GTK_OBJECT (window1), "area_fblocks",
				  area_fblocks,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (area_fblocks);
	gtk_container_add (GTK_CONTAINER (viewport4), area_fblocks);

	label3 = gtk_label_new ("total blocks");
	gtk_widget_ref (label3);
	gtk_object_set_data_full (GTK_OBJECT (window1), "label3", label3,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label3);
	gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1),
				    gtk_notebook_get_nth_page
				    (GTK_NOTEBOOK (notebook1), 0), label3);

	vpaned1 = gtk_vpaned_new ();
	gtk_widget_ref (vpaned1);
	gtk_object_set_data_full (GTK_OBJECT (window1), "vpaned1", vpaned1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vpaned1);
	gtk_container_add (GTK_CONTAINER (notebook1), vpaned1);
	gtk_paned_set_position (GTK_PANED (vpaned1), 160);

	vbox5 = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (vbox5);
	gtk_object_set_data_full (GTK_OBJECT (window1), "vbox5", vbox5,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox5);
	gtk_paned_pack1 (GTK_PANED (vpaned1), vbox5, FALSE, TRUE);

	hbox8 = gtk_hbox_new (FALSE, 5);
	gtk_widget_ref (hbox8);
	gtk_object_set_data_full (GTK_OBJECT (window1), "hbox8", hbox8,
	                          (GtkDestroyNotify) gtk_widget_unref);
	/*gtk_widget_show (hbox8);*/
	gtk_box_pack_start (GTK_BOX (vbox5), hbox8, FALSE, TRUE, 0);

	button10 = gtk_button_new_with_label ("prev");
	gtk_widget_ref (button10);
	gtk_object_set_data_full (GTK_OBJECT (window1), "button10", button10,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (button10);
	gtk_box_pack_start (GTK_BOX (hbox8), button10, FALSE, FALSE, 0);

	button11 = gtk_button_new_with_label ("next");
	gtk_widget_ref (button11);
	gtk_object_set_data_full (GTK_OBJECT (window1), "button11", button11,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (button11);
	gtk_box_pack_start (GTK_BOX (hbox8), button11, FALSE, FALSE, 0);

	label10 = gtk_label_new ("info");
	gtk_widget_ref (label10);
	gtk_object_set_data_full (GTK_OBJECT (window1), "label10", label10,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label10);
	gtk_box_pack_start (GTK_BOX (hbox8), label10, FALSE, FALSE, 0);


	scrolledwindow4 = gtk_scrolled_window_new (NULL, NULL);
	gtk_widget_ref (scrolledwindow4);
	gtk_object_set_data_full (GTK_OBJECT (window1), "scrolledwindow4",
				  scrolledwindow4,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (scrolledwindow4);
	gtk_box_pack_start (GTK_BOX (vbox5), scrolledwindow4, TRUE, TRUE, 0);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow4),
					GTK_POLICY_AUTOMATIC,
					GTK_POLICY_ALWAYS);

	clist1 = gtk_clist_new (FFILE_INFO_CNT +1 +1);
						/* +1 for path, termination */
	gtk_widget_ref (clist1);
	gtk_object_set_data_full (GTK_OBJECT (window1), "clist1", clist1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (clist1);
	gtk_container_add (GTK_CONTAINER (scrolledwindow4), clist1);
	gtk_clist_set_column_width (GTK_CLIST (clist1), 0, 80);
	gtk_clist_set_column_width (GTK_CLIST (clist1), 1, 80);
	gtk_clist_set_column_width (GTK_CLIST (clist1), 2, 80);
	gtk_clist_set_column_width (GTK_CLIST (clist1), 3, 80);
	gtk_clist_set_column_width (GTK_CLIST (clist1), 4, 80);
	gtk_clist_set_column_width (GTK_CLIST (clist1), 5, 1);
	gtk_clist_column_titles_show (GTK_CLIST (clist1));

	label11 = gtk_label_new ("path");
	gtk_widget_ref (label11);
	gtk_object_set_data_full (GTK_OBJECT (window1), "label11", label11,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label11);
	gtk_clist_set_column_widget (GTK_CLIST (clist1), 0, label11);

	label12 = gtk_label_new ("f-per");
	gtk_widget_ref (label12);
	gtk_object_set_data_full (GTK_OBJECT (window1), "label12", label12,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label12);
	gtk_clist_set_column_widget (GTK_CLIST (clist1), 1, label12);
 
	label13 = gtk_label_new ("total");
	gtk_widget_ref (label13);
	gtk_object_set_data_full (GTK_OBJECT (window1), "label13", label13,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label13);
	gtk_clist_set_column_widget (GTK_CLIST (clist1), 2, label13);
 
	label14 = gtk_label_new ("frags");
	gtk_widget_ref (label14);
	gtk_object_set_data_full (GTK_OBJECT (window1), "label14", label14,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label14);
	gtk_clist_set_column_widget (GTK_CLIST (clist1), 3, label14);
 
	label15 = gtk_label_new ("sfrags");
	gtk_widget_ref (label15);
	gtk_object_set_data_full (GTK_OBJECT (window1), "label15", label15,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label15);
	gtk_clist_set_column_widget (GTK_CLIST (clist1), 4, label15);
 
	label16 = gtk_label_new ("");
	gtk_widget_ref (label16);
	gtk_object_set_data_full (GTK_OBJECT (window1), "label16", label16,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label16);
	gtk_clist_set_column_widget (GTK_CLIST (clist1), 5, label16);
 

	vbox6 = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (vbox6);
	gtk_object_set_data_full (GTK_OBJECT (window1), "vbox6", vbox6,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox6);
	gtk_paned_pack2 (GTK_PANED (vpaned1), vbox6, TRUE, TRUE);

	hbox6 = gtk_hbox_new (FALSE, 5);
	gtk_widget_ref (hbox6);
	gtk_object_set_data_full (GTK_OBJECT (window1), "hbox6", hbox6,
	                          (GtkDestroyNotify) gtk_widget_unref);
	/*gtk_widget_show (hbox6);*/
	gtk_box_pack_start (GTK_BOX (vbox6), hbox6, FALSE, TRUE, 0);

	button5 = gtk_button_new_with_label ("prev");
	gtk_widget_ref (button5);
	gtk_object_set_data_full (GTK_OBJECT (window1), "button5", button5,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (button5);
	gtk_box_pack_start (GTK_BOX (hbox6), button5, FALSE, FALSE, 0);

	button6 = gtk_button_new_with_label ("next");
	gtk_widget_ref (button6);
	gtk_object_set_data_full (GTK_OBJECT (window1), "button6", button6,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (button6);
	gtk_box_pack_start (GTK_BOX (hbox6), button6, FALSE, FALSE, 0);

	label7 = gtk_label_new ("info");
	gtk_widget_ref (label7);
	gtk_object_set_data_full (GTK_OBJECT (window1), "label7", label7,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label7);
	gtk_box_pack_start (GTK_BOX (hbox6), label7, FALSE, FALSE, 0);

	scrolledwindow5 = gtk_scrolled_window_new (NULL, NULL);
	gtk_widget_ref (scrolledwindow5);
	gtk_object_set_data_full (GTK_OBJECT (window1), "scrolledwindow5",
				  scrolledwindow5,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (scrolledwindow5);
	gtk_box_pack_start (GTK_BOX (vbox6), scrolledwindow5, TRUE, TRUE, 0);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow5),
					GTK_POLICY_AUTOMATIC,
					GTK_POLICY_ALWAYS);

	viewport3 = gtk_viewport_new (NULL, NULL);
	gtk_widget_ref (viewport3);
	gtk_object_set_data_full (GTK_OBJECT (window1), "viewport3", viewport3,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (viewport3);
	gtk_container_add (GTK_CONTAINER (scrolledwindow5), viewport3);

	drawingarea2 = gtk_drawing_area_new ();
	gtk_widget_ref (drawingarea2);
	gtk_object_set_data_full (GTK_OBJECT (window1), "drawingarea2",
				  drawingarea2,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (drawingarea2);
	gtk_container_add (GTK_CONTAINER (viewport3), drawingarea2);

	label4 = gtk_label_new ("fragmented files");
	gtk_widget_ref (label4);
	gtk_object_set_data_full (GTK_OBJECT (window1), "label4", label4,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label4);
	gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1),
				    gtk_notebook_get_nth_page
				    (GTK_NOTEBOOK (notebook1), 1), label4);

	status = gtk_statusbar_new ();
	gtk_widget_ref (status);
	gtk_object_set_data_full (GTK_OBJECT (window1), "status", status,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (status);
	gtk_box_pack_start (GTK_BOX (vbox1), status, FALSE, TRUE, 0);





	app->dev.widget = combo1;
	app->path.widget = combo2;
	app->fbview[NOTEPAGE_TOTAL] = c_fbview1;
	app->fbview[NOTEPAGE_FRAG] = c_fbview2;
	app->text.widget = t_output;
	app->text.adjust = gtk_scrolled_window_get_vadjustment
				(GTK_SCROLLED_WINDOW(scrolledwindow2));
	app->sbar.widget = status;
	app->sbar.cid =
		gtk_statusbar_get_context_id(GTK_STATUSBAR(app->sbar.widget),
					     CONTEXT_NAME);
	app->note.widget = area_note;

	app->blks[NOTEPAGE_TOTAL].widget = area_fblocks;
	app->blks[NOTEPAGE_TOTAL].scrl_win = scrolledwindow6;
	app->blks[NOTEPAGE_TOTAL].page.box = hbox7;
	app->blks[NOTEPAGE_TOTAL].page.prev = button7;
	app->blks[NOTEPAGE_TOTAL].page.next = button8;
	app->blks[NOTEPAGE_TOTAL].page.info = label8;

	app->blks[NOTEPAGE_FRAG].widget = drawingarea2;
	app->blks[NOTEPAGE_FRAG].scrl_win = scrolledwindow5;
	app->blks[NOTEPAGE_FRAG].page.box = hbox6;
	app->blks[NOTEPAGE_FRAG].page.prev = button5;
	app->blks[NOTEPAGE_FRAG].page.next = button6;
	app->blks[NOTEPAGE_FRAG].page.info = label7;

	app->summary.widget = spinbutton1;

	app->ffrag.widget = clist1;
	app->ffrag.page.box = hbox8;
	app->ffrag.page.prev = button10;
	app->ffrag.page.next = button11;
	app->ffrag.page.info = label10;


	gtk_window_set_position(GTK_WINDOW(window1), GTK_WIN_POS_CENTER);

	gtk_widget_set_sensitive(c_fbview1, FALSE);
	gtk_widget_set_sensitive(c_fbview2, FALSE);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(c_fbview2), TRUE);

	for (i = 0; i < FFILE_INFO_CNT + 1; i++) {
		if (i > 0)
			gtk_clist_set_column_justification
				(GTK_CLIST(clist1), i, GTK_JUSTIFY_RIGHT);
		gtk_clist_set_column_auto_resize(GTK_CLIST(clist1), i, TRUE);
	}

	/* blks size */
	gtk_widget_set_usize (scrolledwindow6, 560, 300);

	gtk_signal_connect (GTK_OBJECT (c_fbview1), "toggled",
	                    GTK_SIGNAL_FUNC (on_fbview_toggled), all);
	gtk_signal_connect (GTK_OBJECT (w_exec), "clicked",
	                    GTK_SIGNAL_FUNC (on_exec_clicked), all);
	gtk_signal_connect (GTK_OBJECT (w_abort), "clicked",
	                    GTK_SIGNAL_FUNC (on_abort_clicked), all);

	gtk_signal_connect (GTK_OBJECT (button7), "clicked",
	                    GTK_SIGNAL_FUNC (on_total_prev_clicked), all);
	gtk_signal_connect (GTK_OBJECT (button8), "clicked",
	                    GTK_SIGNAL_FUNC (on_total_next_clicked), all);

	gtk_signal_connect (GTK_OBJECT (button5), "clicked",
	                    GTK_SIGNAL_FUNC (on_frag_prev_clicked), all);
	gtk_signal_connect (GTK_OBJECT (button6), "clicked",
	                    GTK_SIGNAL_FUNC (on_frag_next_clicked), all);

	gtk_signal_connect (GTK_OBJECT (button10), "clicked",
	                    GTK_SIGNAL_FUNC (on_ffile_prev_clicked), all);
	gtk_signal_connect (GTK_OBJECT (button11), "clicked",
	                    GTK_SIGNAL_FUNC (on_ffile_next_clicked), all);

	gtk_signal_connect (GTK_OBJECT(window1), "delete_event",
		      GTK_SIGNAL_FUNC (on_delete), all);
	/*
	gtk_signal_connect (GTK_OBJECT(window1), "destroy",
		      GTK_SIGNAL_FUNC (destroy),
		      NULL);
		      */
	gtk_combo_set_case_sensitive(GTK_COMBO(combo1), TRUE);
	gtk_combo_set_use_arrows_always(GTK_COMBO(combo1), TRUE);
	gtk_combo_disable_activate(GTK_COMBO(combo1));
	gtk_signal_connect (GTK_OBJECT(GTK_COMBO(combo1)->entry), "changed",
			    GTK_SIGNAL_FUNC (on_device_changed), all);

	gtk_combo_set_case_sensitive(GTK_COMBO(combo2), TRUE);
	gtk_combo_set_use_arrows_always(GTK_COMBO(combo2), TRUE);
	gtk_combo_disable_activate(GTK_COMBO(combo2));
	gtk_signal_connect (GTK_OBJECT(GTK_COMBO(combo2)->entry), "changed",
			    GTK_SIGNAL_FUNC (on_path_changed), all);

	gtk_signal_connect (GTK_OBJECT(area_note), "expose_event",
			    GTK_SIGNAL_FUNC (on_expose_note), all);
	/*gtk_widget_set_events(area_note, GDK_EXPOSURE_MASK);*/

	gtk_signal_connect (GTK_OBJECT(area_fblocks), "expose_event",
			    GTK_SIGNAL_FUNC (on_expose_total_blocks), all);
	/*gtk_widget_set_events(area_fblocks, GDK_EXPOSURE_MASK);*/

	gtk_signal_connect (GTK_OBJECT(drawingarea2), "expose_event",
			    GTK_SIGNAL_FUNC (on_expose_frag_blocks), all);
	/*gtk_widget_set_events(drawingarea2, GDK_EXPOSURE_MASK);*/

	gtk_signal_connect (GTK_OBJECT(notebook1), "switch-page",
			    GTK_SIGNAL_FUNC (on_switch_tab), all);
	/*gtk_widget_set_events(notebook1, GDK_EXPOSURE_MASK);*/

	{
		GtkStyle *style = gtk_style_new();
		style->base[GTK_STATE_NORMAL] =
			app->note.widget->style->bg[GTK_STATE_NORMAL];
		gtk_widget_set_style(app->text.widget, style);
	}

	gtk_signal_connect (GTK_OBJECT (button9), "clicked",
	                    GTK_SIGNAL_FUNC (on_summary_changed), all);

	gtk_signal_connect (GTK_OBJECT (clist1), "select_row",
	                    GTK_SIGNAL_FUNC (on_select_ffile), all);
	gtk_signal_connect (GTK_OBJECT (clist1), "unselect_row",
	                    GTK_SIGNAL_FUNC (on_unselect_ffile), all);

	gtk_signal_connect (GTK_OBJECT (item_version), "activate",
	                    GTK_SIGNAL_FUNC (on_menu_version), all);

	gtk_widget_show(window1);	/* important!!! */

	app->note.pixmap = gdk_pixmap_new(area_note->window,
					  area_note->allocation.width,
					  area_note->allocation.height, -1);
	app->note.width = area_note->allocation.width;
	app->note.height = area_note->allocation.height;

	return window1;
}
