/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbutils;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import javax.sql.DataSource;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.dbutils.ResultSetHandler;

public class QueryRunner {
    protected DataSource ds = null;

    public QueryRunner() {
    }

    public QueryRunner(DataSource ds) {
        this.ds = ds;
    }

    protected void fillStatement(PreparedStatement stmt, Object[] params) throws SQLException {
        if (params == null) {
            return;
        }
        for (int i = 0; i < params.length; ++i) {
            if (params[i] != null) {
                stmt.setObject(i + 1, params[i]);
                continue;
            }
            stmt.setNull(i + 1, 1111);
        }
    }

    public DataSource getDataSource() {
        return this.ds;
    }

    protected PreparedStatement prepareStatement(Connection conn, String sql) throws SQLException {
        return conn.prepareStatement(sql);
    }

    public Object query(Connection conn, String sql, Object param, ResultSetHandler rsh) throws SQLException {
        return this.query(conn, sql, new Object[]{param}, rsh);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object query(Connection conn, String sql, Object[] params, ResultSetHandler rsh) throws SQLException {
        Object result;
        block5: {
            PreparedStatement stmt = null;
            ResultSet rs = null;
            result = null;
            try {
                stmt = this.prepareStatement(conn, sql);
                this.fillStatement(stmt, params);
                rs = this.wrap(stmt.executeQuery());
                result = rsh.handle(rs);
                DbUtils.close(rs);
            }
            catch (SQLException e) {
                this.rethrow(e, sql, params);
                break block5;
            }
            finally {
                DbUtils.close(rs);
                DbUtils.close(stmt);
            }
            DbUtils.close(stmt);
        }
        return result;
    }

    public Object query(Connection conn, String sql, ResultSetHandler rsh) throws SQLException {
        return this.query(conn, sql, null, rsh);
    }

    public Object query(String sql, Object param, ResultSetHandler rsh) throws SQLException {
        return this.query(sql, new Object[]{param}, rsh);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object query(String sql, Object[] params, ResultSetHandler rsh) throws SQLException {
        Connection conn = this.ds.getConnection();
        try {
            Object object = this.query(conn, sql, params, rsh);
            return object;
        }
        finally {
            DbUtils.close(conn);
        }
    }

    public Object query(String sql, ResultSetHandler rsh) throws SQLException {
        return this.query(sql, (Object[])null, rsh);
    }

    protected void rethrow(SQLException cause, String sql, Object[] params) throws SQLException {
        StringBuffer msg = new StringBuffer(cause.getMessage());
        msg.append(" Query: ");
        msg.append(sql);
        msg.append(" Parameters: ");
        if (params == null) {
            msg.append("[]");
        } else {
            msg.append(Arrays.asList(params));
        }
        SQLException e = new SQLException(msg.toString());
        e.setNextException(cause);
        throw e;
    }

    public void setDataSource(DataSource dataSource) {
        this.ds = dataSource;
    }

    public int update(Connection conn, String sql) throws SQLException {
        return this.update(conn, sql, null);
    }

    public int update(Connection conn, String sql, Object param) throws SQLException {
        return this.update(conn, sql, new Object[]{param});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update(Connection conn, String sql, Object[] params) throws SQLException {
        PreparedStatement stmt = null;
        int rows = 0;
        try {
            stmt = this.prepareStatement(conn, sql);
            this.fillStatement(stmt, params);
            rows = stmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                this.rethrow(e, sql, params);
            }
            catch (Throwable throwable) {
                DbUtils.close(stmt);
                throw throwable;
            }
            DbUtils.close(stmt);
        }
        DbUtils.close(stmt);
        return rows;
    }

    public int update(String sql) throws SQLException {
        return this.update(sql, (Object[])null);
    }

    public int update(String sql, Object param) throws SQLException {
        return this.update(sql, new Object[]{param});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update(String sql, Object[] params) throws SQLException {
        Connection conn = this.ds.getConnection();
        try {
            int n = this.update(conn, sql, params);
            return n;
        }
        finally {
            DbUtils.close(conn);
        }
    }

    protected ResultSet wrap(ResultSet rs) {
        return rs;
    }
}

