package org.dbunitng.annotations;

import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * テストメソッド実行後のTearDown処理を指定する。
 * 
 * @author jyukutyo
 * 
 */
@Retention(RUNTIME)
@Target(METHOD)
public @interface TearDownOperation {

	/**
	 * TearDown処理において、データベースのテーブルに対して行う処理を指定する。
	 * 
	 * @return データベースのテーブルに対して行う処理方法
	 */
	DatabaseOperationType value();

	/**
	 * TearDown処理において投入する後処理データを記述したファイルを指定する。
	 * 「hoge.xml」のようにファイル名のみ指定した場合、テストクラスのパッケージにある該当ファイルを読み込む。
	 * 「aaa/bbb/ccc/hoge.
	 * xml」のように「/」を交えてディレクトリを指定した場合、クラスパスのルートから階層をたどり、該当ファイルを読み込む。
	 * 
	 * @return 後処理データを記述したファイル
	 */
	String pathname();

}
