package org.dbunitng.listeners.internal;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.dbunitng.exception.DbUnitNGRuntimeException;
import org.testng.ISuite;
import org.testng.ITestContext;

/**
 * データベースへの接続情報。
 * 
 * @author jyukutyo
 * 
 */
public class DbUnitNGConfig {

	/** Suiteに記述するデータソースのパラメータへのキー */
	private static final String DATASOURCE_PARAMETER = "datasource";

	/** Suiteに記述するデータソースでDBCPを指定するときの値 */
	private static final String DBCP = "dbcp";

	/** Suiteに記述するJDBCドライバクラスのパラメータへのキー */
	private static final String DRVIER = "driver";

	/** Suiteに記述するJDBC URLのパラメータへのキー */
	private static final String URL = "url";

	/** Suiteに記述するJDBCユーザー名のパラメータへのキー */
	private static final String USERNAME = "username";

	/** Suiteに記述するJDBCパスワードのパラメータへのキー */
	private static final String PASSWORD = "password";

	private String driver;

	private String url;

	private String userName;

	private String password;

	private boolean isDbcp;

	public String getDriver() {
		return driver;
	}

	public void setDriver(String driver) {
		this.driver = driver;
	}

	public String getUrl() {
		return url;
	}

	public void setUrl(String url) {
		this.url = url;
	}

	public String getUserName() {
		return userName;
	}

	public void setUserName(String userName) {
		this.userName = userName;
	}

	public String getPassword() {
		return password;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public boolean isDbcp() {
		return isDbcp;
	}

	public void setDbcp(boolean isDbcp) {
		this.isDbcp = isDbcp;
	}

	/**
	 * コンテキストから接続情報を生成する。
	 * 
	 * @param context
	 *            コンテキスト
	 * @return 接続情報
	 */
	public static DbUnitNGConfig create(ITestContext context) {

		DbUnitNGConfig config = new DbUnitNGConfig();
		ISuite suite = context.getSuite();
		config.setDriver(suite.getParameter(DRVIER));
		config.setPassword(suite.getParameter(PASSWORD));
		config.setUrl(suite.getParameter(URL));
		config.setUserName(suite.getParameter(USERNAME));

		String ds = suite.getParameter(DATASOURCE_PARAMETER);
		if (DBCP.equalsIgnoreCase(ds)) {
			config.setDbcp(true);
		}

		return config;
	}

	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(
			this,
			ToStringStyle.MULTI_LINE_STYLE);
	}

	/**
	 * 接続情報がnullでないか検証する。
	 */
	public void verifyParamsNotNull() {
		boolean isInvalid =
			this.driver == null || this.url == null || this.userName == null
				|| this.password == null;
		if (isInvalid) {
			throw new DbUnitNGRuntimeException(
				"Required Parameters are not specified in TestNG Suite."
					+ toString());
		}
	}
}
