/*
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.dbunitng.annotations;

import org.dbunit.dataset.datatype.IDataTypeFactory;
import org.dbunit.ext.db2.Db2DataTypeFactory;
import org.dbunit.ext.h2.H2DataTypeFactory;
import org.dbunit.ext.hsqldb.HsqldbDataTypeFactory;
import org.dbunit.ext.mssql.MsSqlDataTypeFactory;
import org.dbunit.ext.mysql.MySqlDataTypeFactory;
import org.dbunit.ext.oracle.OracleDataTypeFactory;

/**
 * データベースの種類。
 * 
 * @author jyukutyo
 * 
 */
public enum DatabaseType {

	ORACLE("oracle", new OracleDataTypeFactory()),

	SQLSERVER("sqlserver", new MsSqlDataTypeFactory()),

	DB2("db2", new Db2DataTypeFactory()),

	HSQLDB("hsqldb", new HsqldbDataTypeFactory()),

	H2("h2", new H2DataTypeFactory()),

	MYSQL("mysql", new MySqlDataTypeFactory()),

	OTHER("", null);

	/** データベース名 */
	private String name;

	/** データタイプのファクトリ */
	private IDataTypeFactory factory;

	/**
	 * プライベートコンストラクタ。
	 * 
	 * @param name
	 *            データベース名
	 * @param factory
	 *            データタイプのファクトリ
	 */
	private DatabaseType(String name, IDataTypeFactory factory) {
		this.name = name;
		this.factory = factory;
	}

	@Override
	public String toString() {
		return this.name;
	}

	/**
	 * データタイプのファクトリを返す。
	 * 
	 * @return データタイプのファクトリ
	 */
	public IDataTypeFactory getDataTypeFactory() {
		return this.factory;
	}

}
