package zigen.plugin.db.ui.jobs;

import java.sql.SQLException;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.IDE;

import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.DbPluginConstant;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.SQLInvoker;
import zigen.plugin.db.core.SQLTokenizer;
import zigen.plugin.db.core.SQLUtil;
import zigen.plugin.db.core.SelectIntoChecker;
import zigen.plugin.db.core.TableElement;
import zigen.plugin.db.core.TimeWatcher;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.preference.SQLEditorPreferencePage;
import zigen.plugin.db.ui.actions.ConfirmConnectDBAction;
import zigen.plugin.db.ui.actions.MaxRecordException;
import zigen.plugin.db.ui.editors.QueryViewEditor2;
import zigen.plugin.db.ui.editors.QueryViewEditorInput;

public class SqlExecJob extends AbstractJob {

	private Transaction trans;

	private String sqlString;

	String secondarlyId;

	private int executeCount;

	public SqlExecJob(Transaction trans, String sqlString, String secondarlyId) {
		super(Messages.getString("SqlExecJob.0")); //$NON-NLS-1$
		this.trans = trans;
		this.sqlString = sqlString;
		this.secondarlyId = secondarlyId;
	}

	protected IStatus run(IProgressMonitor monitor) {
		try {
			start();
			String demiliter = DbPlugin.getDefault().getPreferenceStore().getString(SQLEditorPreferencePage.P_SQL_DEMILITER);

			if (!trans.isConneting()) {
				Display.getDefault().syncExec(new ConfirmConnectDBAction(trans));
				if (!trans.isConneting()) {
					showWarningMessage(DbPluginConstant.MSG_NO_CONNECTED_DB);
					return Status.CANCEL_STATUS;
				}
			}

			if (monitor.isCanceled()) {
				return Status.CANCEL_STATUS;
			}

			SQLTokenizer tokenizer = new SQLTokenizer(sqlString, demiliter);
			while (tokenizer.hasMoreElements()) {
				String sql = tokenizer.nextToken();
				if (sql != null && sql.length() > 0) {
					executeSingleSQL(trans, sql);
					executeCount++; // ssJEg
				}
				if (monitor.isCanceled()) {
					return Status.CANCEL_STATUS;
				}

			}

			return Status.OK_STATUS;

		} catch (SQLException e) {
			showWarningMessage(e.getMessage());

		} catch (Exception e) {
			showErrorMessage(Messages.getString("SqlExecJob.2"), e); //$NON-NLS-1$

		} finally {
			stop();
			// Ԃ̕\
			// updateResponseTime(getTotalTime());
		}
		return Status.OK_STATUS; // G[_CAO\邽߂OKŕԂ

	}

	private void executeSingleSQL(Transaction trans, String sql) throws Exception {
		if (SelectIntoChecker.check(sql)) {
			execute(sql);
		} else {
			if (SQLUtil.isSelect(sql)) {
				showDBEditor(sql);

			} else {
				// PLSQLpSQL̉sȂ悤ɁAătH[}bg
				if (sql.toLowerCase().startsWith("create")) { //$NON-NLS-1$
					// PLSQLȊOCREATEʂB

					// sR[h\nłȂƁAPLS-00103邽߁Au
					String unsql = sql.replaceAll("\r", "\n"); //$NON-NLS-1$ //$NON-NLS-2$
					execute(unsql);

				} else {
					executeUpdate(sql);
				}
			}
		}
	}

	private void showDBEditor(String query) throws Exception {
		TableElement[] elements = null;
		TimeWatcher time = new TimeWatcher();
		time.start();

		try {
			IDBConfig config = trans.getConfig();
			elements = SQLInvoker.executeQuery(trans.getConnection(), query, config.isConvertUnicode(), config.isNoLockMode());
			time.stop();
			showResults(new ShowResultAction(trans.getConfig(), query, elements, time.getTotalTime()));

		} catch (MaxRecordException e) {
			time.stop();
			elements = e.getTableElements();
			showResults(new ShowResultAction(trans.getConfig(), query, elements, time.getTotalTime(),e.getMessage()));
//			showWarningMessage(e.getMessage());

		} catch (Exception e) {
			throw e;

		}
		// DbPlugin.log("SQLsʂN鎞ԁF" + time.getTotalTime());
	}

	private void executeUpdate(String sql) throws Exception {
		String message = null;
		if (sql.toLowerCase().equals("commit")) { //$NON-NLS-1$
			message = createCommitMessage(trans.getTransactionCount());
			trans.commit();

		} else if (sql.toLowerCase().equals("rollback")) { //$NON-NLS-1$
			message = createRollbackMessage(trans.getTransactionCount());
			trans.rollback();

		} else {
			int rowAffected = SQLInvoker.executeUpdate(trans.getConnection(), sql);
			//if (!trans.getConfig().isAutoCommit()) {
			//	trans.setCount(rowAffected); // gUNVNXɍXVǉ
			//}
			trans.addCount(rowAffected); // gUNVNXɍXVǉ	
			message = createQueryMessage(trans.getTransactionCount());
			
			
			if (trans.getConfig().isAutoCommit()){
				trans.resetCount(); // XVNA
			}
				
		}

		updateMessage(trans.getConfig(), message, secondarlyId);
	}

	private void execute(String sql) throws Exception {
		String message = null;
		boolean b = SQLInvoker.execute(trans.getConnection(), sql);
		if (b) {
			message = Messages.getString("SqlExecJob.8"); //$NON-NLS-1$
		}
		updateMessage(trans.getConfig(), message, secondarlyId);
	}

	String createQueryMessage(int count) {
		StringBuffer sb = new StringBuffer();
		sb.append(Messages.getString("SqlExecJob.9")); //$NON-NLS-1$
		sb.append(Messages.getString("SqlExecJob.10")); //$NON-NLS-1$
		sb.append(count);
		sb.append(Messages.getString("SqlExecJob.11")); //$NON-NLS-1$
		return sb.toString();
	}

	String createCommitMessage(int count) {
		return count + Messages.getString("SqlExecJob.12"); //$NON-NLS-1$
	}

	String createRollbackMessage(int count) {
		return count + Messages.getString("SqlExecJob.13"); //$NON-NLS-1$
	}

	protected class ShowResultAction implements Runnable {
		IDBConfig config = null;

		String query = null;

		TableElement[] elements = null;

		String responseTime = null;

		String message = ""; //$NON-NLS-1$
		
		public ShowResultAction(IDBConfig config, String query, TableElement[] elements, String responseTime, String message) {
			this.config = config;
			this.query = query;
			this.elements = elements;
			this.responseTime = responseTime;
			this.message = message;
		}

		public ShowResultAction(IDBConfig config, String query, TableElement[] elements, String responseTime) {
			this(config, query, elements, responseTime, ""); //$NON-NLS-1$
		}
		
		public void run() {
			try {
				IWorkbenchPage page = DbPlugin.getDefault().getPage();
				QueryViewEditorInput input = new QueryViewEditorInput(config, query, secondarlyId);
				IEditorPart editor = IDE.openEditor(page, input, DbPluginConstant.EDITOR_ID_QueryView2, false);

				if (editor instanceof QueryViewEditor2) {
					QueryViewEditor2 tEditor = (QueryViewEditor2) editor;
					tEditor.update(query, elements, responseTime);
					tEditor.setInfomationText(message);

				}
			} catch (Exception e) {
				DbPlugin.log(e);
			}

		}
	}

	public int getExecuteCount() {
		return executeCount;
	}

}
