/*
 * 쐬: 2005/03/12
 * 쌠: Copyright (c) 2005 ZIGEN
 * CZXFCommon Public License - v 1.0
 * Fhttp://www.eclipse.org/legal/cpl-v10.html
 */
package zigen.plugin.db.ui.actions;

import java.io.File;
import java.io.FileInputStream;

import org.eclipse.jface.action.Action;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.InputStreamUtil;
import zigen.plugin.db.ui.views.internal.SQLSourceViewer;

/**
 * CreateCSVActionNX.
 * 
 * @author ZIGEN
 * @version 1.0
 * @since JDK1.4 history Symbol Date Person Note [1] 2005/07/08 ZIGEN create.
 * 
 */
public class OpenSQLAction extends Action {
	private SQLSourceViewer viewer = null;

	/**
	 * RXgN^
	 * 
	 * @param viewer
	 */
	public OpenSQLAction(SQLSourceViewer viewer) {
		this.viewer = viewer;
		this.setText(Messages.getString("OpenSQLAction.0")); //$NON-NLS-1$
		this.setToolTipText(Messages.getString("OpenSQLAction.1")); //$NON-NLS-1$
		this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(ISharedImages.IMG_OBJ_FOLDER));

	}

	/**
	 * Actions̏
	 */
	public void run() {
		try {
			Shell shell = DbPlugin.getDefault().getShell();
			// Shell shell = viewer.getControl().getShell();
			FileDialog dialog = new FileDialog(shell, SWT.OPEN);
			if (viewer.getSqlFileName() != null) {
				dialog.setFileName(viewer.getSqlFileName());
			}
			dialog.setFilterExtensions(new String[] {
					"*.sql", "*.*" //$NON-NLS-1$ //$NON-NLS-2$
			});
			dialog.setFilterNames(new String[] {
					Messages.getString("OpenSQLAction.4"), Messages.getString("OpenSQLAction.5") //$NON-NLS-1$ //$NON-NLS-2$
					});
			String fileName = dialog.open();

			// LZ̏
			if (fileName == null)
				return;

			File file = new File(fileName);
			if (file.exists() && file.canRead()) {
				String sqlData = InputStreamUtil.toString(new FileInputStream(file));
				viewer.getDocument().set(sqlData);

				viewer.setSqlFileName(file.getName());
			}

		} catch (Exception e) {
			DbPlugin.getDefault().showErrorDialog(e);
		}
	}

}
