/*
 * 쐬: 2005/03/18
 * 쌠: Copyright (c) 2005 ZIGEN
 * CZXFCommon Public License - v 1.0
 * Fhttp://www.eclipse.org/legal/cpl-v10.html
 */
package zigen.plugin.db.ui.editors.internal;

import org.eclipse.core.internal.runtime.Log;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

import zigen.plugin.db.core.TableColumn;
import zigen.plugin.db.core.TableElement;
import zigen.plugin.db.ui.internal.Column;
import zigen.plugin.db.ui.internal.ITable;

/**
 * NULL̐FύX{JI̔wiFύX.
 * 
 * @author ZIGEN
 * @version 1.0
 * @since JDK1.4 history Symbol Date Person Note [1] 2005/12/13 ZIGEN create.
 * 
 */
public class ChangeColorAction extends ForegroundColorUpdateAction implements Runnable {

	protected Color glay;

	protected Color white;

	protected Column col;

	protected ITable tableNode;

	public ChangeColorAction(Table targetTable) {
		this(targetTable, null);
	}

	public ChangeColorAction(Table targetTable, ITable targetTableNode) {
		super(targetTable);
		this.glay = new Color(targetTable.getDisplay(), 178, 180, 191);
		this.white = targetTable.getDisplay().getSystemColor(SWT.COLOR_WHITE);
		this.tableNode = targetTableNode;
	}

	public void setSelectedColumn(Column column) {
		this.col = column;
	}

	protected void updateRecord(int rowIndex, int columnSize, String nullSymbol) {

		TableItem item = table.getItem(rowIndex);
		TableElement elem = (TableElement) item.getData();
		TableColumn[] tableColmns = elem.getColumns();

		Color bgcolor;
		if (rowIndex % 2 == 0) {
			bgcolor = white;
		} else {
			bgcolor = lightblue;
		}
		// sԍ̔wiFύX
		item.setBackground(0, bgcolor); // wiF

		if (tableNode == null || col == null) {
			// ʏ
			for (int k = 0; k < columnSize - 1; k++) {
				TableColumn tCol = tableColmns[k];
				// JvȂꍇ
				if (nullSymbol.equals(item.getText(k + 1))) {
					item.setForeground(k + 1, blue); // // NULLF
				} else {
					item.setForeground(k + 1, black); // // NULLȊO F()
				}
				item.setBackground(k + 1, bgcolor); // wiF
			}
		} else {
			// JI[h
			ITable targetTable = col.getTable();
			for (int k = 0; k < columnSize - 1; k++) {
				TableColumn tCol = tableColmns[k];
				if (targetTable.equals(tableNode) && tCol.getColumnName().equals(col.getName())) {
					// Jvꍇ(IԂɂ)
					// item.setForeground(k + 1, white); // F
					item.setForeground(k + 1, black); // F
					item.setBackground(k + 1, glay); // wiF
					table.showColumn(table.getColumn(k + 1)); // J\(XN[)

				} else {
					// JvȂꍇ
					if (nullSymbol.equals(item.getText(k + 1))) {
						item.setForeground(k + 1, blue); // // NULLF
					} else {
						item.setForeground(k + 1, black); // // NULLȊO F()
					}
					item.setBackground(k + 1, bgcolor); // wiF

				}
			}
		}

	}

}