/*
 * 쐬: 2005/05/13
 * 쌠: Copyright (c) 2005 ZIGEN
 * CZXFCommon Public License - v 1.0
 * Fhttp://www.eclipse.org/legal/cpl-v10.html
 */
package zigen.plugin.db.ui.editors.internal.action;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.ISharedImages;

import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.ui.actions.TableViewEditorAction;
import zigen.plugin.db.ui.editors.TableViewEditorFor31;
import zigen.plugin.db.ui.editors.internal.invoker.AbstractSQLInvoker;
import zigen.plugin.db.ui.editors.internal.invoker.DropIndexInvoker;
import zigen.plugin.db.ui.internal.ITable;
import zigen.plugin.db.ui.internal.Index;

/**
 * InsertRecordActionNX.
 * 
 * @author ZIGEN
 * @version 1.0
 * @since JDK1.4 history Symbol Date Person Note [1] 2005/03/12 ZIGEN create.
 * 
 */
public class DropIndexAction extends TableViewEditorAction {

	public DropIndexAction() {
		this.setText(Messages.getString("DropIndexAction.0")); //$NON-NLS-1$
		this.setToolTipText(Messages.getString("DropIndexAction.1")); //$NON-NLS-1$
		this.setImageDescriptor(ISharedImages.IMG_TOOL_DELETE);
	}

	public void run() {

		try {
			if (editor instanceof TableViewEditorFor31) {
				TableViewEditorFor31 tEditor = (TableViewEditorFor31) editor;

				IStructuredSelection selection = (IStructuredSelection) tEditor.getTableDefineEditor().getConstraintViewer().getSelection();

				Object obj = selection.getFirstElement();
				if (obj instanceof Index) {
					Index index = (Index) obj;

					IDBConfig config = tEditor.getDBConfig();
					ITable table = tEditor.getTableNode();

					AbstractSQLInvoker invoker;
					if (DbPlugin.getDefault().confirmDialog(Messages.getString("DropIndexAction.2"))) { //$NON-NLS-1$
						invoker = new DropIndexInvoker(table, index.getName());
						invoker.execute();
					}

				} else {
					throw new IllegalStateException("z肵ĂNXł͂܂ " + obj.getClass().getName()); //$NON-NLS-1$
				}
			}
		} catch (Exception e) {
			DbPlugin.getDefault().showErrorDialog(e);
		}

	}

}
