package zigen.plugin.db.ui.editors.internal.invoker;

import java.sql.Connection;

import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.StatusChangeListener;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.SQLInvoker;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.core.rule.AbstractSQLCreatorFactory;
import zigen.plugin.db.core.rule.ISQLCreatorFactory;
import zigen.plugin.db.ui.internal.ITable;

abstract public class AbstractSQLInvoker {


	protected ITable table;

	protected IDBConfig config;

	protected String threadTitle;

	protected ISQLCreatorFactory factory;

	public AbstractSQLInvoker(String threadTitle, ITable table) {
		this.threadTitle = (threadTitle == null) ? "" : threadTitle; //$NON-NLS-1$
		this.table = table;
		this.config = table.getDbConfig();
		this.factory = AbstractSQLCreatorFactory.getFactory(config, table);
	}

	public boolean execute() {
		String _sql = ""; //$NON-NLS-1$
		try {

			String[] sqls = createSQL(factory, table);

			if (sqls == null || sqls.length == 0) {
				DbPlugin.getDefault().showWaringMessage(Messages.getString("AbstractSQLInvoker.2")); //$NON-NLS-1$
				return false;
			}

			Connection con = Transaction.getInstance(table.getDbConfig()).getConnection();
			for (int i = 0; i < sqls.length; i++) {
				_sql = sqls[i];
				SQLInvoker.execute(con, _sql);
			}

			doUpdateAfter(table);

			Transaction trans = Transaction.getInstance(config);
			if (!config.isAutoCommit() && factory.supportsRollbackDDL()) {
				if (DbPlugin.getDefault().confirmDialog(Messages.getString("AbstractSQLInvoker.3"))) { //$NON-NLS-1$
					trans.commit();
				}
			}
			StatusChangeListener.fireStatusChangeListener(table, StatusChangeListener.EVT_ModifyTableDefine);

			return true;

		} catch (Exception e) {
			return handleException(e, _sql);
		}
	}

	abstract public String[] createSQL(ISQLCreatorFactory factory, ITable table);

	protected boolean handleException(Exception e, String executedSql) {
		DbPlugin.log(Messages.getString("AbstractSQLInvoker.4") + executedSql); //$NON-NLS-1$
		DbPlugin.getDefault().showErrorDialog(e);
		return false;
	}

	// XVɕKvȏ
	protected void doUpdateAfter(ITable table) {
		;
	}

}