package zigen.plugin.db.ui.editors.internal.invoker;

import zigen.plugin.db.core.rule.ISQLCreatorFactory;
import zigen.plugin.db.ui.internal.Constraint;
import zigen.plugin.db.ui.internal.ITable;

public class DropConstraintInvoker extends AbstractSQLInvoker {


	private static String TITLE = Messages.getString("DropConstraintInvoker.0"); //$NON-NLS-1$

	private Constraint constraint;

	public DropConstraintInvoker(ITable table, Constraint constraint) {
		super(TITLE, table);
		this.constraint = constraint;
	}

	public String[] createSQL(ISQLCreatorFactory factory, ITable table) {
		String sql = factory.createDropConstraintDDL(constraint.getName(), constraint.getType());
		return new String[] {
			sql
		};
	}

}