package zigen.plugin.db.ui.editors.internal.invoker;

import java.util.ArrayList;
import java.util.List;

import zigen.plugin.db.core.rule.ISQLCreatorFactory;
import zigen.plugin.db.ui.internal.Column;
import zigen.plugin.db.ui.internal.ITable;

public class ModifyColumnInvoker extends AbstractSQLInvoker {


	private static String TITLE = Messages.getString("ModifyColumnInvoker.0"); //$NON-NLS-1$

	private Column fromColumn;

	private Column toColumn;

	public ModifyColumnInvoker(ITable table, Column fromColumn, Column toColumn) {
		super(TITLE, table);
		this.fromColumn = fromColumn;
		this.toColumn = toColumn;
	}

	public String[] createSQL(ISQLCreatorFactory factory, ITable table) {
		List list = new ArrayList();
		// J̕ύX
		if (!fromColumn.getName().equals(toColumn.getName())) {
			list.add(factory.createRenameColumnDDL(fromColumn, toColumn));
		}
		// J^E̕ύX
		if (fromColumn.getTypeName().equals(toColumn.getTypeName()) || fromColumn.getSize().equals(toColumn.getSize()) || fromColumn.getDefaultValue().equals(toColumn.getDefaultValue())
				|| fromColumn.isNotNull() == toColumn.isNotNull()) {

			String[] sqls = factory.createModifyColumnDDL(fromColumn, toColumn);
			for (int i = 0; i < sqls.length; i++) {
				list.add(sqls[i]);
			}
		}
		// JRg̐ݒ
		list.add(factory.createCommentOnColumnDDL(toColumn));

		return (String[]) list.toArray(new String[0]);
	}

}